/*
     This file is part of GNUnet.
     (C) 2005, 2006, 2007 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/namespace_search.h
 * @brief code for namespace-related operations on the search frame
 * @author Christian Grothoff
 */
#ifndef NAMESPACE_SEARCH_H
#define NAMESPACE_SEARCH_H

/**
 * Call this function to inform the user about
 * newly found namespaces and to add them to the
 * list of available namespaces in the search
 * dialog.
 *
 * @param cls pass NULL
 * @param rating the local rating of the namespace
 * @return OK (always)
 */
int namespace_discovered_cb (void *cls,
                             const char *namespaceName,
                             const HashCode512 * namespaceId,
                             const struct ECRS_MetaData *md, int rating);



#endif
