/*
     This file is part of GNUnet.
     (C) 2005, 2006, 2007 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/namespace.c
 * @brief operations creating namespaces
 * @author Christian Grothoff
 */

#include "platform.h"
#include "gnunetgtk_common.h"
#include "fs.h"
#include "helper.h"
#include "meta.h"
#include "namespace.h"
#include "content_tracking.h"
#include <GNUnet/gnunet_util_crypto.h>
#include <GNUnet/gnunet_uritrack_lib.h>
#include <GNUnet/gnunet_namespace_lib.h>
#include <extractor.h>


static GladeXML *metaXML;


void
on_namespacemetaDataDialogKeywordRemoveButton_clicked_fs (gpointer dummy,
                                                          GtkWidget *
                                                          uploadButton)
{
  handleListRemove (metaXML, "namespaceMetaDataDialogKeywordList");
}

void
on_namespacemetaDataDialogMetaDataRemoveButton_clicked_fs (gpointer dummy,
                                                           GtkWidget *
                                                           uploadButton)
{
  handleListRemove (metaXML, "namespaceMetaDataDialogMetaDataList");
}

void
on_namespacemetaDataDialogKeywordAddButton_clicked_fs (gpointer dummy,
                                                       GtkWidget *
                                                       uploadButton)
{
  handleKeywordListUpdate (metaXML,
                           "namespaceKeywordEntry",
                           "namespaceMetaDataDialogKeywordList");
}

void
on_namespacemetaDataDialogMetaDataAddButton_clicked_fs (gpointer dummy,
                                                        GtkWidget *
                                                        uploadButton)
{
  handleMetaDataListUpdate (metaXML,
                            "namespaceMetaDataDialogMetaTypeComboBox",
                            "namespaceMetaDataValueEntry",
                            "namespaceMetaDataDialogMetaDataList");
}

/**
 * The selection of the keyword list changed.
 * Update button status.
 */
static void
on_keyword_list_selection_changed (gpointer signal, gpointer cls)
{
  GtkTreeSelection *selection;
  GtkWidget *button;

  selection =
    gtk_tree_view_get_selection (GTK_TREE_VIEW
                                 (glade_xml_get_widget
                                  (metaXML,
                                   "namespaceMetaDataDialogKeywordList")));
  button =
    glade_xml_get_widget (metaXML, "nsMetaDataDialogKeywordRemoveButton");
  gtk_widget_set_sensitive (button,
                            gtk_tree_selection_count_selected_rows (selection)
                            > 0);
}

/**
 * The selection of the metadata list changed.
 * Update button status.
 */
static void
on_metadata_list_selection_changed (gpointer signal, gpointer cls)
{
  GtkTreeSelection *selection;
  GtkWidget *button;

  selection =
    gtk_tree_view_get_selection (GTK_TREE_VIEW
                                 (glade_xml_get_widget
                                  (metaXML,
                                   "namespaceMetaDataDialogMetaDataList")));
  button =
    glade_xml_get_widget (metaXML, "nsMetaDataDialogMetaDataRemoveButton");
  gtk_widget_set_sensitive (button,
                            gtk_tree_selection_count_selected_rows (selection)
                            > 0);
}

/**
 * The user has edited the metadata entry.
 * Update add button status.
 */
void
on_namespaceMetaDataValueEntry_changed_fs (gpointer dummy2,
                                           GtkWidget * searchEntry)
{
  const char *input;
  GtkWidget *button;

  input = gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget (metaXML,
                                                               "namespaceMetaDataValueEntry")));
  if (input == NULL)
    return;
  button
    = glade_xml_get_widget (metaXML, "nsMetaDataDialogMetaDataAddButton");
  gtk_widget_set_sensitive (button, strlen (input) > 0);
}

/**
 * The user has edited the keyword entry.
 * Update add button status.
 */
void
on_namespaceKeywordEntry_changed_fs (gpointer dummy2, GtkWidget * searchEntry)
{
  const char *input;
  GtkWidget *button;

  input = gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget (metaXML,
                                                               "namespaceKeywordEntry")));
  if (input == NULL)
    return;
  button = glade_xml_get_widget (metaXML, "nsMetaDataDialogKeywordAddButton");
  gtk_widget_set_sensitive (button, strlen (input) > 0);
}


void
create_namespace_clicked_fs (GtkWidget * dummy1, GtkWidget * dummy2)
{
  const char *namespaceName;
  GtkWidget *nameLine;
  GtkWidget *dialog;
  GtkWidget *spin;
  struct ECRS_MetaData *meta;
  struct ECRS_URI *keywordURI;
  struct ECRS_URI *root;
  HashCode512 namespaceId;
  HashCode512 rootEntry;

  DEBUG_BEGIN ();
  metaXML
    = glade_xml_new (getGladeFileName (),
                     "namespaceMetaDataDialog", PACKAGE_NAME);
  connectGladeWithPlugins (metaXML);
  dialog = glade_xml_get_widget (metaXML, "namespaceMetaDataDialog");
  createMetaDataListTreeView (metaXML,
                              "namespaceMetaDataDialogMetaDataList",
                              NULL, NULL);
  g_signal_connect_data (gtk_tree_view_get_selection
                         (GTK_TREE_VIEW
                          (glade_xml_get_widget
                           (metaXML, "namespaceMetaDataDialogMetaDataList"))),
                         "changed",
                         G_CALLBACK (&on_metadata_list_selection_changed),
                         NULL, NULL, 0);
  createKeywordListTreeView (metaXML, "namespaceMetaDataDialogKeywordList",
                             NULL);
  g_signal_connect_data (gtk_tree_view_get_selection
                         (GTK_TREE_VIEW
                          (glade_xml_get_widget
                           (metaXML, "namespaceMetaDataDialogKeywordList"))),
                         "changed",
                         G_CALLBACK (&on_keyword_list_selection_changed),
                         NULL, NULL, 0);

  createMetaTypeComboBox (metaXML, "namespaceMetaDataDialogMetaTypeComboBox");
  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
    {
      meta
        = getMetaDataFromList (metaXML,
                               "namespaceMetaDataDialogMetaDataList", NULL);
      keywordURI
        = getKeywordURIFromList (metaXML,
                                 "namespaceMetaDataDialogKeywordList");
      spin = glade_xml_get_widget (metaXML, "namespaceAnonymityspinbutton");
      nameLine = glade_xml_get_widget (metaXML, "namespaceRootEntry");
      namespaceName = gtk_entry_get_text (GTK_ENTRY (nameLine));
      if (namespaceName == NULL)
        namespaceName = "root"; /* do NOT translate "root"! */
      hash (namespaceName, strlen (namespaceName), &rootEntry);
      nameLine = glade_xml_get_widget (metaXML, "namespaceNameEntry");
      namespaceName = gtk_entry_get_text (GTK_ENTRY (nameLine));
      root = NS_createNamespace (ectx, cfg, gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin)), 1000,    /* FIXME: priority */
                                 get_time () + 2 * cronYEARS,   /* FIXME: expiration */
                                 namespaceName, meta, keywordURI, &rootEntry);
      if (root != NULL)
        {
          ECRS_getNamespaceId (root, &namespaceId);
          addTabForNamespace (NULL, namespaceName, &namespaceId, meta, 0);
          ECRS_freeUri (root);
        }
      else
        {
          GtkWidget *dialog;

          /* IMPROVE-ME: we could check if the
             namespace exists as the user
             enters its name and disable the
             "Ok" button unless the name is unique */
          dialog = gtk_message_dialog_new
            (NULL,
             GTK_DIALOG_MODAL,
             GTK_MESSAGE_ERROR,
             GTK_BUTTONS_CLOSE,
             _("Failed to create namespace `%s'."
               "Consult logs, most likely error is"
               " that a namespace with that name "
               "already exists."), namespaceName);
          gtk_dialog_run (GTK_DIALOG (dialog));
          gtk_widget_destroy (dialog);
        }
      ECRS_freeMetaData (meta);
      ECRS_freeUri (keywordURI);
    }
  gtk_widget_destroy (dialog);
  UNREF (metaXML);
  metaXML = NULL;
  DEBUG_END ();
}
