/*
     This file is part of GNUnet.
     (C) 2005, 2006, 2007 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/helper.c
 * @brief helper functions (parsing)
 * @author Christian Grothoff
 */

#include "platform.h"
#include "gnunetgtk_common.h"
#include "helper.h"
#include "fs.h"
#include "search.h"

/**
 * Parse a time given in the form
 * "XX seconds yy days zz months".
 *
 * @param val set to the computed time
 * @return OK on success, SYSERR on error
 */
int
parseTime (const char *t, TIME_T * param)
{
  int pos;
  int start;
  unsigned int val;
  char *tmp;
  cron_t ret;

  ret = 0;
  pos = 0;

  while (t[pos] != '\0')
    {
      start = pos;
      while ((isdigit (t[pos])) && (t[pos] != '\0'))
        pos++;
      tmp = STRNDUP (&t[start], pos - start);
      if (1 != sscanf (tmp, "%u", &val))
        return -1;              /* parse error */
      FREE (tmp);
      while (t[pos] == ' ')
        pos++;
      start = pos;
      while ((t[pos] != ' ') && (t[pos] != '\0'))
        pos++;
      if (0 == strncasecmp (&t[start], _("ms"), strlen (_("ms"))))
        ret += cronMILLIS * val;
      if (0 == strncasecmp (&t[start], _("minutes"), strlen (_("minutes"))))
        ret += cronMINUTES * val;
      else if (0 == strncasecmp (&t[start],
                                 _("seconds"), strlen (_("seconds"))))
        ret += cronSECONDS * val;
      else if (0 == strncasecmp (&t[start], _("hours"), strlen (_("hours"))))
        ret += cronHOURS * val;
      else if (0 == strncasecmp (&t[start], _("days"), strlen (_("days"))))
        ret += cronDAYS * val;
      else
        if (0 == strncasecmp (&t[start], _("minute"), strlen (_("minute"))))
        ret += cronMINUTES * val;
      else if (0 == strncasecmp (&t[start],
                                 _("second"), strlen (_("second"))))
        ret += cronSECONDS * val;
      else if (0 == strncasecmp (&t[start], _("hour"), strlen (_("hour"))))
        ret += cronHOURS * val;
      else if (0 == strncasecmp (&t[start], _("day"), strlen (_("day"))))
        ret += cronDAYS * val;
      else if (0 == strncasecmp (&t[start], "m", strlen ("m")))
        ret += cronMINUTES * val;
      else if (0 == strncasecmp (&t[start], "s", strlen ("s")))
        ret += cronSECONDS * val;
      else if (0 == strncasecmp (&t[start], "h", strlen ("h")))
        ret += cronHOURS * val;
      else
        return SYSERR;          /* parse error */
      while (t[pos] == ' ')
        pos++;
    }
  *param = ret / cronSECONDS;
  return OK;
}
