/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * GnoWavCut -- a GNOME/GTK+ based RIFF PCM Wave file splitter
 * Copyright (C) 2000 Yoichi Imai <yoichi@silver-forest.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "main.h"
typedef enum {
	SPLIT_CANCEL,
	SPLIT_SUCCESS,
	SPLIT_ERROR
} SplitStatus;

typedef struct _TimeData {
	guint32 start;
	guint32 end;
} TimeData;

typedef struct _SplitDialog {
	GtkWindow *parent_window;
	GtkWidget *dialog;
	GtkWidget *label_all;
	GtkObject *hadj_all;
	GtkWidget *label_filename;
	GtkWidget *progress_all;
	GtkWidget *label_file;
	GtkObject *hadj_file;
	GtkWidget *progress_file;

	gchar *dir_name;
	gchar *base_name;
	gchar *old_wave_name;

	SplitStatus status;
	gchar *error_msg;

	int max_file_num;
	int file_num;
	int safely_base_num;

	gboolean use_filter;
	WaveInfo *wave_info;
	GSList *timelist;
} SplitDialog;

void split_start_cb(GtkWidget *widget, gpointer data);
void split_start_with_filtering_cb(GtkWidget *widget, gpointer data);

/*
#define GDK_THREADS_LEAVE_FORCELY() { \
 if(gdk_threads_mutex) { \
   if(g_mutex_trylock(gdk_threads_mutex) == FALSE) \
      g_mutex_unlock(gdk_threads_mutex); \
   else \
      g_mutex_unlock(gdk_threads_mutex); \
 } \
}
*/
