// -*- c++ -*-

//  Gnomoradio - rainbow/license.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __RAINBOW_LICENSE_H
#define __RAINBOW_LICENSE_H

#include <map>
#include <set>
#include <sigc++/sigc++.h>
#include <libxml++/libxml++.h>
#include <glibmm.h>
#include "rainbow/rdf-resource.h"

namespace Rainbow
{
	class License : public sigc::trackable
	{
	public:
		static void get_and_do (const Glib::ustring &url,
					const sigc::slot<void,ref_ptr<License> > &slot,
					xmlpp::Element *secondary_source = 0);
		
		void ref () { ++refcnt; }
		void unref () { if (--refcnt == 0) delete this; }

		Glib::ustring get_url () const { return url; }

		bool sharable ();

	private:
		License (const Glib::ustring &url = Glib::ustring());
		~License ();
		
		bool on_download (xmlpp::Element *license);
		void parse_xml (xmlpp::Element *xml);

		Glib::ustring url;
		bool downloaded, verified;
		std::set<Glib::ustring> permits, requires, prohibits;

		int refcnt;
		static std::map<Glib::ustring,ref_ptr<License> > license_map;
	};
}

#endif
