#!/usr/bin/python

import re
import os
import sys
import shutil
from test import get_gcda, is_coverage

def build_dir(exe):
    t = get_gcda(exe)
    a = re.search("(/.*)/test/setup\.gcda" ,t)
    return a.groups()[0]

def gen_cov_info(build_dir):
    if os.path.exists('coverage'):
        shutil.rmtree('coverage')
    os.mkdir('coverage')
    os.chdir('coverage')
    os.system('lcov -d ' + build_dir + ' -b ../ -z')
    os.system('lcov -d ' + build_dir + ' -b ../ -c -o clinkc.info')
    os.system('genhtml clinkc.info')

exe = '.libs/setup'
if is_coverage(exe):
    bdir = build_dir(exe)
    gen_cov_info(bdir)

sys.exit(0)
