/* IDBusScanner.c generated by valac 0.16.0, the Vala compiler
 * generated from IDBusScanner.vala, do not modify */

/*
 * Copyright (C) 2008-2011 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define DVB_TYPE_ID_BUS_SCANNER (dvb_id_bus_scanner_get_type ())
#define DVB_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScanner))
#define DVB_IS_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCANNER))
#define DVB_ID_BUS_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScannerIface))

typedef struct _DVBIDBusScanner DVBIDBusScanner;
typedef struct _DVBIDBusScannerIface DVBIDBusScannerIface;

#define DVB_TYPE_ID_BUS_SCANNER_PROXY (dvb_id_bus_scanner_proxy_get_type ())
typedef GDBusProxy DVBIDBusScannerProxy;
typedef GDBusProxyClass DVBIDBusScannerProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _DVBIDBusScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusScanner* self, GError** error);
	void (*Destroy) (DVBIDBusScanner* self, GError** error);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
	gboolean (*WriteChannelsToFile) (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
	gboolean (*AddScanningData) (DVBIDBusScanner* self, GHashTable* data, GError** error);
	gboolean (*AddScanningDataFromFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
};



GType dvb_id_bus_scanner_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_scanner_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_scanner_get_type (void) G_GNUC_CONST;
void dvb_id_bus_scanner_Run (DVBIDBusScanner* self, GError** error);
void dvb_id_bus_scanner_Destroy (DVBIDBusScanner* self, GError** error);
gboolean dvb_id_bus_scanner_WriteAllChannelsToFile (DVBIDBusScanner* self, const gchar* path, GError** error);
gboolean dvb_id_bus_scanner_WriteChannelsToFile (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
gboolean dvb_id_bus_scanner_AddScanningData (DVBIDBusScanner* self, GHashTable* data, GError** error);
gboolean dvb_id_bus_scanner_AddScanningDataFromFile (DVBIDBusScanner* self, const gchar* path, GError** error);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void dvb_id_bus_scanner_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_scanner_frequency_scanned (DVBIDBusScanner* self, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_scanner_finished (DVBIDBusScanner* self, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_scanner_channel_added (DVBIDBusScanner* self, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_scanner_frontend_stats (DVBIDBusScanner* self, GVariant* parameters);
static void dvb_id_bus_scanner_proxy_Run (DVBIDBusScanner* self, GError** error);
static void dvb_id_bus_scanner_proxy_Destroy (DVBIDBusScanner* self, GError** error);
static gboolean dvb_id_bus_scanner_proxy_WriteAllChannelsToFile (DVBIDBusScanner* self, const gchar* path, GError** error);
static gboolean dvb_id_bus_scanner_proxy_WriteChannelsToFile (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
static gboolean dvb_id_bus_scanner_proxy_AddScanningData (DVBIDBusScanner* self, GHashTable* data, GError** error);
static gboolean dvb_id_bus_scanner_proxy_AddScanningDataFromFile (DVBIDBusScanner* self, const gchar* path, GError** error);
static void dvb_id_bus_scanner_proxy_dvb_id_bus_scanner_interface_init (DVBIDBusScannerIface* iface);
static void _dbus_dvb_id_bus_scanner_Run (DVBIDBusScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_scanner_Destroy (DVBIDBusScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_scanner_WriteAllChannelsToFile (DVBIDBusScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_scanner_WriteChannelsToFile (DVBIDBusScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_scanner_AddScanningData (DVBIDBusScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_scanner_AddScanningDataFromFile (DVBIDBusScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void dvb_id_bus_scanner_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* dvb_id_bus_scanner_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean dvb_id_bus_scanner_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_dvb_id_bus_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, gpointer* _data);
static void _dbus_dvb_id_bus_scanner_finished (GObject* _sender, gpointer* _data);
static void _dbus_dvb_id_bus_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const gchar* name, const gchar* network, const gchar* type, gboolean scrambled, gpointer* _data);
static void _dbus_dvb_id_bus_scanner_frontend_stats (GObject* _sender, gdouble signal_strength, gdouble signal_noise_ratio, gpointer* _data);
static void _dvb_id_bus_scanner_unregister_object (gpointer user_data);

static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_Run_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_Run_out[] = {NULL};
static const GDBusMethodInfo _dvb_id_bus_scanner_dbus_method_info_Run = {-1, "Run", (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_Run_in), (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_Run_out)};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_Destroy_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_Destroy_out[] = {NULL};
static const GDBusMethodInfo _dvb_id_bus_scanner_dbus_method_info_Destroy = {-1, "Destroy", (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_Destroy_in), (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_Destroy_out)};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_WriteAllChannelsToFile_path = {-1, "path", "s"};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_WriteAllChannelsToFile_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_WriteAllChannelsToFile_in[] = {&_dvb_id_bus_scanner_dbus_arg_info_WriteAllChannelsToFile_path, NULL};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_WriteAllChannelsToFile_out[] = {&_dvb_id_bus_scanner_dbus_arg_info_WriteAllChannelsToFile_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_scanner_dbus_method_info_WriteAllChannelsToFile = {-1, "WriteAllChannelsToFile", (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_WriteAllChannelsToFile_in), (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_WriteAllChannelsToFile_out)};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_WriteChannelsToFile_channel_sids = {-1, "channel_sids", "au"};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_WriteChannelsToFile_path = {-1, "path", "s"};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_WriteChannelsToFile_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_WriteChannelsToFile_in[] = {&_dvb_id_bus_scanner_dbus_arg_info_WriteChannelsToFile_channel_sids, &_dvb_id_bus_scanner_dbus_arg_info_WriteChannelsToFile_path, NULL};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_WriteChannelsToFile_out[] = {&_dvb_id_bus_scanner_dbus_arg_info_WriteChannelsToFile_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_scanner_dbus_method_info_WriteChannelsToFile = {-1, "WriteChannelsToFile", (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_WriteChannelsToFile_in), (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_WriteChannelsToFile_out)};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_AddScanningData_data = {-1, "data", "a{sv}"};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_AddScanningData_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_AddScanningData_in[] = {&_dvb_id_bus_scanner_dbus_arg_info_AddScanningData_data, NULL};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_AddScanningData_out[] = {&_dvb_id_bus_scanner_dbus_arg_info_AddScanningData_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_scanner_dbus_method_info_AddScanningData = {-1, "AddScanningData", (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_AddScanningData_in), (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_AddScanningData_out)};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_AddScanningDataFromFile_path = {-1, "path", "s"};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_AddScanningDataFromFile_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_AddScanningDataFromFile_in[] = {&_dvb_id_bus_scanner_dbus_arg_info_AddScanningDataFromFile_path, NULL};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_AddScanningDataFromFile_out[] = {&_dvb_id_bus_scanner_dbus_arg_info_AddScanningDataFromFile_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_scanner_dbus_method_info_AddScanningDataFromFile = {-1, "AddScanningDataFromFile", (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_AddScanningDataFromFile_in), (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_AddScanningDataFromFile_out)};
static const GDBusMethodInfo * const _dvb_id_bus_scanner_dbus_method_info[] = {&_dvb_id_bus_scanner_dbus_method_info_Run, &_dvb_id_bus_scanner_dbus_method_info_Destroy, &_dvb_id_bus_scanner_dbus_method_info_WriteAllChannelsToFile, &_dvb_id_bus_scanner_dbus_method_info_WriteChannelsToFile, &_dvb_id_bus_scanner_dbus_method_info_AddScanningData, &_dvb_id_bus_scanner_dbus_method_info_AddScanningDataFromFile, NULL};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_frequency_scanned_frequency = {-1, "frequency", "u"};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_frequency_scanned_freq_left = {-1, "freq_left", "u"};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_frequency_scanned[] = {&_dvb_id_bus_scanner_dbus_arg_info_frequency_scanned_frequency, &_dvb_id_bus_scanner_dbus_arg_info_frequency_scanned_freq_left, NULL};
static const GDBusSignalInfo _dvb_id_bus_scanner_dbus_signal_info_frequency_scanned = {-1, "FrequencyScanned", (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_frequency_scanned)};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_finished[] = {NULL};
static const GDBusSignalInfo _dvb_id_bus_scanner_dbus_signal_info_finished = {-1, "Finished", (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_finished)};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_channel_added_frequency = {-1, "frequency", "u"};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_channel_added_sid = {-1, "sid", "u"};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_channel_added_name = {-1, "name", "s"};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_channel_added_network = {-1, "network", "s"};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_channel_added_type = {-1, "type", "s"};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_channel_added_scrambled = {-1, "scrambled", "b"};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_channel_added[] = {&_dvb_id_bus_scanner_dbus_arg_info_channel_added_frequency, &_dvb_id_bus_scanner_dbus_arg_info_channel_added_sid, &_dvb_id_bus_scanner_dbus_arg_info_channel_added_name, &_dvb_id_bus_scanner_dbus_arg_info_channel_added_network, &_dvb_id_bus_scanner_dbus_arg_info_channel_added_type, &_dvb_id_bus_scanner_dbus_arg_info_channel_added_scrambled, NULL};
static const GDBusSignalInfo _dvb_id_bus_scanner_dbus_signal_info_channel_added = {-1, "ChannelAdded", (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_channel_added)};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_frontend_stats_signal_strength = {-1, "signal_strength", "d"};
static const GDBusArgInfo _dvb_id_bus_scanner_dbus_arg_info_frontend_stats_signal_noise_ratio = {-1, "signal_noise_ratio", "d"};
static const GDBusArgInfo * const _dvb_id_bus_scanner_dbus_arg_info_frontend_stats[] = {&_dvb_id_bus_scanner_dbus_arg_info_frontend_stats_signal_strength, &_dvb_id_bus_scanner_dbus_arg_info_frontend_stats_signal_noise_ratio, NULL};
static const GDBusSignalInfo _dvb_id_bus_scanner_dbus_signal_info_frontend_stats = {-1, "FrontendStats", (GDBusArgInfo **) (&_dvb_id_bus_scanner_dbus_arg_info_frontend_stats)};
static const GDBusSignalInfo * const _dvb_id_bus_scanner_dbus_signal_info[] = {&_dvb_id_bus_scanner_dbus_signal_info_frequency_scanned, &_dvb_id_bus_scanner_dbus_signal_info_finished, &_dvb_id_bus_scanner_dbus_signal_info_channel_added, &_dvb_id_bus_scanner_dbus_signal_info_frontend_stats, NULL};
static const GDBusPropertyInfo * const _dvb_id_bus_scanner_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _dvb_id_bus_scanner_dbus_interface_info = {-1, "org.gnome.DVB.Scanner", (GDBusMethodInfo **) (&_dvb_id_bus_scanner_dbus_method_info), (GDBusSignalInfo **) (&_dvb_id_bus_scanner_dbus_signal_info), (GDBusPropertyInfo **) (&_dvb_id_bus_scanner_dbus_property_info)};
static const GDBusInterfaceVTable _dvb_id_bus_scanner_dbus_interface_vtable = {dvb_id_bus_scanner_dbus_interface_method_call, dvb_id_bus_scanner_dbus_interface_get_property, dvb_id_bus_scanner_dbus_interface_set_property};

void dvb_id_bus_scanner_Run (DVBIDBusScanner* self, GError** error) {
	g_return_if_fail (self != NULL);
	DVB_ID_BUS_SCANNER_GET_INTERFACE (self)->Run (self, error);
}


void dvb_id_bus_scanner_Destroy (DVBIDBusScanner* self, GError** error) {
	g_return_if_fail (self != NULL);
	DVB_ID_BUS_SCANNER_GET_INTERFACE (self)->Destroy (self, error);
}


gboolean dvb_id_bus_scanner_WriteAllChannelsToFile (DVBIDBusScanner* self, const gchar* path, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_SCANNER_GET_INTERFACE (self)->WriteAllChannelsToFile (self, path, error);
}


gboolean dvb_id_bus_scanner_WriteChannelsToFile (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_SCANNER_GET_INTERFACE (self)->WriteChannelsToFile (self, channel_sids, channel_sids_length1, path, error);
}


gboolean dvb_id_bus_scanner_AddScanningData (DVBIDBusScanner* self, GHashTable* data, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_SCANNER_GET_INTERFACE (self)->AddScanningData (self, data, error);
}


/**
         * @path: Path to file containing scanning data
         * @returns: TRUE when the file has been parsed successfully
         *
         * Parses initial tuning data from a file as provided by dvb-apps
         */
gboolean dvb_id_bus_scanner_AddScanningDataFromFile (DVBIDBusScanner* self, const gchar* path, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_SCANNER_GET_INTERFACE (self)->AddScanningDataFromFile (self, path, error);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gboolean arg_6, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 7);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boolean (param_values + 6), data2);
}


static void g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__DOUBLE_DOUBLE) (gpointer data1, gdouble arg_1, gdouble arg_2, gpointer data2);
	register GMarshalFunc_VOID__DOUBLE_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__DOUBLE_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_double (param_values + 1), g_value_get_double (param_values + 2), data2);
}


static void dvb_id_bus_scanner_base_init (DVBIDBusScannerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("frequency_scanned", DVB_TYPE_ID_BUS_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_signal_new ("finished", DVB_TYPE_ID_BUS_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("channel_added", DVB_TYPE_ID_BUS_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
		g_signal_new ("frontend_stats", DVB_TYPE_ID_BUS_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE, G_TYPE_NONE, 2, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
	}
}


GType dvb_id_bus_scanner_get_type (void) {
	static volatile gsize dvb_id_bus_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_id_bus_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusScannerIface), (GBaseInitFunc) dvb_id_bus_scanner_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dvb_id_bus_scanner_type_id;
		dvb_id_bus_scanner_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusScanner", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_scanner_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_scanner_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) dvb_id_bus_scanner_proxy_get_type);
		g_type_set_qdata (dvb_id_bus_scanner_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.DVB.Scanner");
		g_type_set_qdata (dvb_id_bus_scanner_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) dvb_id_bus_scanner_register_object);
		g_once_init_leave (&dvb_id_bus_scanner_type_id__volatile, dvb_id_bus_scanner_type_id);
	}
	return dvb_id_bus_scanner_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusScannerProxy, dvb_id_bus_scanner_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_SCANNER, dvb_id_bus_scanner_proxy_dvb_id_bus_scanner_interface_init) )
static void dvb_id_bus_scanner_proxy_class_init (DVBIDBusScannerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = dvb_id_bus_scanner_proxy_g_signal;
}


static void _dbus_handle_dvb_id_bus_scanner_frequency_scanned (DVBIDBusScanner* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint frequency = 0U;
	GVariant* _tmp340_;
	guint freq_left = 0U;
	GVariant* _tmp341_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp340_ = g_variant_iter_next_value (&_arguments_iter);
	frequency = g_variant_get_uint32 (_tmp340_);
	g_variant_unref (_tmp340_);
	_tmp341_ = g_variant_iter_next_value (&_arguments_iter);
	freq_left = g_variant_get_uint32 (_tmp341_);
	g_variant_unref (_tmp341_);
	g_signal_emit_by_name (self, "frequency-scanned", frequency, freq_left);
}


static void _dbus_handle_dvb_id_bus_scanner_finished (DVBIDBusScanner* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "finished");
}


static void _dbus_handle_dvb_id_bus_scanner_channel_added (DVBIDBusScanner* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint frequency = 0U;
	GVariant* _tmp342_;
	guint sid = 0U;
	GVariant* _tmp343_;
	gchar* name = NULL;
	GVariant* _tmp344_;
	gchar* network = NULL;
	GVariant* _tmp345_;
	gchar* type = NULL;
	GVariant* _tmp346_;
	gboolean scrambled = FALSE;
	GVariant* _tmp347_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp342_ = g_variant_iter_next_value (&_arguments_iter);
	frequency = g_variant_get_uint32 (_tmp342_);
	g_variant_unref (_tmp342_);
	_tmp343_ = g_variant_iter_next_value (&_arguments_iter);
	sid = g_variant_get_uint32 (_tmp343_);
	g_variant_unref (_tmp343_);
	_tmp344_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp344_, NULL);
	g_variant_unref (_tmp344_);
	_tmp345_ = g_variant_iter_next_value (&_arguments_iter);
	network = g_variant_dup_string (_tmp345_, NULL);
	g_variant_unref (_tmp345_);
	_tmp346_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_dup_string (_tmp346_, NULL);
	g_variant_unref (_tmp346_);
	_tmp347_ = g_variant_iter_next_value (&_arguments_iter);
	scrambled = g_variant_get_boolean (_tmp347_);
	g_variant_unref (_tmp347_);
	g_signal_emit_by_name (self, "channel-added", frequency, sid, name, network, type, scrambled);
	_g_free0 (name);
	_g_free0 (network);
	_g_free0 (type);
}


static void _dbus_handle_dvb_id_bus_scanner_frontend_stats (DVBIDBusScanner* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gdouble signal_strength = 0.0;
	GVariant* _tmp348_;
	gdouble signal_noise_ratio = 0.0;
	GVariant* _tmp349_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp348_ = g_variant_iter_next_value (&_arguments_iter);
	signal_strength = g_variant_get_double (_tmp348_);
	g_variant_unref (_tmp348_);
	_tmp349_ = g_variant_iter_next_value (&_arguments_iter);
	signal_noise_ratio = g_variant_get_double (_tmp349_);
	g_variant_unref (_tmp349_);
	g_signal_emit_by_name (self, "frontend-stats", signal_strength, signal_noise_ratio);
}


static void dvb_id_bus_scanner_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "FrequencyScanned") == 0) {
		_dbus_handle_dvb_id_bus_scanner_frequency_scanned ((DVBIDBusScanner*) proxy, parameters);
	} else if (strcmp (signal_name, "Finished") == 0) {
		_dbus_handle_dvb_id_bus_scanner_finished ((DVBIDBusScanner*) proxy, parameters);
	} else if (strcmp (signal_name, "ChannelAdded") == 0) {
		_dbus_handle_dvb_id_bus_scanner_channel_added ((DVBIDBusScanner*) proxy, parameters);
	} else if (strcmp (signal_name, "FrontendStats") == 0) {
		_dbus_handle_dvb_id_bus_scanner_frontend_stats ((DVBIDBusScanner*) proxy, parameters);
	}
}


static void dvb_id_bus_scanner_proxy_init (DVBIDBusScannerProxy* self) {
}


static void dvb_id_bus_scanner_proxy_Run (DVBIDBusScanner* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Scanner", "Run");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void dvb_id_bus_scanner_proxy_Destroy (DVBIDBusScanner* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Scanner", "Destroy");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static gboolean dvb_id_bus_scanner_proxy_WriteAllChannelsToFile (DVBIDBusScanner* self, const gchar* path, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp350_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Scanner", "WriteAllChannelsToFile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp350_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp350_);
	g_variant_unref (_tmp350_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_scanner_proxy_WriteChannelsToFile (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	guint* _tmp351_;
	GVariantBuilder _tmp352_;
	int _tmp353_;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp354_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Scanner", "WriteChannelsToFile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp351_ = channel_sids;
	g_variant_builder_init (&_tmp352_, G_VARIANT_TYPE ("au"));
	for (_tmp353_ = 0; _tmp353_ < channel_sids_length1; _tmp353_++) {
		g_variant_builder_add_value (&_tmp352_, g_variant_new_uint32 (*_tmp351_));
		_tmp351_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp352_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp354_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp354_);
	g_variant_unref (_tmp354_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_scanner_proxy_AddScanningData (DVBIDBusScanner* self, GHashTable* data, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp355_;
	GHashTableIter _tmp356_;
	gpointer _tmp357_;
	gpointer _tmp358_;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp359_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Scanner", "AddScanningData");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp356_, data);
	g_variant_builder_init (&_tmp355_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp356_, &_tmp357_, &_tmp358_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp357_;
		_value = (GVariant*) _tmp358_;
		g_variant_builder_add (&_tmp355_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp355_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp359_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp359_);
	g_variant_unref (_tmp359_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_scanner_proxy_AddScanningDataFromFile (DVBIDBusScanner* self, const gchar* path, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp360_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Scanner", "AddScanningDataFromFile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp360_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp360_);
	g_variant_unref (_tmp360_);
	g_object_unref (_reply_message);
	return _result;
}


static void dvb_id_bus_scanner_proxy_dvb_id_bus_scanner_interface_init (DVBIDBusScannerIface* iface) {
	iface->Run = dvb_id_bus_scanner_proxy_Run;
	iface->Destroy = dvb_id_bus_scanner_proxy_Destroy;
	iface->WriteAllChannelsToFile = dvb_id_bus_scanner_proxy_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = dvb_id_bus_scanner_proxy_WriteChannelsToFile;
	iface->AddScanningData = dvb_id_bus_scanner_proxy_AddScanningData;
	iface->AddScanningDataFromFile = dvb_id_bus_scanner_proxy_AddScanningDataFromFile;
}


static void _dbus_dvb_id_bus_scanner_Run (DVBIDBusScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	dvb_id_bus_scanner_Run (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_scanner_Destroy (DVBIDBusScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	dvb_id_bus_scanner_Destroy (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_scanner_WriteAllChannelsToFile (DVBIDBusScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* path = NULL;
	GVariant* _tmp361_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp361_ = g_variant_iter_next_value (&_arguments_iter);
	path = g_variant_dup_string (_tmp361_, NULL);
	g_variant_unref (_tmp361_);
	result = dvb_id_bus_scanner_WriteAllChannelsToFile (self, path, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (path);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_scanner_WriteChannelsToFile (DVBIDBusScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint* channel_sids = NULL;
	int channel_sids_length1 = 0;
	GVariant* _tmp362_;
	guint* _tmp363_;
	int _tmp363__length;
	int _tmp363__size;
	int _tmp363__length1;
	GVariantIter _tmp364_;
	GVariant* _tmp365_;
	gchar* path = NULL;
	GVariant* _tmp366_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp362_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp363_ = g_new (guint, 5);
	_tmp363__length = 0;
	_tmp363__size = 4;
	_tmp363__length1 = 0;
	g_variant_iter_init (&_tmp364_, _tmp362_);
	for (; (_tmp365_ = g_variant_iter_next_value (&_tmp364_)) != NULL; _tmp363__length1++) {
		if (_tmp363__size == _tmp363__length) {
			_tmp363__size = 2 * _tmp363__size;
			_tmp363_ = g_renew (guint, _tmp363_, _tmp363__size + 1);
		}
		_tmp363_[_tmp363__length++] = g_variant_get_uint32 (_tmp365_);
		g_variant_unref (_tmp365_);
	}
	channel_sids_length1 = _tmp363__length1;
	channel_sids = _tmp363_;
	g_variant_unref (_tmp362_);
	_tmp366_ = g_variant_iter_next_value (&_arguments_iter);
	path = g_variant_dup_string (_tmp366_, NULL);
	g_variant_unref (_tmp366_);
	result = dvb_id_bus_scanner_WriteChannelsToFile (self, channel_sids, channel_sids_length1, path, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	channel_sids = (g_free (channel_sids), NULL);
	_g_free0 (path);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_scanner_AddScanningData (DVBIDBusScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* data = NULL;
	GVariant* _tmp367_;
	GHashTable* _tmp368_;
	GVariantIter _tmp369_;
	GVariant* _tmp370_;
	GVariant* _tmp371_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp367_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp368_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp369_, _tmp367_);
	while (g_variant_iter_loop (&_tmp369_, "{?*}", &_tmp370_, &_tmp371_)) {
		g_hash_table_insert (_tmp368_, g_variant_dup_string (_tmp370_, NULL), g_variant_get_variant (_tmp371_));
	}
	data = _tmp368_;
	g_variant_unref (_tmp367_);
	result = dvb_id_bus_scanner_AddScanningData (self, data, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_hash_table_unref0 (data);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_scanner_AddScanningDataFromFile (DVBIDBusScanner* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* path = NULL;
	GVariant* _tmp372_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp372_ = g_variant_iter_next_value (&_arguments_iter);
	path = g_variant_dup_string (_tmp372_, NULL);
	g_variant_unref (_tmp372_);
	result = dvb_id_bus_scanner_AddScanningDataFromFile (self, path, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (path);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void dvb_id_bus_scanner_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Run") == 0) {
		_dbus_dvb_id_bus_scanner_Run (object, parameters, invocation);
	} else if (strcmp (method_name, "Destroy") == 0) {
		_dbus_dvb_id_bus_scanner_Destroy (object, parameters, invocation);
	} else if (strcmp (method_name, "WriteAllChannelsToFile") == 0) {
		_dbus_dvb_id_bus_scanner_WriteAllChannelsToFile (object, parameters, invocation);
	} else if (strcmp (method_name, "WriteChannelsToFile") == 0) {
		_dbus_dvb_id_bus_scanner_WriteChannelsToFile (object, parameters, invocation);
	} else if (strcmp (method_name, "AddScanningData") == 0) {
		_dbus_dvb_id_bus_scanner_AddScanningData (object, parameters, invocation);
	} else if (strcmp (method_name, "AddScanningDataFromFile") == 0) {
		_dbus_dvb_id_bus_scanner_AddScanningDataFromFile (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* dvb_id_bus_scanner_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean dvb_id_bus_scanner_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_dvb_id_bus_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (frequency));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (freq_left));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.Scanner", "FrequencyScanned", _arguments, NULL);
}


static void _dbus_dvb_id_bus_scanner_finished (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.Scanner", "Finished", _arguments, NULL);
}


static void _dbus_dvb_id_bus_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const gchar* name, const gchar* network, const gchar* type, gboolean scrambled, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (frequency));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (sid));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (network));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (type));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (scrambled));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.Scanner", "ChannelAdded", _arguments, NULL);
}


static void _dbus_dvb_id_bus_scanner_frontend_stats (GObject* _sender, gdouble signal_strength, gdouble signal_noise_ratio, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (signal_strength));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (signal_noise_ratio));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.Scanner", "FrontendStats", _arguments, NULL);
}


guint dvb_id_bus_scanner_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_dvb_id_bus_scanner_dbus_interface_info), &_dvb_id_bus_scanner_dbus_interface_vtable, data, _dvb_id_bus_scanner_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "frequency-scanned", (GCallback) _dbus_dvb_id_bus_scanner_frequency_scanned, data);
	g_signal_connect (object, "finished", (GCallback) _dbus_dvb_id_bus_scanner_finished, data);
	g_signal_connect (object, "channel-added", (GCallback) _dbus_dvb_id_bus_scanner_channel_added, data);
	g_signal_connect (object, "frontend-stats", (GCallback) _dbus_dvb_id_bus_scanner_frontend_stats, data);
	return result;
}


static void _dvb_id_bus_scanner_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dvb_id_bus_scanner_frequency_scanned, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dvb_id_bus_scanner_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dvb_id_bus_scanner_channel_added, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dvb_id_bus_scanner_frontend_stats, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



