/* TerrestrialScanner.c generated by valac 0.16.0, the Vala compiler
 * generated from TerrestrialScanner.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
typedef struct _DVBScannerPrivate DVBScannerPrivate;

#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_ID_BUS_SCANNER (dvb_id_bus_scanner_get_type ())
#define DVB_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScanner))
#define DVB_IS_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCANNER))
#define DVB_ID_BUS_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScannerIface))

typedef struct _DVBIDBusScanner DVBIDBusScanner;
typedef struct _DVBIDBusScannerIface DVBIDBusScannerIface;

#define DVB_TYPE_ID_BUS_SCANNER_PROXY (dvb_id_bus_scanner_proxy_get_type ())

#define DVB_TYPE_TERRESTRIAL_SCANNER (dvb_terrestrial_scanner_get_type ())
#define DVB_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScanner))
#define DVB_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))
#define DVB_IS_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_IS_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_TERRESTRIAL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))

typedef struct _DVBTerrestrialScanner DVBTerrestrialScanner;
typedef struct _DVBTerrestrialScannerClass DVBTerrestrialScannerClass;
typedef struct _DVBTerrestrialScannerPrivate DVBTerrestrialScannerPrivate;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))

#define DVB_TYPE_DVB_SRC_BANDWIDTH (dvb_dvb_src_bandwidth_get_type ())

#define DVB_TYPE_DVB_SRC_HIERARCHY (dvb_dvb_src_hierarchy_get_type ())

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())

#define DVB_TYPE_DVB_SRC_GUARD (dvb_dvb_src_guard_get_type ())

#define DVB_TYPE_DVB_SRC_TRANSMISSION_MODE (dvb_dvb_src_transmission_mode_get_type ())
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_TYPE_TERRESTRIAL_CHANNEL (dvb_terrestrial_channel_get_type ())
#define DVB_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannel))
#define DVB_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))
#define DVB_IS_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_IS_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_TERRESTRIAL_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))

typedef struct _DVBTerrestrialChannel DVBTerrestrialChannel;
typedef struct _DVBTerrestrialChannelClass DVBTerrestrialChannelClass;

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DVBScanner {
	GObject parent_instance;
	DVBScannerPrivate * priv;
	DVBChannelList* channels;
	GstElement* pipeline;
	GQueue* frequencies;
	GstStructure* current_tuning_params;
	GeeHashSet* scanned_frequencies;
};

struct _DVBScannerClass {
	GObjectClass parent_class;
	void (*prepare) (DVBScanner* self);
	DVBScannedItem* (*get_scanned_item) (DVBScanner* self, const GstStructure* structure);
	DVBChannel* (*get_new_channel) (DVBScanner* self);
	void (*add_values_from_structure_to_channel) (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
	void (*add_scanning_data_from_string) (DVBScanner* self, const gchar* line);
};

struct _DVBIDBusScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusScanner* self, GError** error);
	void (*Destroy) (DVBIDBusScanner* self, GError** error);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
	gboolean (*WriteChannelsToFile) (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
	gboolean (*AddScanningData) (DVBIDBusScanner* self, GHashTable* data, GError** error);
	gboolean (*AddScanningDataFromFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
};

struct _DVBTerrestrialScanner {
	DVBScanner parent_instance;
	DVBTerrestrialScannerPrivate * priv;
};

struct _DVBTerrestrialScannerClass {
	DVBScannerClass parent_class;
};

typedef enum  {
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO
} DVBDvbSrcBandwidth;

typedef enum  {
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_1,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_2,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_4,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO
} DVBDvbSrcHierarchy;

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO
} DVBDvbSrcGuard;

typedef enum  {
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO
} DVBDvbSrcTransmissionMode;

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;


static gpointer dvb_terrestrial_scanner_parent_class = NULL;
static DVBIDBusScannerIface* dvb_terrestrial_scanner_dvb_id_bus_scanner_parent_iface = NULL;

GType dvb_scanner_get_type (void) G_GNUC_CONST;
GType dvb_scanned_item_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_id_bus_scanner_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_scanner_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_scanner_get_type (void) G_GNUC_CONST;
GType dvb_terrestrial_scanner_get_type (void) G_GNUC_CONST;
enum  {
	DVB_TERRESTRIAL_SCANNER_DUMMY_PROPERTY
};
GType dvb_device_get_type (void) G_GNUC_CONST;
DVBTerrestrialScanner* dvb_terrestrial_scanner_new (DVBDevice* device);
DVBTerrestrialScanner* dvb_terrestrial_scanner_construct (GType object_type, DVBDevice* device);
static gboolean dvb_terrestrial_scanner_real_AddScanningData (DVBIDBusScanner* base, GHashTable* data, GError** error);
static inline void dvb_terrestrial_scanner_add_scanning_data (DVBTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const gchar* transmode, const gchar* code_rate_hp, const gchar* code_rate_lp, const gchar* constellation, guint guard);
void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure);
static void dvb_terrestrial_scanner_real_add_scanning_data_from_string (DVBScanner* base, const gchar* line);
static void dvb_terrestrial_scanner_real_prepare (DVBScanner* base);
void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const gchar* key);
GType dvb_dvb_src_bandwidth_get_type (void) G_GNUC_CONST;
DVBDvbSrcBandwidth dvb_get_bandwidth_val (guint bandwidth);
GType dvb_dvb_src_hierarchy_get_type (void) G_GNUC_CONST;
DVBDvbSrcHierarchy dvb_get_hierarchy_val (guint hierarchy);
GType dvb_dvb_src_modulation_get_type (void) G_GNUC_CONST;
DVBDvbSrcModulation dvb_get_modulation_val (const gchar* constellation);
GType dvb_dvb_src_code_rate_get_type (void) G_GNUC_CONST;
DVBDvbSrcCodeRate dvb_get_code_rate_val (const gchar* code_rate_string);
GType dvb_dvb_src_guard_get_type (void) G_GNUC_CONST;
DVBDvbSrcGuard dvb_get_guard_interval_val (guint guard);
GType dvb_dvb_src_transmission_mode_get_type (void) G_GNUC_CONST;
DVBDvbSrcTransmissionMode dvb_get_transmission_mode_val (const gchar* transmode);
static DVBScannedItem* dvb_terrestrial_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
DVBScannedItem* dvb_scanned_item_new (guint frequency);
DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency);
static DVBChannel* dvb_terrestrial_scanner_real_get_new_channel (DVBScanner* base);
DVBTerrestrialChannel* dvb_terrestrial_channel_new_without_schedule (void);
DVBTerrestrialChannel* dvb_terrestrial_channel_construct_without_schedule (GType object_type);
GType dvb_terrestrial_channel_get_type (void) G_GNUC_CONST;
static void dvb_terrestrial_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
GType dvb_dvb_src_inversion_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_Inversion (DVBTerrestrialChannel* self, DVBDvbSrcInversion value);
void dvb_channel_set_Frequency (DVBChannel* self, guint value);
void dvb_terrestrial_channel_set_Bandwidth (DVBTerrestrialChannel* self, DVBDvbSrcBandwidth value);
void dvb_terrestrial_channel_set_Hierarchy (DVBTerrestrialChannel* self, DVBDvbSrcHierarchy value);
void dvb_terrestrial_channel_set_Constellation (DVBTerrestrialChannel* self, DVBDvbSrcModulation value);
void dvb_terrestrial_channel_set_CodeRateHP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
void dvb_terrestrial_channel_set_CodeRateLP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
void dvb_terrestrial_channel_set_GuardInterval (DVBTerrestrialChannel* self, DVBDvbSrcGuard value);
void dvb_terrestrial_channel_set_TransmissionMode (DVBTerrestrialChannel* self, DVBDvbSrcTransmissionMode value);
void dvb_scanner_Run (DVBScanner* self, GError** error);
void dvb_scanner_Destroy (DVBScanner* self, GError** error);
gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const gchar* path, GError** error);
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
gboolean dvb_scanner_AddScanningDataFromFile (DVBScanner* self, const gchar* path, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


DVBTerrestrialScanner* dvb_terrestrial_scanner_construct (GType object_type, DVBDevice* device) {
	DVBTerrestrialScanner * self = NULL;
	DVBDevice* _tmp0_;
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = device;
	self = (DVBTerrestrialScanner*) g_object_new (object_type, "Device", _tmp0_, NULL);
	return self;
}


DVBTerrestrialScanner* dvb_terrestrial_scanner_new (DVBDevice* device) {
	return dvb_terrestrial_scanner_construct (DVB_TYPE_TERRESTRIAL_SCANNER, device);
}


/**
          * See enums in MpegTsEnums
          */
static gboolean dvb_terrestrial_scanner_real_AddScanningData (DVBIDBusScanner* base, GHashTable* data, GError** error) {
	DVBTerrestrialScanner * self;
	gboolean result = FALSE;
	guint frequency = 0U;
	guint hierarchy = 0U;
	guint bandwidth = 0U;
	guint guard = 0U;
	gchar* transmode = NULL;
	gchar* code_rate_hp = NULL;
	gchar* code_rate_lp = NULL;
	gchar* constellation = NULL;
	GVariant* _var = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	guint32 _tmp4_ = 0U;
	GHashTable* _tmp5_;
	gconstpointer _tmp6_ = NULL;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	guint32 _tmp9_ = 0U;
	GHashTable* _tmp10_;
	gconstpointer _tmp11_ = NULL;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	guint32 _tmp14_ = 0U;
	GHashTable* _tmp15_;
	gconstpointer _tmp16_ = NULL;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	GHashTable* _tmp21_;
	gconstpointer _tmp22_ = NULL;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	GHashTable* _tmp27_;
	gconstpointer _tmp28_ = NULL;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_;
	GHashTable* _tmp33_;
	gconstpointer _tmp34_ = NULL;
	GVariant* _tmp35_;
	GVariant* _tmp36_;
	const gchar* _tmp37_ = NULL;
	gchar* _tmp38_;
	GHashTable* _tmp39_;
	gconstpointer _tmp40_ = NULL;
	GVariant* _tmp41_;
	GVariant* _tmp42_;
	guint32 _tmp43_ = 0U;
	guint _tmp44_;
	guint _tmp45_;
	guint _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	guint _tmp51_;
	self = (DVBTerrestrialScanner*) base;
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = data;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "frequency");
	_var = (GVariant*) _tmp1_;
	_tmp2_ = _var;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp3_ = _var;
	_tmp4_ = g_variant_get_uint32 (_tmp3_);
	frequency = (guint) _tmp4_;
	_tmp5_ = data;
	_tmp6_ = g_hash_table_lookup (_tmp5_, "hierarchy");
	_var = (GVariant*) _tmp6_;
	_tmp7_ = _var;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp8_ = _var;
	_tmp9_ = g_variant_get_uint32 (_tmp8_);
	hierarchy = (guint) _tmp9_;
	_tmp10_ = data;
	_tmp11_ = g_hash_table_lookup (_tmp10_, "bandwidth");
	_var = (GVariant*) _tmp11_;
	_tmp12_ = _var;
	if (_tmp12_ == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp13_ = _var;
	_tmp14_ = g_variant_get_uint32 (_tmp13_);
	bandwidth = (guint) _tmp14_;
	_tmp15_ = data;
	_tmp16_ = g_hash_table_lookup (_tmp15_, "transmission-mode");
	_var = (GVariant*) _tmp16_;
	_tmp17_ = _var;
	if (_tmp17_ == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp18_ = _var;
	_tmp19_ = g_variant_get_string (_tmp18_, NULL);
	_tmp20_ = g_strdup (_tmp19_);
	_g_free0 (transmode);
	transmode = _tmp20_;
	_tmp21_ = data;
	_tmp22_ = g_hash_table_lookup (_tmp21_, "code-rate-hp");
	_var = (GVariant*) _tmp22_;
	_tmp23_ = _var;
	if (_tmp23_ == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp24_ = _var;
	_tmp25_ = g_variant_get_string (_tmp24_, NULL);
	_tmp26_ = g_strdup (_tmp25_);
	_g_free0 (code_rate_hp);
	code_rate_hp = _tmp26_;
	_tmp27_ = data;
	_tmp28_ = g_hash_table_lookup (_tmp27_, "code-rate-lp");
	_var = (GVariant*) _tmp28_;
	_tmp29_ = _var;
	if (_tmp29_ == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp30_ = _var;
	_tmp31_ = g_variant_get_string (_tmp30_, NULL);
	_tmp32_ = g_strdup (_tmp31_);
	_g_free0 (code_rate_lp);
	code_rate_lp = _tmp32_;
	_tmp33_ = data;
	_tmp34_ = g_hash_table_lookup (_tmp33_, "constellation");
	_var = (GVariant*) _tmp34_;
	_tmp35_ = _var;
	if (_tmp35_ == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp36_ = _var;
	_tmp37_ = g_variant_get_string (_tmp36_, NULL);
	_tmp38_ = g_strdup (_tmp37_);
	_g_free0 (constellation);
	constellation = _tmp38_;
	_tmp39_ = data;
	_tmp40_ = g_hash_table_lookup (_tmp39_, "guard-interval");
	_var = (GVariant*) _tmp40_;
	_tmp41_ = _var;
	if (_tmp41_ == NULL) {
		result = FALSE;
		_g_free0 (constellation);
		_g_free0 (code_rate_lp);
		_g_free0 (code_rate_hp);
		_g_free0 (transmode);
		return result;
	}
	_tmp42_ = _var;
	_tmp43_ = g_variant_get_uint32 (_tmp42_);
	guard = (guint) _tmp43_;
	_tmp44_ = frequency;
	_tmp45_ = hierarchy;
	_tmp46_ = bandwidth;
	_tmp47_ = transmode;
	_tmp48_ = code_rate_hp;
	_tmp49_ = code_rate_lp;
	_tmp50_ = constellation;
	_tmp51_ = guard;
	dvb_terrestrial_scanner_add_scanning_data (self, _tmp44_, _tmp45_, _tmp46_, _tmp47_, _tmp48_, _tmp49_, _tmp50_, _tmp51_);
	result = TRUE;
	_g_free0 (constellation);
	_g_free0 (code_rate_lp);
	_g_free0 (code_rate_hp);
	_g_free0 (transmode);
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static inline void dvb_terrestrial_scanner_add_scanning_data (DVBTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const gchar* transmode, const gchar* code_rate_hp, const gchar* code_rate_lp, const gchar* constellation, guint guard) {
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	guint _tmp7_;
	GstStructure* _tmp8_;
	GstStructure* tuning_params;
	GstStructure* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (transmode != NULL);
	g_return_if_fail (code_rate_hp != NULL);
	g_return_if_fail (code_rate_lp != NULL);
	g_return_if_fail (constellation != NULL);
	_tmp0_ = frequency;
	_tmp1_ = hierarchy;
	_tmp2_ = bandwidth;
	_tmp3_ = transmode;
	_tmp4_ = code_rate_hp;
	_tmp5_ = code_rate_lp;
	_tmp6_ = constellation;
	_tmp7_ = guard;
	_tmp8_ = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, _tmp0_, "hierarchy", G_TYPE_UINT, _tmp1_, "bandwidth", G_TYPE_UINT, _tmp2_, "transmission-mode", G_TYPE_STRING, _tmp3_, "code-rate-hp", G_TYPE_STRING, _tmp4_, "code-rate-lp", G_TYPE_STRING, _tmp5_, "constellation", G_TYPE_STRING, _tmp6_, "guard-interval", G_TYPE_UINT, _tmp7_, NULL);
	tuning_params = _tmp8_;
	_tmp9_ = _gst_structure_copy0 (tuning_params);
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), _tmp9_);
	_gst_structure_free0 (tuning_params);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void dvb_terrestrial_scanner_real_add_scanning_data_from_string (DVBScanner* base, const gchar* line) {
	DVBTerrestrialScanner * self;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** cols;
	gint cols_length1;
	gint _cols_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	guint freq;
	guint hierarchy;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_;
	gint _tmp17__length1;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* bandwidth_str;
	const gchar* _tmp21_;
	gint _tmp22_ = 0;
	guint bandwidth;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* transmode;
	gchar** _tmp26_;
	gint _tmp26__length1;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* code_rate_hp;
	gchar** _tmp29_;
	gint _tmp29__length1;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* code_rate_lp;
	gchar** _tmp32_;
	gint _tmp32__length1;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* constellation;
	guint guard = 0U;
	gchar** _tmp35_;
	gint _tmp35__length1;
	const gchar* _tmp36_;
	gint _tmp37_ = 0;
	guint _tmp48_;
	guint _tmp49_;
	guint _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	guint _tmp55_;
	self = (DVBTerrestrialScanner*) base;
	g_return_if_fail (line != NULL);
	_tmp0_ = line;
	_tmp2_ = _tmp1_ = g_regex_split_simple ("\\s+", _tmp0_, 0, 0);
	cols = _tmp2_;
	cols_length1 = _vala_array_length (_tmp1_);
	_cols_size_ = cols_length1;
	_tmp3_ = cols;
	_tmp3__length1 = cols_length1;
	if (_tmp3__length1 < 9) {
		cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp4_ = cols;
	_tmp4__length1 = cols_length1;
	_tmp5_ = _tmp4_[1];
	_tmp6_ = atoi (_tmp5_);
	freq = (guint) _tmp6_;
	hierarchy = (guint) 0;
	_tmp7_ = cols;
	_tmp7__length1 = cols_length1;
	_tmp8_ = _tmp7_[8];
	if (g_strcmp0 (_tmp8_, "1") == 0) {
		hierarchy = (guint) 1;
	} else {
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		_tmp9_ = cols;
		_tmp9__length1 = cols_length1;
		_tmp10_ = _tmp9_[8];
		if (g_strcmp0 (_tmp10_, "2") == 0) {
			hierarchy = (guint) 2;
		} else {
			gchar** _tmp11_;
			gint _tmp11__length1;
			const gchar* _tmp12_;
			_tmp11_ = cols;
			_tmp11__length1 = cols_length1;
			_tmp12_ = _tmp11_[8];
			if (g_strcmp0 (_tmp12_, "4") == 0) {
				hierarchy = (guint) 3;
			}
		}
	}
	_tmp13_ = cols;
	_tmp13__length1 = cols_length1;
	_tmp14_ = _tmp13_[2];
	_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "MHz", 0);
	_tmp17_ = _tmp16_;
	_tmp17__length1 = _vala_array_length (_tmp15_);
	_tmp18_ = _tmp17_[0];
	_tmp19_ = g_strdup (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	bandwidth_str = _tmp20_;
	_tmp21_ = bandwidth_str;
	_tmp22_ = atoi (_tmp21_);
	bandwidth = (guint) _tmp22_;
	_tmp23_ = cols;
	_tmp23__length1 = cols_length1;
	_tmp24_ = _tmp23_[6];
	_tmp25_ = g_strdup (_tmp24_);
	transmode = _tmp25_;
	_tmp26_ = cols;
	_tmp26__length1 = cols_length1;
	_tmp27_ = _tmp26_[3];
	_tmp28_ = g_strdup (_tmp27_);
	code_rate_hp = _tmp28_;
	_tmp29_ = cols;
	_tmp29__length1 = cols_length1;
	_tmp30_ = _tmp29_[4];
	_tmp31_ = g_strdup (_tmp30_);
	code_rate_lp = _tmp31_;
	_tmp32_ = cols;
	_tmp32__length1 = cols_length1;
	_tmp33_ = _tmp32_[5];
	_tmp34_ = g_strdup (_tmp33_);
	constellation = _tmp34_;
	_tmp35_ = cols;
	_tmp35__length1 = cols_length1;
	_tmp36_ = _tmp35_[7];
	_tmp37_ = string_index_of (_tmp36_, "/", 0);
	if (_tmp37_ == (-1)) {
		guard = (guint) 0;
	} else {
		gchar** _tmp38_;
		gint _tmp38__length1;
		const gchar* _tmp39_;
		gchar** _tmp40_;
		gchar** _tmp41_ = NULL;
		gchar** _tmp42_;
		gint _tmp42__length1;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* guard_str;
		const gchar* _tmp46_;
		gint _tmp47_ = 0;
		_tmp38_ = cols;
		_tmp38__length1 = cols_length1;
		_tmp39_ = _tmp38_[7];
		_tmp41_ = _tmp40_ = g_strsplit (_tmp39_, "/", 0);
		_tmp42_ = _tmp41_;
		_tmp42__length1 = _vala_array_length (_tmp40_);
		_tmp43_ = _tmp42_[1];
		_tmp44_ = g_strdup (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
		guard_str = _tmp45_;
		_tmp46_ = guard_str;
		_tmp47_ = atoi (_tmp46_);
		guard = (guint) _tmp47_;
		_g_free0 (guard_str);
	}
	_tmp48_ = freq;
	_tmp49_ = hierarchy;
	_tmp50_ = bandwidth;
	_tmp51_ = transmode;
	_tmp52_ = code_rate_hp;
	_tmp53_ = code_rate_lp;
	_tmp54_ = constellation;
	_tmp55_ = guard;
	dvb_terrestrial_scanner_add_scanning_data (self, _tmp48_, _tmp49_, _tmp50_, _tmp51_, _tmp52_, _tmp53_, _tmp54_, _tmp55_);
	_g_free0 (constellation);
	_g_free0 (code_rate_lp);
	_g_free0 (code_rate_hp);
	_g_free0 (transmode);
	_g_free0 (bandwidth_str);
	cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
}


static void dvb_terrestrial_scanner_real_prepare (DVBScanner* base) {
	DVBTerrestrialScanner * self;
	GstElement* _tmp0_;
	GstElement* _tmp1_ = NULL;
	GstElement* dvbsrc;
	const GstStructure* _tmp2_;
	guint bandwidth = 0U;
	const GstStructure* _tmp3_;
	guint _tmp4_ = 0U;
	DVBDvbSrcBandwidth _tmp5_ = 0;
	guint hierarchy = 0U;
	const GstStructure* _tmp6_;
	guint _tmp7_ = 0U;
	DVBDvbSrcHierarchy _tmp8_ = 0;
	const GstStructure* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* constellation;
	DVBDvbSrcModulation _tmp12_ = 0;
	const GstStructure* _tmp13_;
	const gchar* _tmp14_ = NULL;
	DVBDvbSrcCodeRate _tmp15_ = 0;
	const GstStructure* _tmp16_;
	const gchar* _tmp17_ = NULL;
	DVBDvbSrcCodeRate _tmp18_ = 0;
	guint guard = 0U;
	const GstStructure* _tmp19_;
	guint _tmp20_ = 0U;
	DVBDvbSrcGuard _tmp21_ = 0;
	const GstStructure* _tmp22_;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	gchar* transmode;
	DVBDvbSrcTransmissionMode _tmp25_ = 0;
	self = (DVBTerrestrialScanner*) base;
	g_debug ("TerrestrialScanner.vala:146: Setting up pipeline for DVB-T scan");
	_tmp0_ = DVB_SCANNER (self)->pipeline;
	_tmp1_ = gst_bin_get_by_name (GST_BIN (_tmp0_), "dvbsrc");
	dvbsrc = _tmp1_;
	_tmp2_ = DVB_SCANNER (self)->current_tuning_params;
	dvb_scanner_set_uint_property (dvbsrc, _tmp2_, "frequency");
	_tmp3_ = ((DVBScanner*) self)->current_tuning_params;
	gst_structure_get_uint (_tmp3_, "bandwidth", &_tmp4_);
	bandwidth = _tmp4_;
	_tmp5_ = dvb_get_bandwidth_val (bandwidth);
	g_object_set ((GObject*) dvbsrc, "bandwidth", _tmp5_, NULL);
	_tmp6_ = ((DVBScanner*) self)->current_tuning_params;
	gst_structure_get_uint (_tmp6_, "hierarchy", &_tmp7_);
	hierarchy = _tmp7_;
	_tmp8_ = dvb_get_hierarchy_val (hierarchy);
	g_object_set ((GObject*) dvbsrc, "hierarchy", _tmp8_, NULL);
	_tmp9_ = ((DVBScanner*) self)->current_tuning_params;
	_tmp10_ = gst_structure_get_string (_tmp9_, "constellation");
	_tmp11_ = g_strdup (_tmp10_);
	constellation = _tmp11_;
	_tmp12_ = dvb_get_modulation_val (constellation);
	g_object_set ((GObject*) dvbsrc, "modulation", _tmp12_, NULL);
	_tmp13_ = ((DVBScanner*) self)->current_tuning_params;
	_tmp14_ = gst_structure_get_string (_tmp13_, "code-rate-hp");
	_tmp15_ = dvb_get_code_rate_val (_tmp14_);
	g_object_set ((GObject*) dvbsrc, "code-rate-hp", _tmp15_, NULL);
	_tmp16_ = ((DVBScanner*) self)->current_tuning_params;
	_tmp17_ = gst_structure_get_string (_tmp16_, "code-rate-lp");
	_tmp18_ = dvb_get_code_rate_val (_tmp17_);
	g_object_set ((GObject*) dvbsrc, "code-rate-lp", _tmp18_, NULL);
	_tmp19_ = ((DVBScanner*) self)->current_tuning_params;
	gst_structure_get_uint (_tmp19_, "guard-interval", &_tmp20_);
	guard = _tmp20_;
	_tmp21_ = dvb_get_guard_interval_val (guard);
	g_object_set ((GObject*) dvbsrc, "guard", _tmp21_, NULL);
	_tmp22_ = ((DVBScanner*) self)->current_tuning_params;
	_tmp23_ = gst_structure_get_string (_tmp22_, "transmission-mode");
	_tmp24_ = g_strdup (_tmp23_);
	transmode = _tmp24_;
	_tmp25_ = dvb_get_transmission_mode_val (transmode);
	g_object_set ((GObject*) dvbsrc, "trans-mode", _tmp25_, NULL);
	_g_free0 (transmode);
	_g_free0 (constellation);
	_gst_object_unref0 (dvbsrc);
}


static DVBScannedItem* dvb_terrestrial_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBTerrestrialScanner * self;
	DVBScannedItem* result = NULL;
	guint freq = 0U;
	const GstStructure* _tmp0_;
	guint _tmp1_ = 0U;
	DVBScannedItem* _tmp2_;
	self = (DVBTerrestrialScanner*) base;
	g_return_val_if_fail (structure != NULL, NULL);
	_tmp0_ = structure;
	gst_structure_get_uint (_tmp0_, "frequency", &_tmp1_);
	freq = _tmp1_;
	_tmp2_ = dvb_scanned_item_new (freq);
	result = _tmp2_;
	return result;
}


static DVBChannel* dvb_terrestrial_scanner_real_get_new_channel (DVBScanner* base) {
	DVBTerrestrialScanner * self;
	DVBChannel* result = NULL;
	DVBTerrestrialChannel* _tmp0_;
	self = (DVBTerrestrialScanner*) base;
	_tmp0_ = dvb_terrestrial_channel_new_without_schedule ();
	result = (DVBChannel*) _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_terrestrial_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBTerrestrialScanner * self;
	DVBChannel* _tmp0_;
	DVBChannel* _tmp1_;
	DVBTerrestrialChannel* _tmp2_;
	DVBTerrestrialChannel* tc;
	DVBTerrestrialChannel* _tmp3_;
	guint freq = 0U;
	const GstStructure* _tmp4_;
	guint _tmp5_ = 0U;
	DVBTerrestrialChannel* _tmp6_;
	guint _tmp7_;
	guint bandwidth = 0U;
	const GstStructure* _tmp8_;
	guint _tmp9_ = 0U;
	DVBTerrestrialChannel* _tmp10_;
	guint _tmp11_;
	DVBDvbSrcBandwidth _tmp12_ = 0;
	guint hierarchy = 0U;
	const GstStructure* _tmp13_;
	guint _tmp14_ = 0U;
	DVBTerrestrialChannel* _tmp15_;
	guint _tmp16_;
	DVBDvbSrcHierarchy _tmp17_ = 0;
	const GstStructure* _tmp18_;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* constellation;
	DVBTerrestrialChannel* _tmp21_;
	const gchar* _tmp22_;
	DVBDvbSrcModulation _tmp23_ = 0;
	DVBTerrestrialChannel* _tmp24_;
	const GstStructure* _tmp25_;
	const gchar* _tmp26_ = NULL;
	DVBDvbSrcCodeRate _tmp27_ = 0;
	DVBTerrestrialChannel* _tmp28_;
	const GstStructure* _tmp29_;
	const gchar* _tmp30_ = NULL;
	DVBDvbSrcCodeRate _tmp31_ = 0;
	guint guard = 0U;
	const GstStructure* _tmp32_;
	guint _tmp33_ = 0U;
	DVBTerrestrialChannel* _tmp34_;
	guint _tmp35_;
	DVBDvbSrcGuard _tmp36_ = 0;
	const GstStructure* _tmp37_;
	const gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	gchar* transmode;
	DVBTerrestrialChannel* _tmp40_;
	const gchar* _tmp41_;
	DVBDvbSrcTransmissionMode _tmp42_ = 0;
	self = (DVBTerrestrialScanner*) base;
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	if (!DVB_IS_TERRESTRIAL_CHANNEL (_tmp0_)) {
		return;
	}
	_tmp1_ = channel;
	_tmp2_ = _g_object_ref0 (DVB_TERRESTRIAL_CHANNEL (_tmp1_));
	tc = _tmp2_;
	_tmp3_ = tc;
	dvb_terrestrial_channel_set_Inversion (_tmp3_, DVB_DVB_SRC_INVERSION_INVERSION_AUTO);
	_tmp4_ = delivery;
	gst_structure_get_uint (_tmp4_, "frequency", &_tmp5_);
	freq = _tmp5_;
	_tmp6_ = tc;
	_tmp7_ = freq;
	dvb_channel_set_Frequency ((DVBChannel*) _tmp6_, _tmp7_);
	_tmp8_ = delivery;
	gst_structure_get_uint (_tmp8_, "bandwidth", &_tmp9_);
	bandwidth = _tmp9_;
	_tmp10_ = tc;
	_tmp11_ = bandwidth;
	_tmp12_ = dvb_get_bandwidth_val (_tmp11_);
	dvb_terrestrial_channel_set_Bandwidth (_tmp10_, _tmp12_);
	_tmp13_ = delivery;
	gst_structure_get_uint (_tmp13_, "hierarchy", &_tmp14_);
	hierarchy = _tmp14_;
	_tmp15_ = tc;
	_tmp16_ = hierarchy;
	_tmp17_ = dvb_get_hierarchy_val (_tmp16_);
	dvb_terrestrial_channel_set_Hierarchy (_tmp15_, _tmp17_);
	_tmp18_ = delivery;
	_tmp19_ = gst_structure_get_string (_tmp18_, "constellation");
	_tmp20_ = g_strdup (_tmp19_);
	constellation = _tmp20_;
	_tmp21_ = tc;
	_tmp22_ = constellation;
	_tmp23_ = dvb_get_modulation_val (_tmp22_);
	dvb_terrestrial_channel_set_Constellation (_tmp21_, _tmp23_);
	_tmp24_ = tc;
	_tmp25_ = delivery;
	_tmp26_ = gst_structure_get_string (_tmp25_, "code-rate-hp");
	_tmp27_ = dvb_get_code_rate_val (_tmp26_);
	dvb_terrestrial_channel_set_CodeRateHP (_tmp24_, _tmp27_);
	_tmp28_ = tc;
	_tmp29_ = delivery;
	_tmp30_ = gst_structure_get_string (_tmp29_, "code-rate-lp");
	_tmp31_ = dvb_get_code_rate_val (_tmp30_);
	dvb_terrestrial_channel_set_CodeRateLP (_tmp28_, _tmp31_);
	_tmp32_ = delivery;
	gst_structure_get_uint (_tmp32_, "guard-interval", &_tmp33_);
	guard = _tmp33_;
	_tmp34_ = tc;
	_tmp35_ = guard;
	_tmp36_ = dvb_get_guard_interval_val (_tmp35_);
	dvb_terrestrial_channel_set_GuardInterval (_tmp34_, _tmp36_);
	_tmp37_ = delivery;
	_tmp38_ = gst_structure_get_string (_tmp37_, "transmission-mode");
	_tmp39_ = g_strdup (_tmp38_);
	transmode = _tmp39_;
	_tmp40_ = tc;
	_tmp41_ = transmode;
	_tmp42_ = dvb_get_transmission_mode_val (_tmp41_);
	dvb_terrestrial_channel_set_TransmissionMode (_tmp40_, _tmp42_);
	_g_free0 (transmode);
	_g_free0 (constellation);
	_g_object_unref0 (tc);
}


static void dvb_terrestrial_scanner_class_init (DVBTerrestrialScannerClass * klass) {
	dvb_terrestrial_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->add_scanning_data_from_string = dvb_terrestrial_scanner_real_add_scanning_data_from_string;
	DVB_SCANNER_CLASS (klass)->prepare = dvb_terrestrial_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_terrestrial_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_terrestrial_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_terrestrial_scanner_real_add_values_from_structure_to_channel;
}


static void dvb_terrestrial_scanner_dvb_id_bus_scanner_interface_init (DVBIDBusScannerIface * iface) {
	dvb_terrestrial_scanner_dvb_id_bus_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = (gboolean (*)(DVBIDBusScanner*, GHashTable*, GError**)) dvb_terrestrial_scanner_real_AddScanningData;
	iface->Run = (void (*)(DVBIDBusScanner*, GError**)) dvb_scanner_Run;
	iface->Destroy = (void (*)(DVBIDBusScanner*, GError**)) dvb_scanner_Destroy;
	iface->WriteAllChannelsToFile = (gboolean (*)(DVBIDBusScanner*, const gchar*, GError**)) dvb_scanner_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = (gboolean (*)(DVBIDBusScanner*, guint*, int, const gchar*, GError**)) dvb_scanner_WriteChannelsToFile;
	iface->AddScanningDataFromFile = (gboolean (*)(DVBIDBusScanner*, const gchar*, GError**)) dvb_scanner_AddScanningDataFromFile;
}


static void dvb_terrestrial_scanner_instance_init (DVBTerrestrialScanner * self) {
}


GType dvb_terrestrial_scanner_get_type (void) {
	static volatile gsize dvb_terrestrial_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_terrestrial_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTerrestrialScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_terrestrial_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBTerrestrialScanner), 0, (GInstanceInitFunc) dvb_terrestrial_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_scanner_info = { (GInterfaceInitFunc) dvb_terrestrial_scanner_dvb_id_bus_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_terrestrial_scanner_type_id;
		dvb_terrestrial_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBTerrestrialScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_terrestrial_scanner_type_id, DVB_TYPE_ID_BUS_SCANNER, &dvb_id_bus_scanner_info);
		g_once_init_leave (&dvb_terrestrial_scanner_type_id__volatile, dvb_terrestrial_scanner_type_id);
	}
	return dvb_terrestrial_scanner_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



