/* RecordingsStore.c generated by valac 0.11.3, the Vala compiler
 * generated from RecordingsStore.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <dbus/dbus.h>
#include <gio/gio.h>
#include <time.h>


#define DVB_TYPE_ID_BUS_RECORDINGS_STORE (dvb_id_bus_recordings_store_get_type ())
#define DVB_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStore))
#define DVB_IS_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE))
#define DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStoreIface))

typedef struct _DVBIDBusRecordingsStore DVBIDBusRecordingsStore;
typedef struct _DVBIDBusRecordingsStoreIface DVBIDBusRecordingsStoreIface;

#define DVB_TYPE_RECORDING_INFO (dvb_recording_info_get_type ())
typedef struct _DVBRecordingInfo DVBRecordingInfo;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;
typedef struct _DVBRecordingsStorePrivate DVBRecordingsStorePrivate;

#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_CHANGE_TYPE (dvb_change_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_IO_TYPE_RECORDING_READER (dvb_io_recording_reader_get_type ())
#define DVB_IO_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReader))
#define DVB_IO_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))
#define DVB_IO_IS_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_IS_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_RECORDING_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))

typedef struct _DVBioRecordingReader DVBioRecordingReader;
typedef struct _DVBioRecordingReaderClass DVBioRecordingReaderClass;

struct _DVBRecordingInfo {
	guint32 id;
	gchar* name;
	gchar* description;
	gint64 length;
	gint64 start_timestamp;
	gchar* channel;
	gchar* location;
};

struct _DVBIDBusRecordingsStoreIface {
	GTypeInterface parent_iface;
	guint32* (*GetRecordings) (DVBIDBusRecordingsStore* self, int* result_length1, GError** error);
	gboolean (*GetLocation) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** location, GError** error);
	gboolean (*GetName) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
	gboolean (*GetDescription) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** description, GError** error);
	gboolean (*GetStartTime) (DVBIDBusRecordingsStore* self, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error);
	gboolean (*GetStartTimestamp) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* timestamp, GError** error);
	gboolean (*GetLength) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* length, GError** error);
	gboolean (*Delete) (DVBIDBusRecordingsStore* self, guint32 rec_id, GError** error);
	gboolean (*GetChannelName) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
	gboolean (*GetAllInformations) (DVBIDBusRecordingsStore* self, guint32 rec_id, DVBRecordingInfo* infos, GError** error);
};

struct _DVBRecordingsStore {
	GObject parent_instance;
	DVBRecordingsStorePrivate * priv;
};

struct _DVBRecordingsStoreClass {
	GObjectClass parent_class;
};

struct _DVBRecordingsStorePrivate {
	GeeHashMap* recordings;
	GStaticRecMutex __lock_recordings;
	guint32 last_id;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

typedef enum  {
	DVB_CHANGE_TYPE_ADDED = 0,
	DVB_CHANGE_TYPE_DELETED = 1,
	DVB_CHANGE_TYPE_UPDATED = 2
} DVBChangeType;


static gpointer dvb_recordings_store_parent_class = NULL;
static DVBRecordingsStore* dvb_recordings_store_instance;
static DVBRecordingsStore* dvb_recordings_store_instance = NULL;
static GStaticRecMutex dvb_recordings_store_instance_mutex;
static GStaticRecMutex dvb_recordings_store_instance_mutex = {0};
static DVBIDBusRecordingsStoreIface* dvb_recordings_store_dvb_id_bus_recordings_store_parent_iface = NULL;

DVBIDBusRecordingsStore* dvb_id_bus_recordings_store_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType dvb_recording_info_get_type (void) G_GNUC_CONST;
DVBRecordingInfo* dvb_recording_info_dup (const DVBRecordingInfo* self);
void dvb_recording_info_free (DVBRecordingInfo* self);
void dvb_recording_info_copy (const DVBRecordingInfo* self, DVBRecordingInfo* dest);
void dvb_recording_info_destroy (DVBRecordingInfo* self);
GType dvb_id_bus_recordings_store_get_type (void) G_GNUC_CONST;
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
GType dvb_recording_get_type (void) G_GNUC_CONST;
#define DVB_RECORDINGS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStorePrivate))
enum  {
	DVB_RECORDINGS_STORE_DUMMY_PROPERTY
};
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void dvb_recordings_store_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_recordings_store_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_recordings_store_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_recordings_store_introspect (DVBRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
DVBRecordingsStore* dvb_recordings_store_new (void);
DVBRecordingsStore* dvb_recordings_store_construct (GType object_type);
void dvb_recordings_store_shutdown (void);
void dvb_recordings_store_update_last_id (DVBRecordingsStore* self, guint32 new_last_id);
gboolean dvb_recordings_store_add (DVBRecordingsStore* self, DVBRecording* rec);
guint32 dvb_recording_get_Id (DVBRecording* self);
GType dvb_change_type_get_type (void) G_GNUC_CONST;
gboolean dvb_recordings_store_add_and_monitor (DVBRecordingsStore* self, DVBRecording* rec);
void dvb_recording_monitor_recording (DVBRecording* self);
void dvb_recordings_store_remove (DVBRecordingsStore* self, DVBRecording* rec);
guint32 dvb_recordings_store_get_next_id (DVBRecordingsStore* self);
static guint32* dvb_recordings_store_real_GetRecordings (DVBIDBusRecordingsStore* base, int* result_length1, GError** error);
static gboolean dvb_recordings_store_real_GetLocation (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** location, GError** error);
GFile* dvb_recording_get_Location (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetName (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** name, GError** error);
const gchar* dvb_recording_get_Name (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetDescription (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** description, GError** error);
const gchar* dvb_recording_get_Description (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetStartTime (DVBIDBusRecordingsStore* base, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error);
guint* dvb_recording_get_start (DVBRecording* self, int* result_length1);
static gboolean dvb_recordings_store_real_GetStartTimestamp (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* timestamp, GError** error);
void dvb_recording_get_StartTime (DVBRecording* self, struct tm* result);
static gboolean dvb_recordings_store_real_GetLength (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* length, GError** error);
gint64 dvb_recording_get_Length (DVBRecording* self);
static gboolean dvb_recordings_store_real_Delete (DVBIDBusRecordingsStore* base, guint32 rec_id, GError** error);
void dvb_utils_delete_dir_recursively (GFile* dir, GError** error);
static gboolean dvb_recordings_store_real_GetChannelName (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** name, GError** error);
const gchar* dvb_recording_get_ChannelName (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetAllInformations (DVBIDBusRecordingsStore* base, guint32 rec_id, DVBRecordingInfo* info, GError** error);
void dvb_recordings_store_restore_from_dir (DVBRecordingsStore* self, GFile* recordingsbasedir);
DVBioRecordingReader* dvb_io_recording_reader_new (GFile* recordingsbasedir, DVBRecordingsStore* recstore);
DVBioRecordingReader* dvb_io_recording_reader_construct (GType object_type, GFile* recordingsbasedir, DVBRecordingsStore* recstore);
GType dvb_io_recording_reader_get_type (void) G_GNUC_CONST;
gboolean dvb_io_recording_reader_load_into (DVBioRecordingReader* self);
static GObject * dvb_recordings_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_recordings_store_finalize (GObject* obj);

static const DBusObjectPathVTable _dvb_recordings_store_dbus_path_vtable = {_dvb_recordings_store_dbus_unregister, dvb_recordings_store_dbus_message};
static const _DBusObjectVTable _dvb_recordings_store_dbus_vtable = {dvb_recordings_store_dbus_register_object};

static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _dvb_recordings_store_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_recordings_store_introspect (DVBRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.RecordingsStore\">\n  <method name=\"GetRecordings\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLocation\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"location\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetName\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"name\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDescription\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"description\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTime\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_time\" type=\"au\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTimestamp\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"timestamp\" type=\"x\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLength\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"length\" type=\"x\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"Delete\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"name\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetAllInformations\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"infos\" type=\"(ussxxss)\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"Changed\">\n    <arg name=\"rec_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_recordings_store_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_recordings_store_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (dvb_id_bus_recordings_store_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_recordings_store_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_recordings_store_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dvb_id_bus_recordings_store_dbus_register_object (connection, path, object);
}


DVBRecordingsStore* dvb_recordings_store_get_instance (void) {
	DVBRecordingsStore* result = NULL;
	g_static_rec_mutex_lock (&dvb_recordings_store_instance_mutex);
	if (dvb_recordings_store_instance == NULL) {
		DVBRecordingsStore* _tmp0_ = NULL;
		DVBRecordingsStore* _tmp1_;
		_tmp0_ = dvb_recordings_store_new ();
		_tmp1_ = _tmp0_;
		_g_object_unref0 (dvb_recordings_store_instance);
		dvb_recordings_store_instance = _tmp1_;
	}
	g_static_rec_mutex_unlock (&dvb_recordings_store_instance_mutex);
	result = dvb_recordings_store_instance;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_recordings_store_shutdown (void) {
	DVBRecordingsStore* _tmp0_;
	DVBRecordingsStore* rs;
	g_static_rec_mutex_lock (&dvb_recordings_store_instance_mutex);
	_tmp0_ = _g_object_ref0 (dvb_recordings_store_instance);
	rs = _tmp0_;
	if (rs != NULL) {
		DVBRecordingsStore* _tmp1_;
		gee_abstract_map_clear ((GeeAbstractMap*) rs->priv->recordings);
		_tmp1_ = NULL;
		_g_object_unref0 (dvb_recordings_store_instance);
		dvb_recordings_store_instance = _tmp1_;
	}
	g_static_rec_mutex_unlock (&dvb_recordings_store_instance_mutex);
	_g_object_unref0 (rs);
}


void dvb_recordings_store_update_last_id (DVBRecordingsStore* self, guint32 new_last_id) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		if (new_last_id > self->priv->last_id) {
			self->priv->last_id = new_last_id;
		}
		__finally124:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gboolean dvb_recordings_store_add (DVBRecordingsStore* self, DVBRecording* rec) {
	gboolean result = FALSE;
	guint32 _tmp0_;
	guint32 id;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (rec != NULL, FALSE);
	_tmp0_ = dvb_recording_get_Id (rec);
	id = _tmp0_;
	{
		gboolean _tmp1_;
		guint32 _tmp2_;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		_tmp1_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (id));
		if (_tmp1_) {
			g_critical ("RecordingsStore.vala:70: Recording with id %u already available", (guint) id);
			result = FALSE;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
			return result;
		}
		_tmp2_ = dvb_recording_get_Id (rec);
		if (_tmp2_ > self->priv->last_id) {
			guint32 _tmp3_;
			_tmp3_ = dvb_recording_get_Id (rec);
			self->priv->last_id = _tmp3_;
		}
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (id), rec);
		g_signal_emit_by_name ((DVBIDBusRecordingsStore*) self, "changed", id, (guint) DVB_CHANGE_TYPE_ADDED);
		__finally125:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


gboolean dvb_recordings_store_add_and_monitor (DVBRecordingsStore* self, DVBRecording* rec) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (rec != NULL, FALSE);
	_tmp0_ = dvb_recordings_store_add (self, rec);
	if (_tmp0_) {
		dvb_recording_monitor_recording (rec);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


void dvb_recordings_store_remove (DVBRecordingsStore* self, DVBRecording* rec) {
	guint32 _tmp0_;
	guint32 rec_id;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rec != NULL);
	_tmp0_ = dvb_recording_get_Id (rec);
	rec_id = _tmp0_;
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id), NULL);
	g_signal_emit_by_name ((DVBIDBusRecordingsStore*) self, "changed", rec_id, (guint) DVB_CHANGE_TYPE_DELETED);
}


guint32 dvb_recordings_store_get_next_id (DVBRecordingsStore* self) {
	guint32 result = 0U;
	guint32 val = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		self->priv->last_id = self->priv->last_id + 1;
		val = self->priv->last_id;
		__finally126:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	result = val;
	return result;
}


/**
         * @returns: A list of ids for all recordings
         */
static guint32* dvb_recordings_store_real_GetRecordings (DVBIDBusRecordingsStore* base, int* result_length1, GError** error) {
	DVBRecordingsStore * self;
	guint32* result = NULL;
	gint ids_length1;
	gint _ids_size_;
	guint32* ids;
	guint32* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ids_length1 = 0;
	ids = NULL;
	{
		gint _tmp0_;
		guint32* _tmp1_ = NULL;
		guint32* _tmp2_;
		gint i;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->recordings);
		_tmp1_ = g_new0 (guint32, _tmp0_);
		_tmp2_ = _tmp1_;
		ids = (g_free (ids), NULL);
		ids_length1 = _tmp0_;
		_ids_size_ = ids_length1;
		ids = _tmp2_;
		i = 0;
		{
			GeeSet* _tmp3_ = NULL;
			GeeSet* _tmp4_;
			GeeIterator* _tmp5_ = NULL;
			GeeIterator* _tmp6_;
			GeeIterator* _key_it;
			_tmp3_ = gee_map_get_keys ((GeeMap*) self->priv->recordings);
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
			_key_it = (_tmp6_ = _tmp5_, _g_object_unref0 (_tmp4_), _tmp6_);
			while (TRUE) {
				gboolean _tmp7_;
				gpointer _tmp8_ = NULL;
				guint32 key;
				_tmp7_ = gee_iterator_next (_key_it);
				if (!_tmp7_) {
					break;
				}
				_tmp8_ = gee_iterator_get (_key_it);
				key = GPOINTER_TO_UINT (_tmp8_);
				ids[i] = key;
				i++;
			}
			_g_object_unref0 (_key_it);
		}
		__finally127:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp9_ = ids;
	*result_length1 = ids_length1;
	result = _tmp9_;
	return result;
}


/**
         * @rec_id: The id of the recording
         * @location: The location of the recording on the filesystem
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetLocation (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** location, GError** error) {
	DVBRecordingsStore * self;
	gchar* _location = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBRecording* _tmp2_;
			GFile* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
			_tmp2_ = (DVBRecording*) _tmp1_;
			_tmp3_ = dvb_recording_get_Location (_tmp2_);
			_tmp4_ = g_file_get_uri (_tmp3_);
			_tmp5_ = _tmp4_;
			_g_free0 (_location);
			_location = _tmp5_;
			_g_object_unref0 (_tmp2_);
			ret = TRUE;
		}
		__finally128:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = g_strdup ("");
		_tmp7_ = _tmp6_;
		_g_free0 (_location);
		_location = _tmp7_;
	}
	result = ret;
	if (location) {
		*location = _location;
	} else {
		_g_free0 (_location);
	}
	return result;
}


/**
         * @rec_id: The id of the recording
         * @name: The name of the recording (e.g. the name of
         * a TV show)
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetName (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** name, GError** error) {
	DVBRecordingsStore * self;
	gchar* _name = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBRecording* _tmp2_;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* val;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
			_tmp2_ = (DVBRecording*) _tmp1_;
			_tmp3_ = dvb_recording_get_Name (_tmp2_);
			_tmp4_ = g_strdup (_tmp3_);
			val = (_tmp5_ = _tmp4_, _g_object_unref0 (_tmp2_), _tmp5_);
			_tmp6_ = NULL;
			if (val == NULL) {
				_tmp6_ = "";
			} else {
				_tmp6_ = val;
			}
			_tmp7_ = g_strdup (_tmp6_);
			_tmp8_ = _tmp7_;
			_g_free0 (_name);
			_name = _tmp8_;
			ret = TRUE;
			_g_free0 (val);
		}
		__finally129:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = g_strdup ("");
		_tmp10_ = _tmp9_;
		_g_free0 (_name);
		_name = _tmp10_;
	}
	result = ret;
	if (name) {
		*name = _name;
	} else {
		_g_free0 (_name);
	}
	return result;
}


/**
         * @rec_id: The id of the recording
         * @description: A short text describing the recorded item
         * (e.g. the description from EPG)
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetDescription (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** description, GError** error) {
	DVBRecordingsStore * self;
	gchar* _description = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBRecording* _tmp2_;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* val;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
			_tmp2_ = (DVBRecording*) _tmp1_;
			_tmp3_ = dvb_recording_get_Description (_tmp2_);
			_tmp4_ = g_strdup (_tmp3_);
			val = (_tmp5_ = _tmp4_, _g_object_unref0 (_tmp2_), _tmp5_);
			_tmp6_ = NULL;
			if (val == NULL) {
				_tmp6_ = "";
			} else {
				_tmp6_ = val;
			}
			_tmp7_ = g_strdup (_tmp6_);
			_tmp8_ = _tmp7_;
			_g_free0 (_description);
			_description = _tmp8_;
			ret = TRUE;
			_g_free0 (val);
		}
		__finally130:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = g_strdup ("");
		_tmp10_ = _tmp9_;
		_g_free0 (_description);
		_description = _tmp10_;
	}
	result = ret;
	if (description) {
		*description = _description;
	} else {
		_g_free0 (_description);
	}
	return result;
}


/**
         * @rec_id: The id of the recording
         * @start_time: The starting time of the recording
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetStartTime (DVBIDBusRecordingsStore* base, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error) {
	DVBRecordingsStore * self;
	guint* _start_time = NULL;
	int _start_time_length1 = 0;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBRecording* _tmp2_;
			gint _tmp3_;
			guint* _tmp4_ = NULL;
			guint* _tmp5_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
			_tmp2_ = (DVBRecording*) _tmp1_;
			_tmp4_ = dvb_recording_get_start (_tmp2_, &_tmp3_);
			_tmp5_ = _tmp4_;
			_start_time = (g_free (_start_time), NULL);
			_start_time_length1 = _tmp3_;
			_start_time = _tmp5_;
			_g_object_unref0 (_tmp2_);
			ret = TRUE;
		} else {
			guint* _tmp6_ = NULL;
			guint* _tmp7_;
			_tmp6_ = g_new0 (guint, 0);
			_tmp7_ = _tmp6_;
			_start_time = (g_free (_start_time), NULL);
			_start_time_length1 = 0;
			_start_time = _tmp7_;
			ret = FALSE;
		}
		__finally131:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (start_time) {
		*start_time = _start_time;
	} else {
		_start_time = (g_free (_start_time), NULL);
	}
	if (start_time_length1) {
		*start_time_length1 = _start_time_length1;
	}
	return result;
}


/**
         * @rec_id: The id of the recording
         * @timestamp: Start time as UNIX timestamp
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetStartTimestamp (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* timestamp, GError** error) {
	DVBRecordingsStore * self;
	gint64 _timestamp = 0LL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBRecording* _tmp2_;
			struct tm _tmp3_ = {0};
			time_t _tmp4_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
			_tmp2_ = (DVBRecording*) _tmp1_;
			dvb_recording_get_StartTime (_tmp2_, &_tmp3_);
			_tmp4_ = mktime (&_tmp3_);
			_timestamp = (gint64) _tmp4_;
			_g_object_unref0 (_tmp2_);
			ret = TRUE;
		}
		__finally132:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (timestamp) {
		*timestamp = _timestamp;
	}
	return result;
}


/**
         * @rec_id: The id of the recording
         * @length: The length of the recording in seconds
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetLength (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* length, GError** error) {
	DVBRecordingsStore * self;
	gint64 _length = 0LL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBRecording* _tmp2_;
			gint64 _tmp3_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
			_tmp2_ = (DVBRecording*) _tmp1_;
			_tmp3_ = dvb_recording_get_Length (_tmp2_);
			_length = _tmp3_;
			_g_object_unref0 (_tmp2_);
			ret = TRUE;
		}
		__finally133:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (length) {
		*length = _length;
	}
	return result;
}


/**
         * @rec_id: The id of the recording
         * @returns: TRUE on success, FALSE otherwises
         *
         * Delete the recording. This deletes all files in the directory
         * created by the Recorder
         */
static gboolean dvb_recordings_store_real_Delete (DVBIDBusRecordingsStore* base, guint32 rec_id, GError** error) {
	DVBRecordingsStore * self;
	gboolean result = FALSE;
	gboolean val;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	val = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
		if (!_tmp0_) {
			val = FALSE;
		} else {
			gpointer _tmp1_ = NULL;
			DVBRecording* rec;
			GFile* _tmp2_ = NULL;
			GFile* _tmp3_ = NULL;
			GFile* _tmp4_;
			g_debug ("RecordingsStore.vala:245: Deleting recording %u", (guint) rec_id);
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
			rec = (DVBRecording*) _tmp1_;
			_tmp2_ = dvb_recording_get_Location (rec);
			_tmp3_ = g_file_get_parent (_tmp2_);
			_tmp4_ = _tmp3_;
			dvb_utils_delete_dir_recursively (_tmp4_, &_inner_error_);
			_g_object_unref0 (_tmp4_);
			if (_inner_error_ != NULL) {
				goto __catch135_g_error;
			}
			val = TRUE;
			goto __finally135;
			__catch135_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				g_critical ("RecordingsStore.vala:251: Could not delete recording: %s", e->message);
				val = FALSE;
				_g_error_free0 (e);
			}
			__finally135:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (rec);
				_g_object_unref0 (rec);
				g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			dvb_recordings_store_remove (self, rec);
			_g_object_unref0 (rec);
		}
		__finally134:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = val;
	return result;
}


/**
         * @rec_id: The id of the recording
         * @name: The channel's name or an empty string if
         * rec_id doesn't exist
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetChannelName (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** name, GError** error) {
	DVBRecordingsStore * self;
	gchar* _name = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBRecording* rec;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
			rec = (DVBRecording*) _tmp1_;
			_tmp2_ = dvb_recording_get_ChannelName (rec);
			_tmp3_ = g_strdup (_tmp2_);
			_tmp4_ = _tmp3_;
			_g_free0 (_name);
			_name = _tmp4_;
			ret = TRUE;
			_g_object_unref0 (rec);
		}
		__finally136:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup ("");
		_tmp6_ = _tmp5_;
		_g_free0 (_name);
		_name = _tmp6_;
	}
	result = ret;
	if (name) {
		*name = _name;
	} else {
		_g_free0 (_name);
	}
	return result;
}


static gboolean dvb_recordings_store_real_GetAllInformations (DVBIDBusRecordingsStore* base, guint32 rec_id, DVBRecordingInfo* info, GError** error) {
	DVBRecordingsStore * self;
	DVBRecordingInfo _info = {0};
	gboolean result = FALSE;
	gboolean ret = FALSE;
	DVBRecordingInfo _tmp0_ = {0};
	DVBRecordingInfo _tmp1_ = {0};
	DVBRecordingInfo _tmp2_;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	memset (&_tmp0_, 0, sizeof (DVBRecordingInfo));
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	dvb_recording_info_destroy (&_info);
	_info = _tmp2_;
	{
		gboolean _tmp3_;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
		if (_tmp3_) {
			gpointer _tmp4_ = NULL;
			DVBRecording* rec;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gchar* name;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gint64 _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			GFile* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			struct tm _tmp19_ = {0};
			time_t _tmp20_;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
			rec = (DVBRecording*) _tmp4_;
			_tmp5_ = dvb_recording_get_Name (rec);
			_tmp6_ = g_strdup (_tmp5_);
			name = _tmp6_;
			_tmp7_ = NULL;
			if (name == NULL) {
				_tmp7_ = "";
			} else {
				_tmp7_ = name;
			}
			_tmp8_ = g_strdup (_tmp7_);
			_tmp9_ = _tmp8_;
			_g_free0 (_info.name);
			_info.name = _tmp9_;
			_info.id = rec_id;
			_tmp10_ = dvb_recording_get_Length (rec);
			_info.length = _tmp10_;
			_tmp11_ = NULL;
			_tmp12_ = dvb_recording_get_Description (rec);
			if (_tmp12_ == NULL) {
				_tmp11_ = "";
			} else {
				const gchar* _tmp13_ = NULL;
				_tmp13_ = dvb_recording_get_Description (rec);
				_tmp11_ = _tmp13_;
			}
			_tmp14_ = g_strdup (_tmp11_);
			_tmp15_ = _tmp14_;
			_g_free0 (_info.description);
			_info.description = _tmp15_;
			_tmp16_ = dvb_recording_get_Location (rec);
			_tmp17_ = g_file_get_path (_tmp16_);
			_tmp18_ = _tmp17_;
			_g_free0 (_info.location);
			_info.location = _tmp18_;
			dvb_recording_get_StartTime (rec, &_tmp19_);
			_tmp20_ = mktime (&_tmp19_);
			_info.start_timestamp = (gint64) _tmp20_;
			_tmp21_ = dvb_recording_get_ChannelName (rec);
			_tmp22_ = g_strdup (_tmp21_);
			_tmp23_ = _tmp22_;
			_g_free0 (_info.channel);
			_info.channel = _tmp23_;
			ret = TRUE;
			_g_free0 (name);
			_g_object_unref0 (rec);
		} else {
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp24_ = g_strdup ("");
			_tmp25_ = _tmp24_;
			_g_free0 (_info.name);
			_info.name = _tmp25_;
			_info.id = (guint32) 0;
			_info.length = (gint64) 0;
			_tmp26_ = g_strdup ("");
			_tmp27_ = _tmp26_;
			_g_free0 (_info.description);
			_info.description = _tmp27_;
			_tmp28_ = g_strdup ("");
			_tmp29_ = _tmp28_;
			_g_free0 (_info.location);
			_info.location = _tmp29_;
			_info.start_timestamp = (gint64) 0;
			_tmp30_ = g_strdup ("");
			_tmp31_ = _tmp30_;
			_g_free0 (_info.channel);
			_info.channel = _tmp31_;
			ret = FALSE;
		}
		__finally137:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (info) {
		*info = _info;
	} else {
		dvb_recording_info_destroy (&_info);
	}
	return result;
}


void dvb_recordings_store_restore_from_dir (DVBRecordingsStore* self, GFile* recordingsbasedir) {
	DVBioRecordingReader* _tmp0_ = NULL;
	DVBioRecordingReader* reader;
	g_return_if_fail (self != NULL);
	g_return_if_fail (recordingsbasedir != NULL);
	_tmp0_ = dvb_io_recording_reader_new (recordingsbasedir, self);
	reader = _tmp0_;
	dvb_io_recording_reader_load_into (reader);
	_g_object_unref0 (reader);
}


DVBRecordingsStore* dvb_recordings_store_construct (GType object_type) {
	DVBRecordingsStore * self = NULL;
	self = (DVBRecordingsStore*) g_object_new (object_type, NULL);
	return self;
}


DVBRecordingsStore* dvb_recordings_store_new (void) {
	return dvb_recordings_store_construct (DVB_TYPE_RECORDINGS_STORE);
}


static GObject * dvb_recordings_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBRecordingsStore * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_;
	parent_class = G_OBJECT_CLASS (dvb_recordings_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_RECORDINGS_STORE (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_RECORDING, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->recordings);
	self->priv->recordings = _tmp1_;
	self->priv->last_id = (guint32) 0;
	return obj;
}


static void dvb_recordings_store_class_init (DVBRecordingsStoreClass * klass) {
	GStaticRecMutex _tmp0_ = {0};
	GStaticRecMutex _tmp1_ = {0};
	dvb_recordings_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecordingsStorePrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_recordings_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_recordings_store_finalize;
	g_type_set_qdata (DVB_TYPE_RECORDINGS_STORE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_recordings_store_dbus_vtable));
	g_static_rec_mutex_init (&_tmp0_);
	_tmp1_ = _tmp0_;
	dvb_recordings_store_instance_mutex = _tmp1_;
}


static void dvb_recordings_store_dvb_id_bus_recordings_store_interface_init (DVBIDBusRecordingsStoreIface * iface) {
	dvb_recordings_store_dvb_id_bus_recordings_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetRecordings = (guint32* (*)(DVBIDBusRecordingsStore* ,int* ,GError**)) dvb_recordings_store_real_GetRecordings;
	iface->GetLocation = (gboolean (*)(DVBIDBusRecordingsStore* ,guint32 ,gchar** ,GError**)) dvb_recordings_store_real_GetLocation;
	iface->GetName = (gboolean (*)(DVBIDBusRecordingsStore* ,guint32 ,gchar** ,GError**)) dvb_recordings_store_real_GetName;
	iface->GetDescription = (gboolean (*)(DVBIDBusRecordingsStore* ,guint32 ,gchar** ,GError**)) dvb_recordings_store_real_GetDescription;
	iface->GetStartTime = (gboolean (*)(DVBIDBusRecordingsStore* ,guint32 ,guint** ,int* ,GError**)) dvb_recordings_store_real_GetStartTime;
	iface->GetStartTimestamp = (gboolean (*)(DVBIDBusRecordingsStore* ,guint32 ,gint64* ,GError**)) dvb_recordings_store_real_GetStartTimestamp;
	iface->GetLength = (gboolean (*)(DVBIDBusRecordingsStore* ,guint32 ,gint64* ,GError**)) dvb_recordings_store_real_GetLength;
	iface->Delete = (gboolean (*)(DVBIDBusRecordingsStore* ,guint32 ,GError**)) dvb_recordings_store_real_Delete;
	iface->GetChannelName = (gboolean (*)(DVBIDBusRecordingsStore* ,guint32 ,gchar** ,GError**)) dvb_recordings_store_real_GetChannelName;
	iface->GetAllInformations = (gboolean (*)(DVBIDBusRecordingsStore* ,guint32 ,DVBRecordingInfo* ,GError**)) dvb_recordings_store_real_GetAllInformations;
}


static void dvb_recordings_store_instance_init (DVBRecordingsStore * self) {
	self->priv = DVB_RECORDINGS_STORE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_recordings);
}


static void dvb_recordings_store_finalize (GObject* obj) {
	DVBRecordingsStore * self;
	self = DVB_RECORDINGS_STORE (obj);
	g_static_rec_mutex_free (&self->priv->__lock_recordings);
	_g_object_unref0 (self->priv->recordings);
	G_OBJECT_CLASS (dvb_recordings_store_parent_class)->finalize (obj);
}


/**
     * This class manages the recordings off all devices
     */
GType dvb_recordings_store_get_type (void) {
	static volatile gsize dvb_recordings_store_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_recordings_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecordingsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recordings_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecordingsStore), 0, (GInstanceInitFunc) dvb_recordings_store_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_recordings_store_info = { (GInterfaceInitFunc) dvb_recordings_store_dvb_id_bus_recordings_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_recordings_store_type_id;
		dvb_recordings_store_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecordingsStore", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_recordings_store_type_id, DVB_TYPE_ID_BUS_RECORDINGS_STORE, &dvb_id_bus_recordings_store_info);
		g_once_init_leave (&dvb_recordings_store_type_id__volatile, dvb_recordings_store_type_id);
	}
	return dvb_recordings_store_type_id__volatile;
}



