/* EPGScanner.c generated by valac 0.11.3, the Vala compiler
 * generated from EPGScanner.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <cstuff.h>


#define DVB_TYPE_EPG_SCANNER (dvb_epg_scanner_get_type ())
#define DVB_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScanner))
#define DVB_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))
#define DVB_IS_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_SCANNER))
#define DVB_IS_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EPG_SCANNER))
#define DVB_EPG_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))

typedef struct _DVBEPGScanner DVBEPGScanner;
typedef struct _DVBEPGScannerClass DVBEPGScannerClass;
typedef struct _DVBEPGScannerPrivate DVBEPGScannerPrivate;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))

struct _DVBEPGScanner {
	GObject parent_instance;
	DVBEPGScannerPrivate * priv;
};

struct _DVBEPGScannerClass {
	GObjectClass parent_class;
};

struct _DVBEPGScannerPrivate {
	DVBDeviceGroup* DeviceGroup;
	GstElement* pipeline;
	GStaticRecMutex __lock_pipeline;
	GQueue* channels;
	GSource* scan_source;
	GSource* queue_source;
	gint stop_counter;
	GMainContext* context;
	GMainLoop* loop;
	GThread* worker_thread;
	guint bus_watch_id;
	GeeHashMap* channel_events;
	GStaticRecMutex __lock_channel_events;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};


static gpointer dvb_epg_scanner_parent_class = NULL;
static gint dvb_epg_scanner_CHECK_EIT_INTERVAL;
static gint dvb_epg_scanner_CHECK_EIT_INTERVAL = 0;

GType dvb_epg_scanner_get_type (void) G_GNUC_CONST;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
#define DVB_EPG_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_EPG_SCANNER, DVBEPGScannerPrivate))
enum  {
	DVB_EPG_SCANNER_DUMMY_PROPERTY
};
#define DVB_EPG_SCANNER_WAIT_FOR_EIT_DURATION 10
#define DVB_EPG_SCANNER_PIPELINE_TEMPLATE "dvbsrc name=dvbsrc adapter=%u frontend=%u pids=0:16:17:18 stats-report" \
"ing-interval=0 ! mpegtsparse ! fakesink silent=true"
DVBEPGScanner* dvb_epg_scanner_new (DVBDeviceGroup* device);
DVBEPGScanner* dvb_epg_scanner_construct (GType object_type, DVBDeviceGroup* device);
GType dvb_settings_get_type (void) G_GNUC_CONST;
DVBSettings* dvb_factory_get_settings (void);
gint dvb_settings_get_epg_scan_interval (DVBSettings* self);
void dvb_epg_scanner_stop (DVBEPGScanner* self);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
static void dvb_epg_scanner_remove_timeouts (DVBEPGScanner* self);
static void dvb_epg_scanner_reset (DVBEPGScanner* self);
static gboolean dvb_epg_scanner_worker (DVBEPGScanner* self);
gboolean dvb_epg_scanner_start (DVBEPGScanner* self);
static gpointer _dvb_epg_scanner_worker_gthread_func (gpointer self);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GType dvb_device_get_type (void) G_GNUC_CONST;
DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
static gboolean dvb_epg_scanner_bus_watch_func (DVBEPGScanner* self, GstBus* bus, GstMessage* message);
static gboolean _dvb_epg_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
static gboolean dvb_epg_scanner_scan_new_frequency (DVBEPGScanner* self);
static gboolean _dvb_epg_scanner_scan_new_frequency_gsource_func (gpointer self);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
const gchar* dvb_channel_get_Name (DVBChannel* self);
GType dvb_schedule_get_type (void) G_GNUC_CONST;
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
void dvb_schedule_add_all (DVBSchedule* self, GeeCollection* new_events);
static gboolean _dvb_epg_scanner_start_gsource_func (gpointer self);
void dvb_schedule_remove_expired_events (DVBSchedule* self);
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source);
void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, const GstStructure* structure);
DVBEvent* dvb_event_new (void);
DVBEvent* dvb_event_construct (GType object_type);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
static guint dvb_epg_scanner_get_uint_val (const GstStructure* structure, const gchar* name);
gboolean dvb_event_has_expired (DVBEvent* self);
guint dvb_event_hash (DVBEvent* event);
static guint _dvb_event_hash_ghash_func (gconstpointer key);
gboolean dvb_event_equal (DVBEvent* event1, DVBEvent* event2);
static gboolean _dvb_event_equal_gequal_func (gconstpointer a, gconstpointer b);
static GObject * dvb_epg_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_epg_scanner_finalize (GObject* obj);


/**
         * @device: The device where EPG should be collected from
         */
DVBEPGScanner* dvb_epg_scanner_construct (GType object_type, DVBDeviceGroup* device) {
	DVBEPGScanner * self = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	self = (DVBEPGScanner*) g_object_new (object_type, NULL);
	self->priv->DeviceGroup = device;
	if (dvb_epg_scanner_CHECK_EIT_INTERVAL == (-1)) {
		DVBSettings* _tmp0_ = NULL;
		DVBSettings* settings;
		gint _tmp1_;
		_tmp0_ = dvb_factory_get_settings ();
		settings = _tmp0_;
		_tmp1_ = dvb_settings_get_epg_scan_interval (settings);
		dvb_epg_scanner_CHECK_EIT_INTERVAL = _tmp1_;
		_g_object_unref0 (settings);
	}
	return self;
}


DVBEPGScanner* dvb_epg_scanner_new (DVBDeviceGroup* device) {
	return dvb_epg_scanner_construct (DVB_TYPE_EPG_SCANNER, device);
}


/**
         * Stop collecting EPG data
         */
void dvb_epg_scanner_stop (DVBEPGScanner* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_device_group_get_Id (self->priv->DeviceGroup);
	g_debug ("EPGScanner.vala:72: Stopping EPG scan for group %u (%d)", _tmp0_, self->priv->stop_counter);
	if (self->priv->stop_counter == 0) {
		dvb_epg_scanner_remove_timeouts (self);
		dvb_epg_scanner_reset (self);
	}
	self->priv->stop_counter = self->priv->stop_counter + 1;
}


static void dvb_epg_scanner_remove_timeouts (DVBEPGScanner* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->scan_source != NULL) {
		GSource* _tmp0_;
		g_source_destroy (self->priv->scan_source);
		_tmp0_ = NULL;
		_g_source_unref0 (self->priv->scan_source);
		self->priv->scan_source = _tmp0_;
	}
	if (self->priv->queue_source != NULL) {
		GSource* _tmp1_;
		g_source_destroy (self->priv->queue_source);
		_tmp1_ = NULL;
		_g_source_unref0 (self->priv->queue_source);
		self->priv->queue_source = _tmp1_;
	}
	if (self->priv->loop != NULL) {
		GMainLoop* _tmp2_;
		g_main_loop_quit (self->priv->loop);
		_tmp2_ = NULL;
		_g_main_loop_unref0 (self->priv->loop);
		self->priv->loop = _tmp2_;
		g_thread_join (self->priv->worker_thread);
		self->priv->worker_thread = NULL;
	}
}


static gboolean dvb_epg_scanner_worker (DVBEPGScanner* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_main_loop_run (self->priv->loop);
	result = TRUE;
	return result;
}


static gpointer _g_source_ref0 (gpointer self) {
	return self ? g_source_ref (self) : NULL;
}


static void dvb_epg_scanner_reset (DVBEPGScanner* self) {
	DVBChannel* c;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		if (self->priv->pipeline != NULL) {
			GSource* _tmp0_ = NULL;
			GSource* _tmp1_;
			GSource* bus_watch_source;
			GstElement* _tmp2_;
			_tmp0_ = g_main_context_find_source_by_id (self->priv->context, self->priv->bus_watch_id);
			_tmp1_ = _g_source_ref0 (_tmp0_);
			bus_watch_source = _tmp1_;
			if (bus_watch_source != NULL) {
				g_source_destroy (bus_watch_source);
				self->priv->bus_watch_id = (guint) 0;
			}
			gst_element_set_state (self->priv->pipeline, GST_STATE_NULL);
			gst_element_get_state (self->priv->pipeline, NULL, NULL, (GstClockTime) (-1));
			_tmp2_ = NULL;
			_gst_object_unref0 (self->priv->pipeline);
			self->priv->pipeline = _tmp2_;
			_g_source_unref0 (bus_watch_source);
		}
		__finally60:
		g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	c = NULL;
	while (TRUE) {
		gpointer _tmp3_ = NULL;
		DVBChannel* _tmp4_;
		_tmp3_ = g_queue_pop_head (self->priv->channels);
		_tmp4_ = (DVBChannel*) _tmp3_;
		_g_object_unref0 (c);
		c = _tmp4_;
		if (!(c != NULL)) {
			break;
		}
	}
	g_queue_clear (self->priv->channels);
	gee_abstract_map_clear ((GeeAbstractMap*) self->priv->channel_events);
	_g_object_unref0 (c);
}


/**
         * Start collection EPG data for all channels
         */
static gpointer _dvb_epg_scanner_worker_gthread_func (gpointer self) {
	gpointer result;
	result = dvb_epg_scanner_worker (self);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _dvb_epg_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = dvb_epg_scanner_bus_watch_func (self, bus, message);
	return result;
}


static gboolean _dvb_epg_scanner_scan_new_frequency_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_epg_scanner_scan_new_frequency (self);
	return result;
}


gboolean dvb_epg_scanner_start (DVBEPGScanner* self) {
	gboolean result = FALSE;
	guint _tmp0_;
	GMainLoop* _tmp1_ = NULL;
	GMainLoop* _tmp2_;
	GThread* _tmp3_ = NULL;
	GThread* _tmp4_;
	DVBDevice* _tmp10_ = NULL;
	DVBDevice* device;
	GSource* _tmp21_ = NULL;
	GSource* _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = dvb_device_group_get_Id (self->priv->DeviceGroup);
	g_debug ("EPGScanner.vala:134: Starting EPG scan for group %u (%d)", _tmp0_, self->priv->stop_counter);
	_tmp1_ = g_main_loop_new (self->priv->context, FALSE);
	_tmp2_ = _tmp1_;
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp2_;
	_tmp3_ = g_thread_create (_dvb_epg_scanner_worker_gthread_func, self, TRUE, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_THREAD_ERROR) {
			goto __catch61_g_thread_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	self->priv->worker_thread = _tmp4_;
	goto __finally61;
	__catch61_g_thread_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("EPGScanner.vala:140: Could not create thread: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally61:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	self->priv->stop_counter = self->priv->stop_counter - 1;
	if (self->priv->stop_counter > 0) {
		result = FALSE;
		return result;
	}
	self->priv->stop_counter = 0;
	{
		DVBChannelList* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		GeeIterator* _c_it;
		_tmp5_ = dvb_device_group_get_Channels (self->priv->DeviceGroup);
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_c_it = _tmp6_;
		while (TRUE) {
			gboolean _tmp7_;
			gpointer _tmp8_ = NULL;
			DVBChannel* c;
			DVBChannel* _tmp9_;
			_tmp7_ = gee_iterator_next (_c_it);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = gee_iterator_get (_c_it);
			c = (DVBChannel*) _tmp8_;
			_tmp9_ = _g_object_ref0 (c);
			g_queue_push_tail (self->priv->channels, _tmp9_);
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_it);
	}
	_tmp10_ = dvb_device_group_get_next_free_device (self->priv->DeviceGroup);
	device = _tmp10_;
	if (device == NULL) {
		result = FALSE;
		_g_object_unref0 (device);
		return result;
	}
	{
		guint _tmp11_;
		guint _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		GstElement* _tmp15_ = NULL;
		GstElement* _tmp16_;
		GstElement* _tmp17_;
		GstElement* _tmp18_;
		GstBus* _tmp19_ = NULL;
		GstBus* bus;
		guint _tmp20_;
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		_tmp11_ = dvb_device_get_Adapter (device);
		_tmp12_ = dvb_device_get_Frontend (device);
		_tmp13_ = g_strdup_printf (DVB_EPG_SCANNER_PIPELINE_TEMPLATE, _tmp11_, _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = gst_parse_launch (_tmp14_, &_inner_error_);
		_tmp17_ = (_tmp16_ = _tmp15_, _g_free0 (_tmp14_), _tmp16_);
		if (_inner_error_ != NULL) {
			goto __catch63_g_error;
		}
		_tmp18_ = _tmp17_;
		_gst_object_unref0 (self->priv->pipeline);
		self->priv->pipeline = _tmp18_;
		goto __finally63;
		__catch63_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_critical ("EPGScanner.vala:160: Could not create pipeline: %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
			_g_object_unref0 (device);
			return result;
		}
		__finally63:
		if (_inner_error_ != NULL) {
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
			_g_object_unref0 (device);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp19_ = gst_element_get_bus (self->priv->pipeline);
		bus = _tmp19_;
		_tmp20_ = gst_bus_add_watch_context (bus, _dvb_epg_scanner_bus_watch_func_gst_bus_func, self, self->priv->context);
		self->priv->bus_watch_id = _tmp20_;
		_gst_object_unref0 (bus);
		__finally62:
		g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (device);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp21_ = g_timeout_source_new_seconds ((guint) DVB_EPG_SCANNER_WAIT_FOR_EIT_DURATION);
	_tmp22_ = _tmp21_;
	_g_source_unref0 (self->priv->scan_source);
	self->priv->scan_source = _tmp22_;
	g_source_set_callback (self->priv->scan_source, _dvb_epg_scanner_scan_new_frequency_gsource_func, g_object_ref (self), g_object_unref);
	g_source_attach (self->priv->scan_source, self->priv->context);
	result = FALSE;
	_g_object_unref0 (device);
	return result;
}


/**
         * Scan the next frequency for EPG data
         */
static gboolean _dvb_epg_scanner_start_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_epg_scanner_start (self);
	return result;
}


static gboolean dvb_epg_scanner_scan_new_frequency (DVBEPGScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp12_;
	gpointer _tmp16_ = NULL;
	DVBChannel* channel;
	DVBSchedule* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channel_events);
		{
			GeeSet* _tmp0_ = NULL;
			GeeSet* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _tmp3_;
			GeeIterator* _sid_it;
			_tmp0_ = gee_map_get_keys ((GeeMap*) self->priv->channel_events);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_sid_it = (_tmp3_ = _tmp2_, _g_object_unref0 (_tmp1_), _tmp3_);
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				guint sid;
				DVBChannelList* _tmp6_ = NULL;
				DVBChannel* _tmp7_ = NULL;
				DVBChannel* channel;
				gpointer _tmp8_ = NULL;
				GeeHashSet* list;
				gint _tmp9_;
				const gchar* _tmp10_ = NULL;
				DVBSchedule* _tmp11_ = NULL;
				_tmp4_ = gee_iterator_next (_sid_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_sid_it);
				sid = GPOINTER_TO_UINT (_tmp5_);
				_tmp6_ = dvb_device_group_get_Channels (self->priv->DeviceGroup);
				_tmp7_ = dvb_channel_list_get_channel (_tmp6_, sid);
				channel = _tmp7_;
				if (channel == NULL) {
					g_warning ("EPGScanner.vala:184: Could not find channel %u for this device", sid);
					_g_object_unref0 (channel);
					continue;
				}
				_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->channel_events, GUINT_TO_POINTER (sid));
				list = (GeeHashSet*) _tmp8_;
				_tmp9_ = gee_collection_get_size ((GeeCollection*) list);
				_tmp10_ = dvb_channel_get_Name (channel);
				g_debug ("EPGScanner.vala:189: Adding %d events of channel %s (%u)", _tmp9_, _tmp10_, sid);
				_tmp11_ = dvb_channel_get_Schedule (channel);
				dvb_schedule_add_all (_tmp11_, (GeeCollection*) list);
				_g_object_unref0 (list);
				_g_object_unref0 (channel);
			}
			_g_object_unref0 (_sid_it);
		}
		gee_abstract_map_clear ((GeeAbstractMap*) self->priv->channel_events);
		__finally64:
		g_static_rec_mutex_unlock (&self->priv->__lock_channel_events);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp12_ = g_queue_is_empty (self->priv->channels);
	if (_tmp12_) {
		guint _tmp13_;
		GSource* _tmp14_ = NULL;
		GSource* _tmp15_;
		_tmp13_ = dvb_device_group_get_Id (self->priv->DeviceGroup);
		g_debug ("EPGScanner.vala:197: Finished EPG scan for group %u", _tmp13_);
		dvb_epg_scanner_reset (self);
		_tmp14_ = g_timeout_source_new_seconds ((guint) dvb_epg_scanner_CHECK_EIT_INTERVAL);
		_tmp15_ = _tmp14_;
		_g_source_unref0 (self->priv->queue_source);
		self->priv->queue_source = _tmp15_;
		g_source_set_callback (self->priv->queue_source, _dvb_epg_scanner_start_gsource_func, g_object_ref (self), g_object_unref);
		g_source_attach (self->priv->queue_source, self->priv->context);
		result = FALSE;
		return result;
	}
	_tmp16_ = g_queue_pop_head (self->priv->channels);
	channel = (DVBChannel*) _tmp16_;
	_tmp17_ = dvb_channel_get_Schedule (channel);
	dvb_schedule_remove_expired_events (_tmp17_);
	{
		GstElement* _tmp18_ = NULL;
		GstElement* dvbsrc;
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		gst_element_set_state (self->priv->pipeline, GST_STATE_READY);
		_tmp18_ = gst_bin_get_by_name (GST_BIN (self->priv->pipeline), "dvbsrc");
		dvbsrc = _tmp18_;
		dvb_channel_setup_dvb_source (channel, dvbsrc);
		gst_element_set_state (self->priv->pipeline, GST_STATE_PLAYING);
		_gst_object_unref0 (dvbsrc);
		__finally65:
		g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_object_unref0 (channel);
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static gboolean dvb_epg_scanner_bus_watch_func (DVBEPGScanner* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	switch (message->type) {
		case GST_MESSAGE_ELEMENT:
		{
			const GstStructure* _tmp0_ = NULL;
			GstStructure* _tmp1_;
			GstStructure* structure;
			const gchar* _tmp2_ = NULL;
			_tmp0_ = gst_message_get_structure (message);
			_tmp1_ = _gst_structure_copy0 (_tmp0_);
			structure = _tmp1_;
			_tmp2_ = gst_structure_get_name (structure);
			if (g_strcmp0 (_tmp2_, "dvb-read-failure") == 0) {
				g_critical ("EPGScanner.vala:229: Could not read from DVB device");
				dvb_epg_scanner_stop (self);
			} else {
				const gchar* _tmp3_ = NULL;
				_tmp3_ = gst_structure_get_name (structure);
				if (g_strcmp0 (_tmp3_, "eit") == 0) {
					dvb_epg_scanner_on_eit_structure (self, structure);
				}
			}
			_gst_structure_free0 (structure);
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* gerror;
			gchar* debug;
			GError* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			gerror = NULL;
			debug = NULL;
			gst_message_parse_error (message, &_tmp4_, &_tmp5_);
			_g_error_free0 (gerror);
			gerror = _tmp4_;
			_g_free0 (debug);
			debug = _tmp5_;
			g_critical ("EPGScanner.vala:240: %s %s", gerror->message, debug);
			dvb_epg_scanner_stop (self);
			result = FALSE;
			_g_free0 (debug);
			_g_error_free0 (gerror);
			return result;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}


static guint _dvb_event_hash_ghash_func (gconstpointer key) {
	guint result;
	result = dvb_event_hash (key);
	return result;
}


static gboolean _dvb_event_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = dvb_event_equal (a, b);
	return result;
}


void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, const GstStructure* structure) {
	GValue* _tmp0_ = NULL;
	GValue events;
	GType _tmp1_;
	gboolean _tmp2_;
	guint _tmp3_;
	guint size;
	GValue val = {0};
	const GstStructure* event;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	_tmp0_ = gst_structure_get_value (structure, "events");
	events = *_tmp0_;
	_tmp1_ = gst_value_list_get_type ();
	_tmp2_ = G_VALUE_HOLDS (&events, _tmp1_);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = gst_value_list_get_size (&events);
	size = _tmp3_;
	event = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channel_events);
		{
			guint i;
			i = (guint) 0;
			{
				gboolean _tmp4_;
				_tmp4_ = TRUE;
				while (TRUE) {
					GValue* _tmp5_ = NULL;
					const GstStructure* _tmp6_ = NULL;
					DVBEvent* _tmp7_ = NULL;
					DVBEvent* event_class;
					guint _tmp8_;
					guint _tmp9_;
					guint _tmp10_;
					guint _tmp11_;
					guint _tmp12_;
					guint _tmp13_;
					guint _tmp14_;
					guint _tmp15_;
					gboolean _tmp16_;
					guint _tmp17_;
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_;
					gchar* name;
					gboolean _tmp20_ = FALSE;
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_;
					gchar* desc;
					gboolean _tmp26_ = FALSE;
					const gchar* _tmp30_ = NULL;
					gchar* _tmp31_;
					gchar* ext_desc;
					gboolean _tmp32_ = FALSE;
					gboolean free_ca = FALSE;
					gboolean _tmp36_;
					guint _tmp37_;
					guint sid;
					gboolean _tmp38_;
					gpointer _tmp41_ = NULL;
					GeeHashSet* list;
					if (!_tmp4_) {
						i++;
					}
					_tmp4_ = FALSE;
					if (!(i < size)) {
						break;
					}
					_tmp5_ = gst_value_list_get_value (&events, i);
					val = *_tmp5_;
					_tmp6_ = gst_value_get_structure (&val);
					event = _tmp6_;
					_tmp7_ = dvb_event_new ();
					event_class = _tmp7_;
					_tmp8_ = dvb_epg_scanner_get_uint_val (event, "event-id");
					event_class->id = _tmp8_;
					_tmp9_ = dvb_epg_scanner_get_uint_val (event, "year");
					event_class->year = _tmp9_;
					_tmp10_ = dvb_epg_scanner_get_uint_val (event, "month");
					event_class->month = _tmp10_;
					_tmp11_ = dvb_epg_scanner_get_uint_val (event, "day");
					event_class->day = _tmp11_;
					_tmp12_ = dvb_epg_scanner_get_uint_val (event, "hour");
					event_class->hour = _tmp12_;
					_tmp13_ = dvb_epg_scanner_get_uint_val (event, "minute");
					event_class->minute = _tmp13_;
					_tmp14_ = dvb_epg_scanner_get_uint_val (event, "second");
					event_class->second = _tmp14_;
					_tmp15_ = dvb_epg_scanner_get_uint_val (event, "duration");
					event_class->duration = _tmp15_;
					_tmp16_ = dvb_event_has_expired (event_class);
					if (_tmp16_) {
						_dvb_event_unref0 (event_class);
						continue;
					}
					_tmp17_ = dvb_epg_scanner_get_uint_val (event, "running-status");
					event_class->running_status = _tmp17_;
					_tmp18_ = gst_structure_get_string (event, "name");
					_tmp19_ = g_strdup (_tmp18_);
					name = _tmp19_;
					if (name != NULL) {
						gboolean _tmp21_;
						_tmp21_ = g_utf8_validate (name, (gssize) (-1), NULL);
						_tmp20_ = _tmp21_;
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						gchar* _tmp22_;
						gchar* _tmp23_;
						_tmp22_ = g_strdup (name);
						_tmp23_ = _tmp22_;
						_g_free0 (event_class->name);
						event_class->name = _tmp23_;
					}
					_tmp24_ = gst_structure_get_string (event, "description");
					_tmp25_ = g_strdup (_tmp24_);
					desc = _tmp25_;
					if (desc != NULL) {
						gboolean _tmp27_;
						_tmp27_ = g_utf8_validate (desc, (gssize) (-1), NULL);
						_tmp26_ = _tmp27_;
					} else {
						_tmp26_ = FALSE;
					}
					if (_tmp26_) {
						gchar* _tmp28_;
						gchar* _tmp29_;
						_tmp28_ = g_strdup (desc);
						_tmp29_ = _tmp28_;
						_g_free0 (event_class->description);
						event_class->description = _tmp29_;
					}
					_tmp30_ = gst_structure_get_string (event, "extended-text");
					_tmp31_ = g_strdup (_tmp30_);
					ext_desc = _tmp31_;
					if (ext_desc != NULL) {
						gboolean _tmp33_;
						_tmp33_ = g_utf8_validate (ext_desc, (gssize) (-1), NULL);
						_tmp32_ = _tmp33_;
					} else {
						_tmp32_ = FALSE;
					}
					if (_tmp32_) {
						gchar* _tmp34_;
						gchar* _tmp35_;
						_tmp34_ = g_strdup (ext_desc);
						_tmp35_ = _tmp34_;
						_g_free0 (event_class->extended_description);
						event_class->extended_description = _tmp35_;
					}
					gst_structure_get_boolean (event, "free-ca-mode", &_tmp36_);
					free_ca = _tmp36_;
					event_class->free_ca_mode = free_ca;
					_tmp37_ = dvb_epg_scanner_get_uint_val (structure, "service-id");
					sid = _tmp37_;
					_tmp38_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->channel_events, GUINT_TO_POINTER (sid));
					if (!_tmp38_) {
						GeeHashSet* _tmp39_ = NULL;
						GeeHashSet* _tmp40_;
						_tmp39_ = gee_hash_set_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, _dvb_event_hash_ghash_func, _dvb_event_equal_gequal_func);
						_tmp40_ = _tmp39_;
						gee_abstract_map_set ((GeeAbstractMap*) self->priv->channel_events, GUINT_TO_POINTER (sid), _tmp40_);
						_g_object_unref0 (_tmp40_);
					}
					_tmp41_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->channel_events, GUINT_TO_POINTER (sid));
					list = (GeeHashSet*) _tmp41_;
					gee_abstract_collection_add ((GeeAbstractCollection*) list, event_class);
					_g_object_unref0 (list);
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					_dvb_event_unref0 (event_class);
				}
			}
		}
		__finally66:
		g_static_rec_mutex_unlock (&self->priv->__lock_channel_events);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static guint dvb_epg_scanner_get_uint_val (const GstStructure* structure, const gchar* name) {
	guint result = 0U;
	guint val = 0U;
	guint _tmp0_;
	g_return_val_if_fail (structure != NULL, 0U);
	g_return_val_if_fail (name != NULL, 0U);
	gst_structure_get_uint (structure, name, &_tmp0_);
	val = _tmp0_;
	result = val;
	return result;
}


static GObject * dvb_epg_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBEPGScanner * self;
	GQueue* _tmp0_ = NULL;
	GQueue* _tmp1_;
	GMainContext* _tmp2_ = NULL;
	GMainContext* _tmp3_;
	GeeHashMap* _tmp4_ = NULL;
	GeeHashMap* _tmp5_;
	parent_class = G_OBJECT_CLASS (dvb_epg_scanner_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_EPG_SCANNER (obj);
	_tmp0_ = g_queue_new ();
	_tmp1_ = _tmp0_;
	_g_queue_free0 (self->priv->channels);
	self->priv->channels = _tmp1_;
	self->priv->stop_counter = 0;
	_tmp2_ = g_main_context_new ();
	_tmp3_ = _tmp2_;
	_g_main_context_unref0 (self->priv->context);
	self->priv->context = _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->priv->channel_events);
	self->priv->channel_events = _tmp5_;
	return obj;
}


static void dvb_epg_scanner_class_init (DVBEPGScannerClass * klass) {
	dvb_epg_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBEPGScannerPrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_epg_scanner_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_epg_scanner_finalize;
	dvb_epg_scanner_CHECK_EIT_INTERVAL = -1;
}


static void dvb_epg_scanner_instance_init (DVBEPGScanner * self) {
	self->priv = DVB_EPG_SCANNER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_pipeline);
	g_static_rec_mutex_init (&self->priv->__lock_channel_events);
}


static void dvb_epg_scanner_finalize (GObject* obj) {
	DVBEPGScanner * self;
	self = DVB_EPG_SCANNER (obj);
	g_static_rec_mutex_free (&self->priv->__lock_pipeline);
	_gst_object_unref0 (self->priv->pipeline);
	_g_queue_free0 (self->priv->channels);
	_g_source_unref0 (self->priv->scan_source);
	_g_source_unref0 (self->priv->queue_source);
	_g_main_context_unref0 (self->priv->context);
	_g_main_loop_unref0 (self->priv->loop);
	g_static_rec_mutex_free (&self->priv->__lock_channel_events);
	_g_object_unref0 (self->priv->channel_events);
	G_OBJECT_CLASS (dvb_epg_scanner_parent_class)->finalize (obj);
}


GType dvb_epg_scanner_get_type (void) {
	static volatile gsize dvb_epg_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_epg_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEPGScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_epg_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEPGScanner), 0, (GInstanceInitFunc) dvb_epg_scanner_instance_init, NULL };
		GType dvb_epg_scanner_type_id;
		dvb_epg_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBEPGScanner", &g_define_type_info, 0);
		g_once_init_leave (&dvb_epg_scanner_type_id__volatile, dvb_epg_scanner_type_id);
	}
	return dvb_epg_scanner_type_id__volatile;
}



