/* Recording.c generated by valac 0.10.0, the Vala compiler
 * generated from Recording.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <time.h>


#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;
typedef struct _DVBRecordingPrivate DVBRecordingPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_IO_TYPE_RECORDING_WRITER (dvb_io_recording_writer_get_type ())
#define DVB_IO_RECORDING_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriter))
#define DVB_IO_RECORDING_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriterClass))
#define DVB_IO_IS_RECORDING_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_RECORDING_WRITER))
#define DVB_IO_IS_RECORDING_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_RECORDING_WRITER))
#define DVB_IO_RECORDING_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriterClass))

typedef struct _DVBioRecordingWriter DVBioRecordingWriter;
typedef struct _DVBioRecordingWriterClass DVBioRecordingWriterClass;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;

struct _DVBRecording {
	GObject parent_instance;
	DVBRecordingPrivate * priv;
};

struct _DVBRecordingClass {
	GObjectClass parent_class;
};

struct _DVBRecordingPrivate {
	guint32 _Id;
	guint _ChannelSid;
	char* _ChannelName;
	GFile* _Location;
	char* _Name;
	char* _Description;
	struct tm _StartTime;
	gint64 _Length;
	GFileMonitor* _file_monitor;
};


static gpointer dvb_recording_parent_class = NULL;

GType dvb_recording_get_type (void) G_GNUC_CONST;
#define DVB_RECORDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDING, DVBRecordingPrivate))
enum  {
	DVB_RECORDING_DUMMY_PROPERTY,
	DVB_RECORDING_ID,
	DVB_RECORDING_CHANNEL_SID,
	DVB_RECORDING_CHANNEL_NAME,
	DVB_RECORDING_LOCATION,
	DVB_RECORDING_NAME,
	DVB_RECORDING_DESCRIPTION,
	DVB_RECORDING_LENGTH,
	DVB_RECORDING_FILE_MONITOR
};
guint* dvb_recording_get_start (DVBRecording* self, int* result_length1);
void dvb_recording_get_StartTime (DVBRecording* self, struct tm* result);
void dvb_recording_monitor_recording (DVBRecording* self);
GFile* dvb_recording_get_Location (DVBRecording* self);
void dvb_recording_set_file_monitor (DVBRecording* self, GFileMonitor* value);
GFileMonitor* dvb_recording_get_file_monitor (DVBRecording* self);
static void dvb_recording_on_recording_file_changed (DVBRecording* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event);
static void _dvb_recording_on_recording_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
void dvb_recording_save_to_disk (DVBRecording* self);
DVBioRecordingWriter* dvb_io_recording_writer_new (DVBRecording* rec);
DVBioRecordingWriter* dvb_io_recording_writer_construct (GType object_type, DVBRecording* rec);
GType dvb_io_recording_writer_get_type (void) G_GNUC_CONST;
void dvb_io_recording_writer_write (DVBioRecordingWriter* self, GError** error);
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
void dvb_recordings_store_remove (DVBRecordingsStore* self, DVBRecording* rec);
DVBRecording* dvb_recording_new (void);
DVBRecording* dvb_recording_construct (GType object_type);
guint32 dvb_recording_get_Id (DVBRecording* self);
void dvb_recording_set_Id (DVBRecording* self, guint32 value);
guint dvb_recording_get_ChannelSid (DVBRecording* self);
void dvb_recording_set_ChannelSid (DVBRecording* self, guint value);
const char* dvb_recording_get_ChannelName (DVBRecording* self);
void dvb_recording_set_ChannelName (DVBRecording* self, const char* value);
void dvb_recording_set_Location (DVBRecording* self, GFile* value);
const char* dvb_recording_get_Name (DVBRecording* self);
void dvb_recording_set_Name (DVBRecording* self, const char* value);
const char* dvb_recording_get_Description (DVBRecording* self);
void dvb_recording_set_Description (DVBRecording* self, const char* value);
void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value);
gint64 dvb_recording_get_Length (DVBRecording* self);
void dvb_recording_set_Length (DVBRecording* self, gint64 value);
static void dvb_recording_finalize (GObject* obj);
static void dvb_recording_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_recording_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



guint* dvb_recording_get_start (DVBRecording* self, int* result_length1) {
	guint* result = NULL;
	guint* _tmp0_ = NULL;
	guint* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = (_tmp0_ = g_new0 (guint, 5), _tmp0_[0] = (guint) (self->priv->_StartTime.tm_year + 1900), _tmp0_[1] = (guint) (self->priv->_StartTime.tm_mon + 1), _tmp0_[2] = (guint) self->priv->_StartTime.tm_mday, _tmp0_[3] = (guint) self->priv->_StartTime.tm_hour, _tmp0_[4] = (guint) self->priv->_StartTime.tm_min, _tmp0_), *result_length1 = 5, _tmp1_);
	return result;
}


static void _dvb_recording_on_recording_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	dvb_recording_on_recording_file_changed (self, _sender, file, other_file, event_type);
}


void dvb_recording_monitor_recording (DVBRecording* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFileMonitor* _tmp0_;
		GFileMonitor* _tmp1_;
		_tmp0_ = g_file_monitor_file (self->priv->_Location, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch124_g_error;
		}
		dvb_recording_set_file_monitor (self, _tmp1_ = _tmp0_);
		_g_object_unref0 (_tmp1_);
		g_signal_connect_object (self->priv->_file_monitor, "changed", (GCallback) _dvb_recording_on_recording_file_changed_g_file_monitor_changed, self, 0);
	}
	goto __finally124;
	__catch124_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("Recording.vala:54: Could not create FileMonitor: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally124:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void dvb_recording_save_to_disk (DVBRecording* self) {
	DVBioRecordingWriter* writer;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	writer = dvb_io_recording_writer_new (self);
	{
		dvb_io_recording_writer_write (writer, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch125_g_error;
		}
	}
	goto __finally125;
	__catch125_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Recording.vala:63: Could not save recording: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally125:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (writer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (writer);
}


static void dvb_recording_on_recording_file_changed (DVBRecording* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (file != NULL);
	if (event == G_FILE_MONITOR_EVENT_DELETED) {
		char* location;
		location = g_file_get_path (file);
		g_debug ("Recording.vala:71: %s has been deleted", location);
		g_file_monitor_cancel (monitor);
		dvb_recordings_store_remove (dvb_recordings_store_get_instance (), self);
		_g_free0 (location);
	}
}


DVBRecording* dvb_recording_construct (GType object_type) {
	DVBRecording * self;
	self = (DVBRecording*) g_object_new (object_type, NULL);
	return self;
}


DVBRecording* dvb_recording_new (void) {
	return dvb_recording_construct (DVB_TYPE_RECORDING);
}


guint32 dvb_recording_get_Id (DVBRecording* self) {
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_Id;
	return result;
}


void dvb_recording_set_Id (DVBRecording* self, guint32 value) {
	g_return_if_fail (self != NULL);
	self->priv->_Id = value;
	g_object_notify ((GObject *) self, "Id");
}


guint dvb_recording_get_ChannelSid (DVBRecording* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_ChannelSid;
	return result;
}


void dvb_recording_set_ChannelSid (DVBRecording* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_ChannelSid = value;
	g_object_notify ((GObject *) self, "ChannelSid");
}


const char* dvb_recording_get_ChannelName (DVBRecording* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_ChannelName;
	return result;
}


void dvb_recording_set_ChannelName (DVBRecording* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_ChannelName = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_ChannelName), _tmp0_);
	g_object_notify ((GObject *) self, "ChannelName");
}


GFile* dvb_recording_get_Location (DVBRecording* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Location;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_recording_set_Location (DVBRecording* self, GFile* value) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_Location = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_Location), _tmp0_);
	g_object_notify ((GObject *) self, "Location");
}


const char* dvb_recording_get_Name (DVBRecording* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Name;
	return result;
}


void dvb_recording_set_Name (DVBRecording* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_Name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_Name), _tmp0_);
	g_object_notify ((GObject *) self, "Name");
}


const char* dvb_recording_get_Description (DVBRecording* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Description;
	return result;
}


void dvb_recording_set_Description (DVBRecording* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_Description = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_Description), _tmp0_);
	g_object_notify ((GObject *) self, "Description");
}


void dvb_recording_get_StartTime (DVBRecording* self, struct tm* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_StartTime;
	return;
}


void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value) {
	g_return_if_fail (self != NULL);
	self->priv->_StartTime = *value;
}


gint64 dvb_recording_get_Length (DVBRecording* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_Length;
	return result;
}


void dvb_recording_set_Length (DVBRecording* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_Length = value;
	g_object_notify ((GObject *) self, "Length");
}


GFileMonitor* dvb_recording_get_file_monitor (DVBRecording* self) {
	GFileMonitor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_file_monitor;
	return result;
}


void dvb_recording_set_file_monitor (DVBRecording* self, GFileMonitor* value) {
	GFileMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_file_monitor = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_file_monitor), _tmp0_);
	g_object_notify ((GObject *) self, "file-monitor");
}


static void dvb_recording_class_init (DVBRecordingClass * klass) {
	dvb_recording_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecordingPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_recording_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_recording_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_recording_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_ID, g_param_spec_uint ("Id", "Id", "Id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_CHANNEL_SID, g_param_spec_uint ("ChannelSid", "ChannelSid", "ChannelSid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_CHANNEL_NAME, g_param_spec_string ("ChannelName", "ChannelName", "ChannelName", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_LOCATION, g_param_spec_object ("Location", "Location", "Location", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_DESCRIPTION, g_param_spec_string ("Description", "Description", "Description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_LENGTH, g_param_spec_int64 ("Length", "Length", "Length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_FILE_MONITOR, g_param_spec_object ("file-monitor", "file-monitor", "file-monitor", G_TYPE_FILE_MONITOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_recording_instance_init (DVBRecording * self) {
	self->priv = DVB_RECORDING_GET_PRIVATE (self);
}


static void dvb_recording_finalize (GObject* obj) {
	DVBRecording * self;
	self = DVB_RECORDING (obj);
	_g_free0 (self->priv->_ChannelName);
	_g_object_unref0 (self->priv->_Location);
	_g_free0 (self->priv->_Name);
	_g_free0 (self->priv->_Description);
	_g_object_unref0 (self->priv->_file_monitor);
	G_OBJECT_CLASS (dvb_recording_parent_class)->finalize (obj);
}


/**
     * This class represents a finished recording
     */
GType dvb_recording_get_type (void) {
	static volatile gsize dvb_recording_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_recording_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecordingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recording_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecording), 0, (GInstanceInitFunc) dvb_recording_instance_init, NULL };
		GType dvb_recording_type_id;
		dvb_recording_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecording", &g_define_type_info, 0);
		g_once_init_leave (&dvb_recording_type_id__volatile, dvb_recording_type_id);
	}
	return dvb_recording_type_id__volatile;
}


static void dvb_recording_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBRecording * self;
	self = DVB_RECORDING (object);
	switch (property_id) {
		case DVB_RECORDING_ID:
		g_value_set_uint (value, dvb_recording_get_Id (self));
		break;
		case DVB_RECORDING_CHANNEL_SID:
		g_value_set_uint (value, dvb_recording_get_ChannelSid (self));
		break;
		case DVB_RECORDING_CHANNEL_NAME:
		g_value_set_string (value, dvb_recording_get_ChannelName (self));
		break;
		case DVB_RECORDING_LOCATION:
		g_value_set_object (value, dvb_recording_get_Location (self));
		break;
		case DVB_RECORDING_NAME:
		g_value_set_string (value, dvb_recording_get_Name (self));
		break;
		case DVB_RECORDING_DESCRIPTION:
		g_value_set_string (value, dvb_recording_get_Description (self));
		break;
		case DVB_RECORDING_LENGTH:
		g_value_set_int64 (value, dvb_recording_get_Length (self));
		break;
		case DVB_RECORDING_FILE_MONITOR:
		g_value_set_object (value, dvb_recording_get_file_monitor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_recording_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBRecording * self;
	self = DVB_RECORDING (object);
	switch (property_id) {
		case DVB_RECORDING_ID:
		dvb_recording_set_Id (self, g_value_get_uint (value));
		break;
		case DVB_RECORDING_CHANNEL_SID:
		dvb_recording_set_ChannelSid (self, g_value_get_uint (value));
		break;
		case DVB_RECORDING_CHANNEL_NAME:
		dvb_recording_set_ChannelName (self, g_value_get_string (value));
		break;
		case DVB_RECORDING_LOCATION:
		dvb_recording_set_Location (self, g_value_get_object (value));
		break;
		case DVB_RECORDING_NAME:
		dvb_recording_set_Name (self, g_value_get_string (value));
		break;
		case DVB_RECORDING_DESCRIPTION:
		dvb_recording_set_Description (self, g_value_get_string (value));
		break;
		case DVB_RECORDING_LENGTH:
		dvb_recording_set_Length (self, g_value_get_int64 (value));
		break;
		case DVB_RECORDING_FILE_MONITOR:
		dvb_recording_set_file_monitor (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




