/* Main.c generated by valac 0.10.0, the Vala compiler
 * generated from Main.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <gst/gst.h>
#include <gee.h>
#include <signal.h>
#include <stdio.h>


#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_DATABASE_TYPE_CONFIG_STORE (dvb_database_config_store_get_type ())
#define DVB_DATABASE_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStore))
#define DVB_DATABASE_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE))
#define DVB_DATABASE_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStoreIface))

typedef struct _DVBdatabaseConfigStore DVBdatabaseConfigStore;
typedef struct _DVBdatabaseConfigStoreIface DVBdatabaseConfigStoreIface;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_CHANNEL_GROUP (dvb_channel_group_get_type ())
#define DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroup))
#define DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))
#define DVB_IS_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_GROUP))
#define DVB_IS_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_GROUP))
#define DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))

typedef struct _DVBChannelGroup DVBChannelGroup;
typedef struct _DVBChannelGroupClass DVBChannelGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBdatabaseConfigStore* self, GError** error);
	gboolean (*add_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
	gboolean (*remove_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_device_to_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*remove_device_from_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*update_from_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*get_parent_group) (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint* group_id, GError** error);
	gboolean (*add_channel_group) (DVBdatabaseConfigStore* self, const char* name, gint* channel_group_id, GError** error);
	gboolean (*remove_channel_group) (DVBdatabaseConfigStore* self, gint group_id, GError** error);
	GeeList* (*get_channel_groups) (DVBdatabaseConfigStore* self, GError** error);
	GeeList* (*get_channels_of_group) (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
	gboolean (*add_channel_to_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
	gboolean (*remove_channel_from_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
};


extern DVBManager* main_manager;
DVBManager* main_manager = NULL;
extern DVBRecordingsStore* main_recstore;
DVBRecordingsStore* main_recstore = NULL;
extern gboolean main_has_debug;
gboolean main_has_debug = FALSE;
extern gboolean main_has_version;
gboolean main_has_version = FALSE;
extern gboolean main_disable_epg_scanner;
gboolean main_disable_epg_scanner = FALSE;
extern gboolean main_disable_mediaserver;
gboolean main_disable_mediaserver = FALSE;
extern gboolean main_enable_mediaserver2;
gboolean main_enable_mediaserver2 = FALSE;
extern GMainLoop* main_mainloop;
GMainLoop* main_mainloop = NULL;

GType dvb_manager_get_type (void) G_GNUC_CONST;
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
gboolean main_start_manager (void);
#define DVB_CONSTANTS_DBUS_SERVICE "org.gnome.DVB"
static guint _dynamic_RequestName0 (DBusGProxy* self, const char* param1, guint param2, GError** error);
DVBManager* dvb_manager_get_instance (void);
#define DVB_CONSTANTS_DBUS_MANAGER_PATH "/org/gnome/DVB/Manager"
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
gboolean main_start_recordings_store (void);
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
#define DVB_CONSTANTS_DBUS_RECORDINGS_STORE_PATH "/org/gnome/DVB/RecordingsStore"
void main_on_exit (gint signum);
void dvb_rtsp_server_shutdown (void);
void dvb_manager_shutdown (void);
void dvb_factory_shutdown (void);
void dvb_recordings_store_shutdown (void);
void main_log_func (const char* log_domain, GLogLevelFlags log_levels, const char* message);
gboolean main_get_disable_epg_scanner (void);
gboolean main_check_feature_version (const char* name, guint major, guint minor, guint micro);
gboolean main_check_requirements (void);
void main_restore_device_groups (void);
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
GType dvb_device_get_type (void) G_GNUC_CONST;
GType dvb_channel_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_database_config_store_get_type (void) G_GNUC_CONST;
DVBdatabaseConfigStore* dvb_factory_get_config_store (void);
GeeList* dvb_database_config_store_get_all_device_groups (DVBdatabaseConfigStore* self, GError** error);
void dvb_manager_restore_device_group_and_timers (DVBManager* self, DVBDeviceGroup* device_group);
gint main_main (char** args, int args_length1);
static void _main_on_exit_cutils_signal_signal_handler (gint signum);
static void _main_log_func_glog_func (const char* log_domain, GLogLevelFlags log_levels, const char* message, gpointer self);
gboolean dvb_rtsp_server_start (void);
static gboolean _dvb_rtsp_server_start_gsource_func (gpointer self);
gboolean dvb_media_server2_start_rygel_services (void);
static gboolean _dvb_media_server2_start_rygel_services_gsource_func (gpointer self);
gboolean dvb_media_server_start_rygel_services (void);
static gboolean _dvb_media_server_start_rygel_services_gsource_func (gpointer self);

const GOptionEntry MAIN_options[6] = {{"debug", 'd', 0, G_OPTION_ARG_NONE, &main_has_debug, "Display debug statements on stdout", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &main_has_version, "Display version number", NULL}, {"disable-epg-scanner", (gchar) 0, 0, G_OPTION_ARG_NONE, &main_disable_epg_scanner, "Disable scanning for EPG data", NULL}, {"disable-mediaserver", (gchar) 0, 0, G_OPTION_ARG_NONE, &main_disable_mediaserver, "Disable exporting devices and channels for Rygel", NULL}, {"enable-mediaserver2", (gchar) 0, 0, G_OPTION_ARG_NONE, &main_enable_mediaserver2, "Export devices and channels according to Rygel's MediaServer2 specific" \
"ation", NULL}, {NULL}};


static guint _dynamic_RequestName0 (DBusGProxy* self, const char* param1, guint param2, GError** error) {
	guint result;
	dbus_g_proxy_call (self, "RequestName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if (*error) {
		return 0U;
	}
	return result;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


gboolean main_start_manager (void) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		DBusGConnection* conn;
		DBusGProxy* bus;
		guint request_name_result;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch71_g_error;
		}
		bus = dbus_g_proxy_new_for_name (conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
		request_name_result = _dynamic_RequestName0 (bus, DVB_CONSTANTS_DBUS_SERVICE, (guint) 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (bus);
			_dbus_g_connection_unref0 (conn);
			goto __catch71_g_error;
		}
		if (request_name_result == DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER) {
			g_message ("Main.vala:59: Creating new Manager D-Bus service");
			main_manager = dvb_manager_get_instance ();
			_vala_dbus_register_object (dbus_g_connection_get_connection (conn), DVB_CONSTANTS_DBUS_MANAGER_PATH, (GObject*) main_manager);
		} else {
			g_warning ("Main.vala:67: Manager D-Bus service is already running");
			result = FALSE;
			_g_object_unref0 (bus);
			_dbus_g_connection_unref0 (conn);
			return result;
		}
		_g_object_unref0 (bus);
		_dbus_g_connection_unref0 (conn);
	}
	goto __finally71;
	__catch71_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Main.vala:72: Oops %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally71:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean main_start_recordings_store (void) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_message ("Main.vala:80: Creating new RecordingsStore D-Bus service");
	{
		DBusGConnection* conn;
		DVBRecordingsStore* _tmp0_;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch72_g_error;
		}
		main_recstore = (_tmp0_ = _g_object_ref0 (dvb_recordings_store_get_instance ()), _g_object_unref0 (main_recstore), _tmp0_);
		_vala_dbus_register_object (dbus_g_connection_get_connection (conn), DVB_CONSTANTS_DBUS_RECORDINGS_STORE_PATH, (GObject*) main_recstore);
		_dbus_g_connection_unref0 (conn);
	}
	goto __finally72;
	__catch72_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Main.vala:91: Oops %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally72:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


void main_on_exit (gint signum) {
	DVBRecordingsStore* _tmp0_;
	g_message ("Main.vala:99: Exiting");
	dvb_rtsp_server_shutdown ();
	dvb_manager_shutdown ();
	dvb_factory_shutdown ();
	dvb_recordings_store_shutdown ();
	main_recstore = (_tmp0_ = NULL, _g_object_unref0 (main_recstore), _tmp0_);
	main_manager = NULL;
	g_main_loop_quit (main_mainloop);
}


void main_log_func (const char* log_domain, GLogLevelFlags log_levels, const char* message) {
	g_return_if_fail (message != NULL);
	if (main_has_debug) {
		g_log_default_handler (log_domain, log_levels, message, NULL);
	}
}


gboolean main_get_disable_epg_scanner (void) {
	gboolean result = FALSE;
	result = main_disable_epg_scanner;
	return result;
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


static char* bool_to_string (gboolean self) {
	char* result = NULL;
	if (self) {
		result = g_strdup ("true");
		return result;
	} else {
		result = g_strdup ("false");
		return result;
	}
}


gboolean main_check_feature_version (const char* name, guint major, guint minor, guint micro) {
	gboolean result = FALSE;
	GstRegistry* reg;
	GstPluginFeature* feature;
	gboolean ret = FALSE;
	char* _tmp0_;
	g_return_val_if_fail (name != NULL, FALSE);
	reg = _gst_object_ref0 (gst_registry_get_default ());
	feature = gst_registry_lookup_feature (reg, name);
	if (feature == NULL) {
		ret = FALSE;
	} else {
		ret = gst_plugin_feature_check_version (feature, major, minor, micro);
	}
	g_debug ("Main.vala:131: Has %s >= %u.%u.%u: %s", name, major, minor, micro, _tmp0_ = bool_to_string (ret));
	_g_free0 (_tmp0_);
	result = ret;
	_gst_object_unref0 (feature);
	_gst_object_unref0 (reg);
	return result;
}


gboolean main_check_requirements (void) {
	gboolean result = FALSE;
	gboolean val = FALSE;
	val = main_check_feature_version ("dvbsrc", (guint) 0, (guint) 10, (guint) 13);
	if (!val) {
		result = FALSE;
		return result;
	}
	val = main_check_feature_version ("dvbbasebin", (guint) 0, (guint) 10, (guint) 13);
	if (!val) {
		result = FALSE;
		return result;
	}
	val = main_check_feature_version ("mpegtsparse", (guint) 0, (guint) 10, (guint) 13);
	if (!val) {
		result = FALSE;
		return result;
	}
	val = main_check_feature_version ("rtpmp2tpay", (guint) 0, (guint) 10, (guint) 14);
	result = val;
	return result;
}


void main_restore_device_groups (void) {
	DVBdatabaseConfigStore* config_store;
	GeeList* device_groups;
	GError * _inner_error_ = NULL;
	config_store = dvb_factory_get_config_store ();
	device_groups = NULL;
	{
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		_tmp0_ = dvb_database_config_store_get_all_device_groups (config_store, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch73_dvb_database_sql_error;
			}
			_g_object_unref0 (device_groups);
			_g_object_unref0 (config_store);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		device_groups = (_tmp1_ = _tmp0_, _g_object_unref0 (device_groups), _tmp1_);
	}
	goto __finally73;
	__catch73_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Main.vala:157: %s", e->message);
			_g_error_free0 (e);
			_g_object_unref0 (device_groups);
			_g_object_unref0 (config_store);
			return;
		}
	}
	__finally73:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (device_groups);
		_g_object_unref0 (config_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_message ("Main.vala:161: Restoring %d device groups", gee_collection_get_size ((GeeCollection*) device_groups));
	{
		GeeIterator* _device_group_it;
		_device_group_it = gee_iterable_iterator ((GeeIterable*) device_groups);
		while (TRUE) {
			DVBDeviceGroup* device_group;
			if (!gee_iterator_next (_device_group_it)) {
				break;
			}
			device_group = (DVBDeviceGroup*) gee_iterator_get (_device_group_it);
			dvb_manager_restore_device_group_and_timers (main_manager, device_group);
			_g_object_unref0 (device_group);
		}
		_g_object_unref0 (_device_group_it);
	}
	_g_object_unref0 (device_groups);
	_g_object_unref0 (config_store);
}


static void _main_on_exit_cutils_signal_signal_handler (gint signum) {
	main_on_exit (signum);
}


static void _main_log_func_glog_func (const char* log_domain, GLogLevelFlags log_levels, const char* message, gpointer self) {
	main_log_func (log_domain, log_levels, message);
}


static gboolean _dvb_rtsp_server_start_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_rtsp_server_start ();
	return result;
}


static gboolean _dvb_media_server2_start_rygel_services_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_media_server2_start_rygel_services ();
	return result;
}


static gboolean _dvb_media_server_start_rygel_services_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_media_server_start_rygel_services ();
	return result;
}


gint main_main (char** args, int args_length1) {
	gint result = 0;
	GOptionContext* context;
	GMainLoop* _tmp0_;
	GError * _inner_error_ = NULL;
	g_setenv ("TZ", "/etc/localtime", FALSE);
	signal (SIGINT, _main_on_exit_cutils_signal_signal_handler);
	signal (SIGTERM, _main_on_exit_cutils_signal_signal_handler);
	context = g_option_context_new ("- record and watch TV shows using one or more DVB adapters");
	g_option_context_add_main_entries (context, MAIN_options, NULL);
	g_option_context_add_group (context, gst_init_get_option_group ());
	{
		g_option_context_parse (context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch74_g_option_error;
			}
			_g_option_context_free0 (context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally74;
	__catch74_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "%s\n", e->message);
			fprintf (stderr, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
			result = 1;
			_g_error_free0 (e);
			_g_option_context_free0 (context);
			return result;
		}
	}
	__finally74:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (main_has_version) {
		fprintf (stdout, "%s", PACKAGE_NAME);
		fprintf (stdout, " %s\n", PACKAGE_VERSION);
		result = 0;
		_g_option_context_free0 (context);
		return result;
	}
	g_log_set_handler (NULL, (G_LOG_LEVEL_DEBUG | G_LOG_FLAG_FATAL) | G_LOG_FLAG_RECURSION, _main_log_func_glog_func, NULL);
	main_mainloop = (_tmp0_ = g_main_loop_new (NULL, FALSE), _g_main_loop_unref0 (main_mainloop), _tmp0_);
	gst_init (&args_length1, &args);
	if (!main_check_requirements ()) {
		fprintf (stderr, "You don't have all of the necessary requirements to run %s.\n", PACKAGE_NAME);
		fprintf (stderr, "Start the daemon with the --debug flag for more details.\n");
		result = -1;
		_g_option_context_free0 (context);
		return result;
	}
	if (!main_start_manager ()) {
		result = -1;
		_g_option_context_free0 (context);
		return result;
	}
	if (!main_start_recordings_store ()) {
		result = -1;
		_g_option_context_free0 (context);
		return result;
	}
	main_restore_device_groups ();
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _dvb_rtsp_server_start_gsource_func, NULL, NULL);
	if (!main_disable_mediaserver) {
		if (main_enable_mediaserver2) {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _dvb_media_server2_start_rygel_services_gsource_func, NULL, NULL);
		} else {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _dvb_media_server_start_rygel_services_gsource_func, NULL, NULL);
		}
	}
	g_main_loop_run (main_mainloop);
	result = 0;
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return main_main (argv, argc);
}




