/* Utils.c generated by valac, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <time.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>

#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))



#define DVB_UTILS_BUFFER_SIZE 4096
const char* dvb_utils_get_nick_from_enum (GType enumtype, gint val);
gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const char* name, gint* evalue);
const char* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val);
static void _g_slist_free_g_object_unref (GSList* self);
void dvb_utils_mkdirs (GFile* directory, GError** error);
char* dvb_utils_remove_nonalphanums (const char* text);
time_t dvb_utils_difftime (struct tm* t1, struct tm* t2);
void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
void dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
char* dvb_utils_read_file_contents (GFile* file, GError** error);
void dvb_utils_delete_dir_recursively (GFile* dir, GError** error);
DBusGConnection* dvb_utils_get_dbus_connection (void);



inline const char* dvb_utils_get_nick_from_enum (GType enumtype, gint val) {
	const char* result;
	GEnumClass* eclass;
	GEnumValue* eval;
	eclass = (GEnumClass*) g_type_class_ref (enumtype);
	eval = g_enum_get_value (eclass, val);
	if (eval == NULL) {
		g_critical ("Utils.vala:31: Enum has no value %d", val);
		result = NULL;
		_g_type_class_unref0 (eclass);
		return result;
	} else {
		result = eval->value_nick;
		_g_type_class_unref0 (eclass);
		return result;
	}
	_g_type_class_unref0 (eclass);
}


inline gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const char* name, gint* evalue) {
	gboolean result;
	GEnumClass* enumclass;
	GEnumValue* eval;
	g_return_val_if_fail (name != NULL, FALSE);
	enumclass = (GEnumClass*) g_type_class_ref (enumtype);
	eval = g_enum_get_value_by_name (enumclass, name);
	if (eval == NULL) {
		g_critical ("Utils.vala:43: Enum has no member named %s", name);
		result = FALSE;
		_g_type_class_unref0 (enumclass);
		return result;
	} else {
		*evalue = eval->value;
		result = TRUE;
		_g_type_class_unref0 (enumclass);
		return result;
	}
	_g_type_class_unref0 (enumclass);
}


inline const char* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val) {
	const char* result;
	GEnumClass* enumclass;
	GEnumValue* eval;
	enumclass = (GEnumClass*) g_type_class_ref (enumtype);
	eval = g_enum_get_value (enumclass, val);
	if (eval == NULL) {
		g_critical ("Utils.vala:56: Enum has no value %d", val);
		result = NULL;
		_g_type_class_unref0 (enumclass);
		return result;
	} else {
		result = eval->value_name;
		_g_type_class_unref0 (enumclass);
		return result;
	}
	_g_type_class_unref0 (enumclass);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


void dvb_utils_mkdirs (GFile* directory, GError** error) {
	GError * _inner_error_;
	GSList* create_dirs;
	GFile* current_dir;
	g_return_if_fail (directory != NULL);
	_inner_error_ = NULL;
	create_dirs = NULL;
	current_dir = _g_object_ref0 (directory);
	while (TRUE) {
		GFile* _tmp0_;
		if (!(current_dir != NULL)) {
			break;
		}
		if (g_file_query_exists (current_dir, NULL)) {
			break;
		}
		create_dirs = g_slist_prepend (create_dirs, _g_object_ref0 (current_dir));
		current_dir = (_tmp0_ = g_file_get_parent (current_dir), _g_object_unref0 (current_dir), _tmp0_);
	}
	{
		GSList* dir_collection;
		GSList* dir_it;
		dir_collection = create_dirs;
		for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
			GFile* dir;
			dir = _g_object_ref0 ((GFile*) dir_it->data);
			{
				char* _tmp1_;
				g_debug ("Utils.vala:74: Creating %s", _tmp1_ = g_file_get_path (dir));
				_g_free0 (_tmp1_);
				g_file_make_directory (dir, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (dir);
					__g_slist_free_g_object_unref0 (create_dirs);
					_g_object_unref0 (current_dir);
					return;
				}
				_g_object_unref0 (dir);
			}
		}
	}
	__g_slist_free_g_object_unref0 (create_dirs);
	_g_object_unref0 (current_dir);
}


char* dvb_utils_remove_nonalphanums (const char* text) {
	char* result;
	GError * _inner_error_;
	GRegex* regex;
	char* new_text;
	g_return_val_if_fail (text != NULL, NULL);
	_inner_error_ = NULL;
	regex = NULL;
	{
		GRegex* _tmp0_;
		GRegex* _tmp1_;
		_tmp0_ = g_regex_new ("\\W", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch63_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		regex = (_tmp1_ = _tmp0_, _g_regex_unref0 (regex), _tmp1_);
	}
	goto __finally63;
	__catch63_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("Utils.vala:84: RegexError: %s", e->message);
			result = g_strdup (text);
			_g_error_free0 (e);
			_g_regex_unref0 (regex);
			return result;
		}
	}
	__finally63:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	new_text = NULL;
	{
		char* _tmp2_;
		char* _tmp3_;
		_tmp2_ = g_regex_replace_literal (regex, text, (gssize) (-1), 0, "_", 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch64_g_regex_error;
			}
			_g_regex_unref0 (regex);
			_g_free0 (new_text);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		new_text = (_tmp3_ = _tmp2_, _g_free0 (new_text), _tmp3_);
	}
	goto __finally64;
	__catch64_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("Utils.vala:92: RegexError: %s", e->message);
			result = g_strdup (text);
			_g_error_free0 (e);
			_g_regex_unref0 (regex);
			_g_free0 (new_text);
			return result;
		}
	}
	__finally64:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		_g_free0 (new_text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = new_text;
	_g_regex_unref0 (regex);
	return result;
}


inline time_t dvb_utils_difftime (struct tm* t1, struct tm* t2) {
	time_t result;
	time_t ts1;
	time_t ts2;
	time_t diff;
	ts1 = mktime (t1);
	ts2 = mktime (t2);
	diff = ts1 - ts2;
	if (diff < 0) {
		result = (-1) * diff;
		return result;
	} else {
		result = diff;
		return result;
	}
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	localtime_r (&time, &_result_);
	*result = _result_;
	return;
}


inline void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result) {
	struct tm _tmp0_ = {0};
	struct tm t;
	g_assert ((((((year >= 1900) && (month >= 1)) && (day >= 1)) && (hour >= 0)) && (minute >= 0)) && (second >= 0));
	t = (g_time_local (time (NULL), &_tmp0_), _tmp0_);
	t.tm_year = year - 1900;
	t.tm_mon = month - 1;
	t.tm_mday = day;
	t.tm_hour = hour;
	t.tm_min = minute;
	t.tm_sec = second;
	*result = t;
	return;
}


static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	gmtime_r (&time, &_result_);
	*result = _result_;
	return;
}


inline void dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result) {
	struct tm _tmp0_ = {0};
	struct tm t;
	g_assert ((((((year >= 1900) && (month >= 1)) && (day >= 1)) && (hour >= 0)) && (minute >= 0)) && (second >= 0));
	t = (g_time_gm (time (NULL), &_tmp0_), _tmp0_);
	t.tm_year = year - 1900;
	t.tm_mon = month - 1;
	t.tm_mday = day;
	t.tm_hour = hour;
	t.tm_min = minute;
	t.tm_sec = second;
	t.tm_isdst = -1;
	*result = t;
	return;
}


char* dvb_utils_read_file_contents (GFile* file, GError** error) {
	char* result;
	GError * _inner_error_;
	char* attrs;
	GFileInfo* info;
	GFileInputStream* stream;
	GString* sb;
	gchar* _tmp6_;
	gint buffer_size;
	gint buffer_length1;
	gchar* buffer;
	glong bytes_read = 0L;
	g_return_val_if_fail (file != NULL, NULL);
	_inner_error_ = NULL;
	attrs = g_strdup_printf ("%s,%s", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	info = NULL;
	{
		GFileInfo* _tmp0_;
		GFileInfo* _tmp1_;
		_tmp0_ = g_file_query_info (file, attrs, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch65_g_error;
		}
		info = (_tmp1_ = _tmp0_, _g_object_unref0 (info), _tmp1_);
	}
	goto __finally65;
	__catch65_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Utils.vala:166: Could not retrieve attributes: %s", e->message);
			result = NULL;
			_g_error_free0 (e);
			_g_free0 (attrs);
			_g_object_unref0 (info);
			return result;
		}
	}
	__finally65:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attrs);
		_g_object_unref0 (info);
		return NULL;
	}
	if (g_file_info_get_file_type (info) != G_FILE_TYPE_REGULAR) {
		char* _tmp2_;
		g_critical ("Utils.vala:171: %s is not a regular file", _tmp2_ = g_file_get_path (file));
		_g_free0 (_tmp2_);
		result = NULL;
		_g_free0 (attrs);
		_g_object_unref0 (info);
		return result;
	}
	if (!g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
		char* _tmp3_;
		g_critical ("Utils.vala:176: Cannot read %s", _tmp3_ = g_file_get_path (file));
		_g_free0 (_tmp3_);
		result = NULL;
		_g_free0 (attrs);
		_g_object_unref0 (info);
		return result;
	}
	stream = NULL;
	{
		GFileInputStream* _tmp4_;
		GFileInputStream* _tmp5_;
		_tmp4_ = g_file_read (file, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch66_g_error;
		}
		stream = (_tmp5_ = _tmp4_, _g_object_unref0 (stream), _tmp5_);
	}
	goto __finally66;
	__catch66_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Utils.vala:184: Could not read file: %s", e->message);
			result = NULL;
			_g_error_free0 (e);
			_g_free0 (attrs);
			_g_object_unref0 (info);
			_g_object_unref0 (stream);
			return result;
		}
	}
	__finally66:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attrs);
		_g_object_unref0 (info);
		_g_object_unref0 (stream);
		return NULL;
	}
	sb = g_string_new ("");
	buffer = (_tmp6_ = g_new0 (gchar, DVB_UTILS_BUFFER_SIZE), buffer_length1 = DVB_UTILS_BUFFER_SIZE, buffer_size = buffer_length1, _tmp6_);
	while (TRUE) {
		gssize _tmp7_;
		_tmp7_ = g_input_stream_read ((GInputStream*) stream, buffer, (gsize) DVB_UTILS_BUFFER_SIZE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (attrs);
			_g_object_unref0 (info);
			_g_object_unref0 (stream);
			_g_string_free0 (sb);
			buffer = (g_free (buffer), NULL);
			return NULL;
		}
		if (!((bytes_read = (glong) _tmp7_) > 0)) {
			break;
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					if (!_tmp8_) {
						i++;
					}
					_tmp8_ = FALSE;
					if (!(i < bytes_read)) {
						break;
					}
					g_string_append_c (sb, buffer[i]);
				}
			}
		}
	}
	g_input_stream_close ((GInputStream*) stream, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attrs);
		_g_object_unref0 (info);
		_g_object_unref0 (stream);
		_g_string_free0 (sb);
		buffer = (g_free (buffer), NULL);
		return NULL;
	}
	result = g_strdup (sb->str);
	_g_free0 (attrs);
	_g_object_unref0 (info);
	_g_object_unref0 (stream);
	_g_string_free0 (sb);
	buffer = (g_free (buffer), NULL);
	return result;
}


void dvb_utils_delete_dir_recursively (GFile* dir, GError** error) {
	GError * _inner_error_;
	char* attrs;
	GFileEnumerator* files;
	GFileEnumerator* _tmp0_;
	GFileEnumerator* _tmp1_;
	GFileInfo* childinfo;
	char* _tmp5_;
	g_return_if_fail (dir != NULL);
	_inner_error_ = NULL;
	attrs = g_strdup_printf ("%s,%s", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_NAME);
	files = NULL;
	_tmp0_ = g_file_enumerate_children (dir, attrs, 0, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attrs);
		_g_object_unref0 (files);
		return;
	}
	files = (_tmp1_ = _tmp0_, _g_object_unref0 (files), _tmp1_);
	if (files == NULL) {
		_g_free0 (attrs);
		_g_object_unref0 (files);
		return;
	}
	childinfo = NULL;
	while (TRUE) {
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		guint32 type;
		GFile* child;
		_tmp2_ = g_file_enumerator_next_file (files, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (attrs);
			_g_object_unref0 (files);
			_g_object_unref0 (childinfo);
			return;
		}
		if (!((childinfo = (_tmp3_ = _tmp2_, _g_object_unref0 (childinfo), _tmp3_)) != NULL)) {
			break;
		}
		type = g_file_info_get_attribute_uint32 (childinfo, G_FILE_ATTRIBUTE_STANDARD_TYPE);
		child = g_file_get_child (dir, g_file_info_get_name (childinfo));
		switch (type) {
			case G_FILE_TYPE_DIRECTORY:
			{
				dvb_utils_delete_dir_recursively (child, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (child);
					_g_free0 (attrs);
					_g_object_unref0 (files);
					_g_object_unref0 (childinfo);
					return;
				}
				break;
			}
			case G_FILE_TYPE_REGULAR:
			{
				char* _tmp4_;
				g_debug ("Utils.vala:223: Deleting file %s", _tmp4_ = g_file_get_path (child));
				_g_free0 (_tmp4_);
				g_file_delete (child, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (child);
					_g_free0 (attrs);
					_g_object_unref0 (files);
					_g_object_unref0 (childinfo);
					return;
				}
				break;
			}
		}
		_g_object_unref0 (child);
	}
	g_debug ("Utils.vala:229: Deleting directory %s", _tmp5_ = g_file_get_path (dir));
	_g_free0 (_tmp5_);
	g_file_delete (dir, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attrs);
		_g_object_unref0 (files);
		_g_object_unref0 (childinfo);
		return;
	}
	_g_free0 (attrs);
	_g_object_unref0 (files);
	_g_object_unref0 (childinfo);
}


inline DBusGConnection* dvb_utils_get_dbus_connection (void) {
	DBusGConnection* result;
	GError * _inner_error_;
	DBusGConnection* conn;
	_inner_error_ = NULL;
	conn = NULL;
	{
		DBusGConnection* _tmp0_;
		DBusGConnection* _tmp1_;
		_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch67_g_error;
		}
		conn = (_tmp1_ = _tmp0_, _dbus_g_connection_unref0 (conn), _tmp1_);
	}
	goto __finally67;
	__catch67_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("Utils.vala:238: Could not get D-Bus session bus: %s", e->message);
			result = NULL;
			_g_error_free0 (e);
			_dbus_g_connection_unref0 (conn);
			return result;
		}
	}
	__finally67:
	if (_inner_error_ != NULL) {
		_dbus_g_connection_unref0 (conn);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = conn;
	return result;
}




