/* RecordingsStore.c generated by valac, the Vala compiler
 * generated from RecordingsStore.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <time.h>
#include <dbus/dbus.h>


#define DVB_TYPE_ID_BUS_RECORDINGS_STORE (dvb_id_bus_recordings_store_get_type ())
#define DVB_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStore))
#define DVB_IS_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE))
#define DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStoreIface))

typedef struct _DVBIDBusRecordingsStore DVBIDBusRecordingsStore;
typedef struct _DVBIDBusRecordingsStoreIface DVBIDBusRecordingsStoreIface;

#define DVB_TYPE_RECORDING_INFO (dvb_recording_info_get_type ())
typedef struct _DVBRecordingInfo DVBRecordingInfo;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;
typedef struct _DVBRecordingsStorePrivate DVBRecordingsStorePrivate;

#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_CHANGE_TYPE (dvb_change_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DVBRecordingInfo {
	guint32 id;
	char* name;
	char* description;
	gint64 length;
	gint64 start_timestamp;
	char* channel;
	char* location;
};

struct _DVBIDBusRecordingsStoreIface {
	GTypeInterface parent_iface;
	guint32* (*GetRecordings) (DVBIDBusRecordingsStore* self, int* result_length1, GError** error);
	gboolean (*GetLocation) (DVBIDBusRecordingsStore* self, guint32 rec_id, char** location, GError** error);
	gboolean (*GetName) (DVBIDBusRecordingsStore* self, guint32 rec_id, char** name, GError** error);
	gboolean (*GetDescription) (DVBIDBusRecordingsStore* self, guint32 rec_id, char** description, GError** error);
	gboolean (*GetStartTime) (DVBIDBusRecordingsStore* self, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error);
	gboolean (*GetStartTimestamp) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* timestamp, GError** error);
	gboolean (*GetLength) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* length, GError** error);
	gboolean (*Delete) (DVBIDBusRecordingsStore* self, guint32 rec_id, GError** error);
	gboolean (*GetChannelName) (DVBIDBusRecordingsStore* self, guint32 rec_id, char** name, GError** error);
	gboolean (*GetAllInformations) (DVBIDBusRecordingsStore* self, guint32 rec_id, DVBRecordingInfo* infos, GError** error);
};

struct _DVBRecordingsStore {
	GObject parent_instance;
	DVBRecordingsStorePrivate * priv;
};

struct _DVBRecordingsStoreClass {
	GObjectClass parent_class;
};

struct _DVBRecordingsStorePrivate {
	GeeHashMap* recordings;
	GStaticRecMutex __lock_recordings;
	guint32 last_id;
	GStaticRecMutex __lock_last_id;
};

typedef enum  {
	DVB_CHANGE_TYPE_ADDED = 0,
	DVB_CHANGE_TYPE_DELETED = 1,
	DVB_CHANGE_TYPE_UPDATED = 2
} DVBChangeType;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static DVBRecordingsStore* dvb_recordings_store_instance;
static DVBRecordingsStore* dvb_recordings_store_instance = NULL;
static GStaticRecMutex dvb_recordings_store_instance_mutex;
static GStaticRecMutex dvb_recordings_store_instance_mutex = {0};
static gpointer dvb_recordings_store_parent_class = NULL;
static DVBIDBusRecordingsStoreIface* dvb_recordings_store_dvb_id_bus_recordings_store_parent_iface = NULL;

GType dvb_recording_info_get_type (void);
DVBRecordingInfo* dvb_recording_info_dup (const DVBRecordingInfo* self);
void dvb_recording_info_free (DVBRecordingInfo* self);
void dvb_recording_info_copy (const DVBRecordingInfo* self, DVBRecordingInfo* dest);
void dvb_recording_info_destroy (DVBRecordingInfo* self);
GType dvb_id_bus_recordings_store_get_type (void);
GType dvb_recordings_store_get_type (void);
GType dvb_recording_get_type (void);
#define DVB_RECORDINGS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStorePrivate))
enum  {
	DVB_RECORDINGS_STORE_DUMMY_PROPERTY
};
DVBRecordingsStore* dvb_recordings_store_new (void);
DVBRecordingsStore* dvb_recordings_store_construct (GType object_type);
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
void dvb_recordings_store_shutdown (void);
void dvb_recordings_store_update_last_id (DVBRecordingsStore* self, guint32 new_last_id);
guint32 dvb_recording_get_Id (DVBRecording* self);
void dvb_recordings_store_monitor_recording (DVBRecordingsStore* self, DVBRecording* rec);
GType dvb_change_type_get_type (void);
gboolean dvb_recordings_store_add (DVBRecordingsStore* self, DVBRecording* rec, gboolean monitor);
GFile* dvb_recording_get_Location (DVBRecording* self);
static void dvb_recordings_store_on_recording_file_changed (DVBRecordingsStore* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event);
static void _dvb_recordings_store_on_recording_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
void dvb_recording_set_file_monitor (DVBRecording* self, GFileMonitor* value);
guint32 dvb_recordings_store_get_next_id (DVBRecordingsStore* self);
static guint32* dvb_recordings_store_real_GetRecordings (DVBIDBusRecordingsStore* base, int* result_length1, GError** error);
static gboolean dvb_recordings_store_real_GetLocation (DVBIDBusRecordingsStore* base, guint32 rec_id, char** location, GError** error);
const char* dvb_recording_get_Name (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetName (DVBIDBusRecordingsStore* base, guint32 rec_id, char** name, GError** error);
const char* dvb_recording_get_Description (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetDescription (DVBIDBusRecordingsStore* base, guint32 rec_id, char** description, GError** error);
guint* dvb_recording_get_start (DVBRecording* self, int* result_length1);
static gboolean dvb_recordings_store_real_GetStartTime (DVBIDBusRecordingsStore* base, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error);
void dvb_recording_get_StartTime (DVBRecording* self, struct tm* result);
static gboolean dvb_recordings_store_real_GetStartTimestamp (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* timestamp, GError** error);
gint64 dvb_recording_get_Length (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetLength (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* length, GError** error);
void dvb_utils_delete_dir_recursively (GFile* dir, GError** error);
static gboolean dvb_recordings_store_real_Delete (DVBIDBusRecordingsStore* base, guint32 rec_id, GError** error);
const char* dvb_recording_get_ChannelName (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetChannelName (DVBIDBusRecordingsStore* base, guint32 rec_id, char** name, GError** error);
static gboolean dvb_recordings_store_real_GetAllInformations (DVBIDBusRecordingsStore* base, guint32 rec_id, DVBRecordingInfo* info, GError** error);
void dvb_recordings_store_restore_from_dir (DVBRecordingsStore* self, GFile* recordingsbasedir);
DVBRecording* dvb_recording_deserialize (GFile* file, GError** error);
static gboolean dvb_recordings_store_delete_recording_by_location (DVBRecordingsStore* self, const char* location);
static GObject * dvb_recordings_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void dvb_recordings_store_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_recordings_store_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_recordings_store_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_recordings_store_introspect (DVBRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static void dvb_recordings_store_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_recordings_store_dbus_path_vtable = {_dvb_recordings_store_dbus_unregister, dvb_recordings_store_dbus_message};
static const _DBusObjectVTable _dvb_recordings_store_dbus_vtable = {dvb_recordings_store_dbus_register_object};


DVBRecordingsStore* dvb_recordings_store_get_instance (void) {
	DVBRecordingsStore* result;
	g_static_rec_mutex_lock (&dvb_recordings_store_instance_mutex);
	if (dvb_recordings_store_instance == NULL) {
		DVBRecordingsStore* _tmp0_;
		dvb_recordings_store_instance = (_tmp0_ = dvb_recordings_store_new (), _g_object_unref0 (dvb_recordings_store_instance), _tmp0_);
	}
	g_static_rec_mutex_unlock (&dvb_recordings_store_instance_mutex);
	result = dvb_recordings_store_instance;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_recordings_store_shutdown (void) {
	DVBRecordingsStore* rs;
	g_static_rec_mutex_lock (&dvb_recordings_store_instance_mutex);
	rs = _g_object_ref0 (dvb_recordings_store_instance);
	if (rs != NULL) {
		DVBRecordingsStore* _tmp0_;
		gee_abstract_map_clear ((GeeAbstractMap*) rs->priv->recordings);
		dvb_recordings_store_instance = (_tmp0_ = NULL, _g_object_unref0 (dvb_recordings_store_instance), _tmp0_);
	}
	g_static_rec_mutex_unlock (&dvb_recordings_store_instance_mutex);
	_g_object_unref0 (rs);
}


void dvb_recordings_store_update_last_id (DVBRecordingsStore* self, guint32 new_last_id) {
	g_return_if_fail (self != NULL);
	g_static_rec_mutex_lock (&self->priv->__lock_last_id);
	{
		if (new_last_id > self->priv->last_id) {
			self->priv->last_id = new_last_id;
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_last_id);
}


gboolean dvb_recordings_store_add (DVBRecordingsStore* self, DVBRecording* rec, gboolean monitor) {
	gboolean result;
	guint32 id;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (rec != NULL, FALSE);
	id = dvb_recording_get_Id (rec);
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains ((GeeMap*) self->priv->recordings, GUINT_TO_POINTER (id))) {
			g_critical ("RecordingsStore.vala:70: Recording with id %u already available", (guint) id);
			result = FALSE;
			return result;
		}
		if (monitor) {
			dvb_recordings_store_monitor_recording (self, rec);
		}
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (id), rec);
		g_signal_emit_by_name ((DVBIDBusRecordingsStore*) self, "changed", id, (guint) DVB_CHANGE_TYPE_ADDED);
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	result = TRUE;
	return result;
}


static void _dvb_recordings_store_on_recording_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	dvb_recordings_store_on_recording_file_changed (self, _sender, file, other_file, event_type);
}


void dvb_recordings_store_monitor_recording (DVBRecordingsStore* self, DVBRecording* rec) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rec != NULL);
	_inner_error_ = NULL;
	{
		GFileMonitor* monitor;
		monitor = g_file_monitor_file (dvb_recording_get_Location (rec), 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch40_g_error;
		}
		g_signal_connect_object (monitor, "changed", (GCallback) _dvb_recordings_store_on_recording_file_changed_g_file_monitor_changed, self, 0);
		dvb_recording_set_file_monitor (rec, monitor);
		_g_object_unref0 (monitor);
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("RecordingsStore.vala:91: Could not create FileMonitor: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally40:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


guint32 dvb_recordings_store_get_next_id (DVBRecordingsStore* self) {
	guint32 result;
	guint32 val = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	g_static_rec_mutex_lock (&self->priv->__lock_last_id);
	{
		val = self->priv->last_id = self->priv->last_id + 1;
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_last_id);
	result = val;
	return result;
}


static guint32* dvb_recordings_store_real_GetRecordings (DVBIDBusRecordingsStore* base, int* result_length1, GError** error) {
	DVBRecordingsStore * self;
	guint32* result;
	gint ids_size;
	gint ids_length1;
	guint32* ids;
	guint32* _tmp4_;
	self = (DVBRecordingsStore*) base;
	ids = (ids_length1 = 0, NULL);
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		guint32* _tmp1_;
		gint _tmp0_;
		gint i;
		ids = (_tmp1_ = g_new0 (guint32, _tmp0_ = gee_map_get_size ((GeeMap*) self->priv->recordings)), ids = (g_free (ids), NULL), ids_length1 = _tmp0_, ids_size = ids_length1, _tmp1_);
		i = 0;
		{
			GeeSet* _tmp2_;
			GeeIterator* _tmp3_;
			GeeIterator* _key_it;
			_key_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = gee_map_get_keys ((GeeMap*) self->priv->recordings))), _g_object_unref0 (_tmp2_), _tmp3_);
			while (TRUE) {
				guint32 key;
				if (!gee_iterator_next (_key_it)) {
					break;
				}
				key = GPOINTER_TO_UINT (gee_iterator_get (_key_it));
				ids[i] = key;
				i++;
			}
			_g_object_unref0 (_key_it);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	result = (_tmp4_ = ids, *result_length1 = ids_length1, _tmp4_);
	return result;
	ids = (g_free (ids), NULL);
}


static gboolean dvb_recordings_store_real_GetLocation (DVBIDBusRecordingsStore* base, guint32 rec_id, char** location, GError** error) {
	DVBRecordingsStore * self;
	gboolean result;
	gboolean ret;
	self = (DVBRecordingsStore*) base;
	if (location != NULL) {
		*location = NULL;
	}
	ret = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains ((GeeMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
			char* _tmp1_;
			DVBRecording* _tmp0_;
			*location = (_tmp1_ = g_file_get_uri (dvb_recording_get_Location (_tmp0_ = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id)))), _g_free0 (*location), _tmp1_);
			_g_object_unref0 (_tmp0_);
			ret = TRUE;
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	if (!ret) {
		char* _tmp2_;
		*location = (_tmp2_ = g_strdup (""), _g_free0 (*location), _tmp2_);
	}
	result = ret;
	return result;
}


static gboolean dvb_recordings_store_real_GetName (DVBIDBusRecordingsStore* base, guint32 rec_id, char** name, GError** error) {
	DVBRecordingsStore * self;
	gboolean result;
	gboolean ret;
	self = (DVBRecordingsStore*) base;
	if (name != NULL) {
		*name = NULL;
	}
	ret = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains ((GeeMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
			DVBRecording* _tmp0_;
			char* _tmp1_;
			char* val;
			const char* _tmp2_;
			char* _tmp3_;
			val = (_tmp1_ = g_strdup (dvb_recording_get_Name (_tmp0_ = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id)))), _g_object_unref0 (_tmp0_), _tmp1_);
			_tmp2_ = NULL;
			if (val == NULL) {
				_tmp2_ = "";
			} else {
				_tmp2_ = val;
			}
			*name = (_tmp3_ = g_strdup (_tmp2_), _g_free0 (*name), _tmp3_);
			ret = TRUE;
			_g_free0 (val);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	if (!ret) {
		char* _tmp4_;
		*name = (_tmp4_ = g_strdup (""), _g_free0 (*name), _tmp4_);
	}
	result = ret;
	return result;
}


static gboolean dvb_recordings_store_real_GetDescription (DVBIDBusRecordingsStore* base, guint32 rec_id, char** description, GError** error) {
	DVBRecordingsStore * self;
	gboolean result;
	gboolean ret;
	self = (DVBRecordingsStore*) base;
	if (description != NULL) {
		*description = NULL;
	}
	ret = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains ((GeeMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
			DVBRecording* _tmp0_;
			char* _tmp1_;
			char* val;
			const char* _tmp2_;
			char* _tmp3_;
			val = (_tmp1_ = g_strdup (dvb_recording_get_Description (_tmp0_ = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id)))), _g_object_unref0 (_tmp0_), _tmp1_);
			_tmp2_ = NULL;
			if (val == NULL) {
				_tmp2_ = "";
			} else {
				_tmp2_ = val;
			}
			*description = (_tmp3_ = g_strdup (_tmp2_), _g_free0 (*description), _tmp3_);
			ret = TRUE;
			_g_free0 (val);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	if (!ret) {
		char* _tmp4_;
		*description = (_tmp4_ = g_strdup (""), _g_free0 (*description), _tmp4_);
	}
	result = ret;
	return result;
}


static gboolean dvb_recordings_store_real_GetStartTime (DVBIDBusRecordingsStore* base, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error) {
	DVBRecordingsStore * self;
	gboolean result;
	gboolean ret = FALSE;
	self = (DVBRecordingsStore*) base;
	if (start_time != NULL) {
		*start_time = NULL;
	}
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains ((GeeMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
			guint* _tmp2_;
			gint _tmp1_;
			DVBRecording* _tmp0_;
			*start_time = (_tmp2_ = dvb_recording_get_start (_tmp0_ = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id)), &_tmp1_), *start_time = (g_free (*start_time), NULL), *start_time_length1 = _tmp1_, _tmp2_);
			_g_object_unref0 (_tmp0_);
			ret = TRUE;
		} else {
			guint* _tmp4_;
			guint* _tmp3_ = NULL;
			*start_time = (_tmp4_ = (_tmp3_ = g_new0 (guint, 0), _tmp3_), *start_time = (g_free (*start_time), NULL), *start_time_length1 = 0, _tmp4_);
			ret = FALSE;
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	result = ret;
	return result;
}


static gboolean dvb_recordings_store_real_GetStartTimestamp (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* timestamp, GError** error) {
	DVBRecordingsStore * self;
	gboolean result;
	gboolean ret;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains ((GeeMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
			struct tm _tmp2_;
			DVBRecording* _tmp0_;
			struct tm _tmp1_ = {0};
			*timestamp = (gint64) mktime ((_tmp2_ = (dvb_recording_get_StartTime (_tmp0_ = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id)), &_tmp1_), _tmp1_), &_tmp2_));
			_g_object_unref0 (_tmp0_);
			ret = TRUE;
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	result = ret;
	return result;
}


static gboolean dvb_recordings_store_real_GetLength (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* length, GError** error) {
	DVBRecordingsStore * self;
	gboolean result;
	gboolean ret;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains ((GeeMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
			DVBRecording* _tmp0_;
			*length = dvb_recording_get_Length (_tmp0_ = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id)));
			_g_object_unref0 (_tmp0_);
			ret = TRUE;
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	result = ret;
	return result;
}


static gboolean dvb_recordings_store_real_Delete (DVBIDBusRecordingsStore* base, guint32 rec_id, GError** error) {
	DVBRecordingsStore * self;
	gboolean result;
	GError * _inner_error_;
	gboolean val;
	self = (DVBRecordingsStore*) base;
	_inner_error_ = NULL;
	val = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (!gee_map_contains ((GeeMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
			val = FALSE;
		} else {
			DVBRecording* rec;
			g_debug ("RecordingsStore.vala:242: Deleting recording %u", (guint) rec_id);
			rec = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
			{
				GFile* _tmp0_;
				dvb_utils_delete_dir_recursively (_tmp0_ = g_file_get_parent (dvb_recording_get_Location (rec)), &_inner_error_);
				_g_object_unref0 (_tmp0_);
				if (_inner_error_ != NULL) {
					goto __catch41_g_error;
				}
				gee_map_remove ((GeeMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id), NULL);
				val = TRUE;
			}
			goto __finally41;
			__catch41_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					g_critical ("RecordingsStore.vala:249: Could not delete recording: %s", e->message);
					val = FALSE;
					_g_error_free0 (e);
				}
			}
			__finally41:
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (rec);
					return FALSE;
				} else {
					_g_object_unref0 (rec);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			g_signal_emit_by_name ((DVBIDBusRecordingsStore*) self, "changed", rec_id, (guint) DVB_CHANGE_TYPE_DELETED);
			_g_object_unref0 (rec);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	result = val;
	return result;
}


static gboolean dvb_recordings_store_real_GetChannelName (DVBIDBusRecordingsStore* base, guint32 rec_id, char** name, GError** error) {
	DVBRecordingsStore * self;
	gboolean result;
	gboolean ret;
	self = (DVBRecordingsStore*) base;
	if (name != NULL) {
		*name = NULL;
	}
	ret = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains ((GeeMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
			DVBRecording* rec;
			char* _tmp0_;
			rec = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
			*name = (_tmp0_ = g_strdup (dvb_recording_get_ChannelName (rec)), _g_free0 (*name), _tmp0_);
			ret = TRUE;
			_g_object_unref0 (rec);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	if (!ret) {
		char* _tmp1_;
		*name = (_tmp1_ = g_strdup (""), _g_free0 (*name), _tmp1_);
	}
	result = ret;
	return result;
}


static gboolean dvb_recordings_store_real_GetAllInformations (DVBIDBusRecordingsStore* base, guint32 rec_id, DVBRecordingInfo* info, GError** error) {
	DVBRecordingsStore * self;
	gboolean result;
	gboolean ret = FALSE;
	DVBRecordingInfo _tmp1_;
	DVBRecordingInfo _tmp0_ = {0};
	self = (DVBRecordingsStore*) base;
	*info = (_tmp1_ = (memset (&_tmp0_, 0, sizeof (DVBRecordingInfo)), _tmp0_), dvb_recording_info_destroy (info), _tmp1_);
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains ((GeeMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id))) {
			DVBRecording* rec;
			char* name;
			const char* _tmp2_;
			char* _tmp3_;
			const char* _tmp4_;
			char* _tmp5_;
			char* _tmp6_;
			struct tm _tmp8_;
			struct tm _tmp7_ = {0};
			char* _tmp9_;
			rec = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id));
			name = g_strdup (dvb_recording_get_Name (rec));
			_tmp2_ = NULL;
			if (name == NULL) {
				_tmp2_ = "";
			} else {
				_tmp2_ = name;
			}
			(*info).name = (_tmp3_ = g_strdup (_tmp2_), _g_free0 ((*info).name), _tmp3_);
			(*info).id = rec_id;
			(*info).length = dvb_recording_get_Length (rec);
			_tmp4_ = NULL;
			if (dvb_recording_get_Description (rec) == NULL) {
				_tmp4_ = "";
			} else {
				_tmp4_ = dvb_recording_get_Description (rec);
			}
			(*info).description = (_tmp5_ = g_strdup (_tmp4_), _g_free0 ((*info).description), _tmp5_);
			(*info).location = (_tmp6_ = g_file_get_path (dvb_recording_get_Location (rec)), _g_free0 ((*info).location), _tmp6_);
			(*info).start_timestamp = (gint64) mktime ((_tmp8_ = (dvb_recording_get_StartTime (rec, &_tmp7_), _tmp7_), &_tmp8_));
			(*info).channel = (_tmp9_ = g_strdup (dvb_recording_get_ChannelName (rec)), _g_free0 ((*info).channel), _tmp9_);
			ret = TRUE;
			_g_object_unref0 (rec);
			_g_free0 (name);
		} else {
			char* _tmp10_;
			char* _tmp11_;
			char* _tmp12_;
			char* _tmp13_;
			(*info).name = (_tmp10_ = g_strdup (""), _g_free0 ((*info).name), _tmp10_);
			(*info).id = (guint32) 0;
			(*info).length = (gint64) 0;
			(*info).description = (_tmp11_ = g_strdup (""), _g_free0 ((*info).description), _tmp11_);
			(*info).location = (_tmp12_ = g_strdup (""), _g_free0 ((*info).location), _tmp12_);
			(*info).start_timestamp = (gint64) 0;
			(*info).channel = (_tmp13_ = g_strdup (""), _g_free0 ((*info).channel), _tmp13_);
			ret = FALSE;
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	result = ret;
	return result;
}


void dvb_recordings_store_restore_from_dir (DVBRecordingsStore* self, GFile* recordingsbasedir) {
	GError * _inner_error_;
	char* attrs;
	GFileInfo* info;
	GFileEnumerator* files;
	g_return_if_fail (self != NULL);
	g_return_if_fail (recordingsbasedir != NULL);
	_inner_error_ = NULL;
	if (!g_file_query_exists (recordingsbasedir, NULL)) {
		char* _tmp0_;
		g_debug ("RecordingsStore.vala:316: Directory %s does not exist", _tmp0_ = g_file_get_path (recordingsbasedir));
		_g_free0 (_tmp0_);
		return;
	}
	attrs = g_strdup_printf ("%s,%s,%s", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_ACCESS_CAN_READ, G_FILE_ATTRIBUTE_STANDARD_NAME);
	info = NULL;
	{
		GFileInfo* _tmp1_;
		GFileInfo* _tmp2_;
		_tmp1_ = g_file_query_info (recordingsbasedir, attrs, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch42_g_error;
		}
		info = (_tmp2_ = _tmp1_, _g_object_unref0 (info), _tmp2_);
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("RecordingsStore.vala:326: Could not retrieve attributes: %s", e->message);
			_g_error_free0 (e);
			_g_free0 (attrs);
			_g_object_unref0 (info);
			return;
		}
	}
	__finally42:
	if (_inner_error_ != NULL) {
		_g_free0 (attrs);
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (g_file_info_get_file_type (info) != G_FILE_TYPE_DIRECTORY) {
		char* _tmp3_;
		g_critical ("RecordingsStore.vala:331: %s is not a directory", _tmp3_ = g_file_get_path (recordingsbasedir));
		_g_free0 (_tmp3_);
		_g_free0 (attrs);
		_g_object_unref0 (info);
		return;
	}
	if (!g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
		char* _tmp4_;
		g_critical ("RecordingsStore.vala:336: Cannot read %s", _tmp4_ = g_file_get_path (recordingsbasedir));
		_g_free0 (_tmp4_);
		_g_free0 (attrs);
		_g_object_unref0 (info);
		return;
	}
	files = NULL;
	{
		GFileEnumerator* _tmp5_;
		GFileEnumerator* _tmp6_;
		_tmp5_ = g_file_enumerate_children (recordingsbasedir, attrs, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch43_g_error;
		}
		files = (_tmp6_ = _tmp5_, _g_object_unref0 (files), _tmp6_);
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("RecordingsStore.vala:345: Could not read directory: %s", e->message);
			_g_error_free0 (e);
			_g_free0 (attrs);
			_g_object_unref0 (info);
			_g_object_unref0 (files);
			return;
		}
	}
	__finally43:
	if (_inner_error_ != NULL) {
		_g_free0 (attrs);
		_g_object_unref0 (info);
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GFileInfo* childinfo;
		childinfo = NULL;
		while (TRUE) {
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			guint32 type;
			GFile* child;
			_tmp7_ = g_file_enumerator_next_file (files, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (childinfo);
				goto __catch44_g_error;
			}
			if (!((childinfo = (_tmp8_ = _tmp7_, _g_object_unref0 (childinfo), _tmp8_)) != NULL)) {
				break;
			}
			type = g_file_info_get_attribute_uint32 (childinfo, G_FILE_ATTRIBUTE_STANDARD_TYPE);
			child = g_file_get_child (recordingsbasedir, g_file_info_get_name (childinfo));
			switch (type) {
				case G_FILE_TYPE_DIRECTORY:
				{
					dvb_recordings_store_restore_from_dir (self, child);
					break;
				}
				case G_FILE_TYPE_REGULAR:
				{
					if (_vala_strcmp0 (g_file_info_get_name (childinfo), "info.rec") == 0) {
						DVBRecording* rec;
						rec = NULL;
						{
							DVBRecording* _tmp9_;
							DVBRecording* _tmp10_;
							_tmp9_ = dvb_recording_deserialize (child, &_inner_error_);
							if (_inner_error_ != NULL) {
								goto __catch46_g_error;
							}
							rec = (_tmp10_ = _tmp9_, _g_object_unref0 (rec), _tmp10_);
						}
						goto __finally46;
						__catch46_g_error:
						{
							GError * e;
							e = _inner_error_;
							_inner_error_ = NULL;
							{
								g_critical ("RecordingsStore.vala:369: Could not deserialize recording: %s", e->message);
								_g_error_free0 (e);
							}
						}
						__finally46:
						if (_inner_error_ != NULL) {
							_g_object_unref0 (rec);
							_g_object_unref0 (child);
							_g_object_unref0 (childinfo);
							goto __catch44_g_error;
						}
						if (rec != NULL) {
							char* _tmp11_;
							g_debug ("RecordingsStore.vala:374: Restored recording from %s", _tmp11_ = g_file_get_path (child));
							_g_free0 (_tmp11_);
							g_static_rec_mutex_lock (&self->priv->__lock_recordings);
							{
								dvb_recordings_store_add (self, rec, TRUE);
							}
							g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
							g_static_rec_mutex_lock (&self->priv->__lock_last_id);
							{
								if (dvb_recording_get_Id (rec) > self->priv->last_id) {
									self->priv->last_id = dvb_recording_get_Id (rec);
								}
							}
							g_static_rec_mutex_unlock (&self->priv->__lock_last_id);
						}
						_g_object_unref0 (rec);
					}
					break;
				}
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (childinfo);
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("RecordingsStore.vala:391: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally44:
	{
		{
			g_file_enumerator_close (files, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch45_g_error;
			}
		}
		goto __finally45;
		__catch45_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("RecordingsStore.vala:396: Could not close file: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally45:
		if (_inner_error_ != NULL) {
			_g_free0 (attrs);
			_g_object_unref0 (info);
			_g_object_unref0 (files);
		}
	}
	if (_inner_error_ != NULL) {
		_g_free0 (attrs);
		_g_object_unref0 (info);
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (attrs);
	_g_object_unref0 (info);
	_g_object_unref0 (files);
}


static gboolean dvb_recordings_store_delete_recording_by_location (DVBRecordingsStore* self, const char* location) {
	gboolean result;
	gboolean _result_;
	guint32 rec_id;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	_result_ = FALSE;
	rec_id = (guint32) 0;
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		{
			GeeSet* _tmp0_;
			GeeIterator* _tmp1_;
			GeeIterator* _id_it;
			_id_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys ((GeeMap*) self->priv->recordings))), _g_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				guint32 id;
				DVBRecording* rec;
				char* _tmp2_;
				gboolean _tmp3_;
				if (!gee_iterator_next (_id_it)) {
					break;
				}
				id = GPOINTER_TO_UINT (gee_iterator_get (_id_it));
				rec = (DVBRecording*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->recordings, GUINT_TO_POINTER (id));
				if ((_tmp3_ = _vala_strcmp0 (_tmp2_ = g_file_get_path (dvb_recording_get_Location (rec)), location) == 0, _g_free0 (_tmp2_), _tmp3_)) {
					rec_id = id;
					_g_object_unref0 (rec);
					break;
				}
				_g_object_unref0 (rec);
			}
			_g_object_unref0 (_id_it);
		}
		if (rec_id != 0) {
			g_debug ("RecordingsStore.vala:420: Deleting recording %u", (guint) rec_id);
			gee_map_remove ((GeeMap*) self->priv->recordings, GUINT_TO_POINTER (rec_id), NULL);
			g_signal_emit_by_name ((DVBIDBusRecordingsStore*) self, "changed", rec_id, (guint) DVB_CHANGE_TYPE_DELETED);
			_result_ = TRUE;
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	result = _result_;
	return result;
}


static void dvb_recordings_store_on_recording_file_changed (DVBRecordingsStore* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (file != NULL);
	if (event == G_FILE_MONITOR_EVENT_DELETED) {
		char* location;
		location = g_file_get_path (file);
		g_debug ("RecordingsStore.vala:434: %s has been deleted", location);
		dvb_recordings_store_delete_recording_by_location (self, location);
		g_file_monitor_cancel (monitor);
		_g_free0 (location);
	}
}


DVBRecordingsStore* dvb_recordings_store_construct (GType object_type) {
	DVBRecordingsStore * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBRecordingsStore* dvb_recordings_store_new (void) {
	return dvb_recordings_store_construct (DVB_TYPE_RECORDINGS_STORE);
}


static GObject * dvb_recordings_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBRecordingsStore * self;
	parent_class = G_OBJECT_CLASS (dvb_recordings_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_RECORDINGS_STORE (obj);
	{
		GeeHashMap* _tmp1_;
		self->priv->recordings = (_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_RECORDING, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->recordings), _tmp1_);
		self->priv->last_id = (guint32) 0;
	}
	return obj;
}


void _dvb_recordings_store_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_recordings_store_introspect (DVBRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.RecordingsStore\">\n  <method name=\"GetRecordings\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLocation\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"location\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetName\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"name\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDescription\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"description\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTime\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_time\" type=\"au\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTimestamp\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"timestamp\" type=\"x\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLength\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"length\" type=\"x\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"Delete\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"name\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetAllInformations\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"infos\" type=\"(ussxxss)\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"Changed\">\n    <arg name=\"rec_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_recordings_store_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_recordings_store_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (dvb_id_bus_recordings_store_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_recordings_store_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_recordings_store_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dvb_id_bus_recordings_store_dbus_register_object (connection, path, object);
}


static void dvb_recordings_store_class_init (DVBRecordingsStoreClass * klass) {
	GStaticRecMutex _tmp0_ = {0};
	dvb_recordings_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecordingsStorePrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_recordings_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_recordings_store_finalize;
	g_type_set_qdata (DVB_TYPE_RECORDINGS_STORE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_recordings_store_dbus_vtable));
	dvb_recordings_store_instance_mutex = (g_static_rec_mutex_init (&_tmp0_), _tmp0_);
}


static void dvb_recordings_store_dvb_id_bus_recordings_store_interface_init (DVBIDBusRecordingsStoreIface * iface) {
	dvb_recordings_store_dvb_id_bus_recordings_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetRecordings = dvb_recordings_store_real_GetRecordings;
	iface->GetLocation = dvb_recordings_store_real_GetLocation;
	iface->GetName = dvb_recordings_store_real_GetName;
	iface->GetDescription = dvb_recordings_store_real_GetDescription;
	iface->GetStartTime = dvb_recordings_store_real_GetStartTime;
	iface->GetStartTimestamp = dvb_recordings_store_real_GetStartTimestamp;
	iface->GetLength = dvb_recordings_store_real_GetLength;
	iface->Delete = dvb_recordings_store_real_Delete;
	iface->GetChannelName = dvb_recordings_store_real_GetChannelName;
	iface->GetAllInformations = dvb_recordings_store_real_GetAllInformations;
}


static void dvb_recordings_store_instance_init (DVBRecordingsStore * self) {
	self->priv = DVB_RECORDINGS_STORE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_recordings);
	g_static_rec_mutex_init (&self->priv->__lock_last_id);
}


static void dvb_recordings_store_finalize (GObject* obj) {
	DVBRecordingsStore * self;
	self = DVB_RECORDINGS_STORE (obj);
	g_static_rec_mutex_free (&self->priv->__lock_recordings);
	_g_object_unref0 (self->priv->recordings);
	g_static_rec_mutex_free (&self->priv->__lock_last_id);
	G_OBJECT_CLASS (dvb_recordings_store_parent_class)->finalize (obj);
}


GType dvb_recordings_store_get_type (void) {
	static GType dvb_recordings_store_type_id = 0;
	if (dvb_recordings_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecordingsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recordings_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecordingsStore), 0, (GInstanceInitFunc) dvb_recordings_store_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_recordings_store_info = { (GInterfaceInitFunc) dvb_recordings_store_dvb_id_bus_recordings_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_recordings_store_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecordingsStore", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_recordings_store_type_id, DVB_TYPE_ID_BUS_RECORDINGS_STORE, &dvb_id_bus_recordings_store_info);
	}
	return dvb_recordings_store_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}




