/* Manager.c generated by valac, the Vala compiler
 * generated from Manager.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gee.h>
#include <gio/gio.h>
#include <dbus/dbus.h>


#define DVB_TYPE_ID_BUS_MANAGER (dvb_id_bus_manager_get_type ())
#define DVB_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManager))
#define DVB_IS_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_MANAGER))
#define DVB_ID_BUS_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManagerIface))

typedef struct _DVBIDBusManager DVBIDBusManager;
typedef struct _DVBIDBusManagerIface DVBIDBusManagerIface;

#define DVB_TYPE_CHANNEL_GROUP_INFO (dvb_channel_group_info_get_type ())
typedef struct _DVBChannelGroupInfo DVBChannelGroupInfo;

#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;
typedef struct _DVBManagerPrivate DVBManagerPrivate;

#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_EPG_SCANNER (dvb_epg_scanner_get_type ())
#define DVB_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScanner))
#define DVB_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))
#define DVB_IS_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_SCANNER))
#define DVB_IS_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EPG_SCANNER))
#define DVB_EPG_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))

typedef struct _DVBEPGScanner DVBEPGScanner;
typedef struct _DVBEPGScannerClass DVBEPGScannerClass;

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_TYPE_TERRESTRIAL_SCANNER (dvb_terrestrial_scanner_get_type ())
#define DVB_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScanner))
#define DVB_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))
#define DVB_IS_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_IS_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_TERRESTRIAL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))

typedef struct _DVBTerrestrialScanner DVBTerrestrialScanner;
typedef struct _DVBTerrestrialScannerClass DVBTerrestrialScannerClass;

#define DVB_TYPE_SATELLITE_SCANNER (dvb_satellite_scanner_get_type ())
#define DVB_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScanner))
#define DVB_SATELLITE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScannerClass))
#define DVB_IS_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SATELLITE_SCANNER))
#define DVB_IS_SATELLITE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SATELLITE_SCANNER))
#define DVB_SATELLITE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScannerClass))

typedef struct _DVBSatelliteScanner DVBSatelliteScanner;
typedef struct _DVBSatelliteScannerClass DVBSatelliteScannerClass;

#define DVB_TYPE_CABLE_SCANNER (dvb_cable_scanner_get_type ())
#define DVB_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScanner))
#define DVB_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))
#define DVB_IS_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_SCANNER))
#define DVB_IS_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_SCANNER))
#define DVB_CABLE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))

typedef struct _DVBCableScanner DVBCableScanner;
typedef struct _DVBCableScannerClass DVBCableScannerClass;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

#define DVB_DATABASE_TYPE_CONFIG_STORE (dvb_database_config_store_get_type ())
#define DVB_DATABASE_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStore))
#define DVB_DATABASE_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE))
#define DVB_DATABASE_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStoreIface))

typedef struct _DVBdatabaseConfigStore DVBdatabaseConfigStore;
typedef struct _DVBdatabaseConfigStoreIface DVBdatabaseConfigStoreIface;

#define DVB_TYPE_CHANNEL_GROUP (dvb_channel_group_get_type ())
#define DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroup))
#define DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))
#define DVB_IS_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_GROUP))
#define DVB_IS_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_GROUP))
#define DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))

typedef struct _DVBChannelGroup DVBChannelGroup;
typedef struct _DVBChannelGroupClass DVBChannelGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_ID_BUS_DEVICE_GROUP (dvb_id_bus_device_group_get_type ())
#define DVB_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroup))
#define DVB_IS_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP))
#define DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroupIface))

typedef struct _DVBIDBusDeviceGroup DVBIDBusDeviceGroup;
typedef struct _DVBIDBusDeviceGroupIface DVBIDBusDeviceGroupIface;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

#define DVB_DATABASE_TYPE_TIMERS_STORE (dvb_database_timers_store_get_type ())
#define DVB_DATABASE_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStore))
#define DVB_DATABASE_IS_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE))
#define DVB_DATABASE_TIMERS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStoreIface))

typedef struct _DVBdatabaseTimersStore DVBdatabaseTimersStore;
typedef struct _DVBdatabaseTimersStoreIface DVBdatabaseTimersStoreIface;

#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DVBChannelGroupInfo {
	gint id;
	char* name;
};

struct _DVBIDBusManagerIface {
	GTypeInterface parent_iface;
	gboolean (*GetScannerForDevice) (DVBIDBusManager* self, guint adapter, guint frontend, char** opath, char** dbusiface, GError** error);
	char** (*GetRegisteredDeviceGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetDeviceGroup) (DVBIDBusManager* self, guint group_id, char** opath, GError** error);
	gboolean (*AddDeviceToNewGroup) (DVBIDBusManager* self, guint adapter, guint frontend, const char* channels_conf, const char* recordings_dir, const char* name, GError** error);
	gboolean (*GetNameOfRegisteredDevice) (DVBIDBusManager* self, guint adapter, guint frontend, char** name, GError** error);
	gint (*GetDeviceGroupSize) (DVBIDBusManager* self, GError** error);
	DVBChannelGroupInfo* (*GetChannelGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*AddChannelGroup) (DVBIDBusManager* self, const char* name, gint* channel_group_id, GError** error);
	gboolean (*RemoveChannelGroup) (DVBIDBusManager* self, gint channel_group_id, GError** error);
};

struct _DVBManager {
	GObject parent_instance;
	DVBManagerPrivate * priv;
};

struct _DVBManagerClass {
	GObjectClass parent_class;
};

struct _DVBManagerPrivate {
	GeeHashMap* scanners;
	GStaticRecMutex __lock_scanners;
	GeeHashMap* devices;
	GStaticRecMutex __lock_devices;
	guint device_group_counter;
};

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBdatabaseConfigStore* self, GError** error);
	gboolean (*add_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
	gboolean (*remove_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_device_to_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*remove_device_from_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*update_from_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_channel_group) (DVBdatabaseConfigStore* self, const char* name, gint* channel_group_id, GError** error);
	gboolean (*remove_channel_group) (DVBdatabaseConfigStore* self, gint group_id, GError** error);
	GeeList* (*get_channel_groups) (DVBdatabaseConfigStore* self, GError** error);
	GeeList* (*get_channels_of_group) (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
	gboolean (*add_channel_to_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
	gboolean (*remove_channel_from_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
};

struct _DVBIDBusDeviceGroupIface {
	GTypeInterface parent_iface;
	char* (*GetType) (DVBIDBusDeviceGroup* self, GError** error);
	char* (*GetRecorder) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*AddDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	gboolean (*RemoveDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	char* (*GetChannelList) (DVBIDBusDeviceGroup* self, GError** error);
	char* (*GetName) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetName) (DVBIDBusDeviceGroup* self, const char* name, GError** error);
	char** (*GetMembers) (DVBIDBusDeviceGroup* self, int* result_length1, GError** error);
	gboolean (*GetSchedule) (DVBIDBusDeviceGroup* self, guint channel_sid, char** opath, GError** error);
	char* (*GetRecordingsDirectory) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetRecordingsDirectory) (DVBIDBusDeviceGroup* self, const char* location, GError** error);
};

struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};

struct _DVBdatabaseTimersStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_timers_of_device_group) (DVBdatabaseTimersStore* self, DVBDeviceGroup* dev, GError** error);
	gboolean (*add_timer_to_device_group) (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_timer_from_device_group) (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_all_timers_from_device_group) (DVBdatabaseTimersStore* self, guint group_id, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static DVBManager* dvb_manager_instance;
static DVBManager* dvb_manager_instance = NULL;
static GStaticRecMutex dvb_manager_instance_mutex;
static GStaticRecMutex dvb_manager_instance_mutex = {0};
static gpointer dvb_manager_parent_class = NULL;
static DVBIDBusManagerIface* dvb_manager_dvb_id_bus_manager_parent_iface = NULL;

GType dvb_channel_group_info_get_type (void);
DVBChannelGroupInfo* dvb_channel_group_info_dup (const DVBChannelGroupInfo* self);
void dvb_channel_group_info_free (DVBChannelGroupInfo* self);
void dvb_channel_group_info_copy (const DVBChannelGroupInfo* self, DVBChannelGroupInfo* dest);
void dvb_channel_group_info_destroy (DVBChannelGroupInfo* self);
GType dvb_id_bus_manager_get_type (void);
GType dvb_manager_get_type (void);
GType dvb_scanner_get_type (void);
GType dvb_device_group_get_type (void);
#define DVB_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_MANAGER, DVBManagerPrivate))
enum  {
	DVB_MANAGER_DUMMY_PROPERTY,
	DVB_MANAGER_DEVICE_GROUPS
};
DVBManager* dvb_manager_new (void);
DVBManager* dvb_manager_construct (GType object_type);
DVBManager* dvb_manager_get_instance (void);
void dvb_scanner_Destroy (DVBScanner* self, GError** error);
void dvb_device_group_destroy (DVBDeviceGroup* self);
void dvb_manager_shutdown (void);
#define DVB_CONSTANTS_DBUS_SCANNER_PATH "/org/gnome/DVB/Scanner/%d/%d"
GType dvb_device_get_type (void);
static DVBDevice* dvb_manager_get_registered_device (DVBManager* self, guint adapter, guint frontend);
DVBDevice* dvb_device_new (guint adapter, guint frontend, gboolean get_type_and_name);
DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend, gboolean get_type_and_name);
static DVBDeviceGroup* dvb_manager_get_device_group_of_device (DVBManager* self, DVBDevice* device);
GType dvb_epg_scanner_get_type (void);
DVBEPGScanner* dvb_device_group_get_epgscanner (DVBDeviceGroup* self);
void dvb_epg_scanner_stop (DVBEPGScanner* self);
GType dvb_adapter_type_get_type (void);
DVBAdapterType dvb_device_get_Type (DVBDevice* self);
DVBTerrestrialScanner* dvb_terrestrial_scanner_new (DVBDevice* device);
DVBTerrestrialScanner* dvb_terrestrial_scanner_construct (GType object_type, DVBDevice* device);
GType dvb_terrestrial_scanner_get_type (void);
DVBSatelliteScanner* dvb_satellite_scanner_new (DVBDevice* device);
DVBSatelliteScanner* dvb_satellite_scanner_construct (GType object_type, DVBDevice* device);
GType dvb_satellite_scanner_get_type (void);
DVBCableScanner* dvb_cable_scanner_new (DVBDevice* device);
DVBCableScanner* dvb_cable_scanner_construct (GType object_type, DVBDevice* device);
GType dvb_cable_scanner_get_type (void);
static void dvb_manager_on_scanner_destroyed (DVBManager* self, DVBScanner* scanner);
static void _dvb_manager_on_scanner_destroyed_dvb_scanner_destroyed (DVBScanner* _sender, gpointer self);
DBusGConnection* dvb_utils_get_dbus_connection (void);
static gboolean dvb_manager_real_GetScannerForDevice (DVBIDBusManager* base, guint adapter, guint frontend, char** opath, char** dbusiface, GError** error);
#define DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH "/org/gnome/DVB/DeviceGroup/%u"
static gboolean dvb_manager_real_GetDeviceGroup (DVBIDBusManager* base, guint group_id, char** opath, GError** error);
static char** dvb_manager_real_GetRegisteredDeviceGroups (DVBIDBusManager* base, int* result_length1, GError** error);
static DVBDevice* dvb_manager_create_device (guint adapter, guint frontend, const char* channels_conf, const char* recordings_dir, guint group_id);
gboolean dvb_manager_device_is_in_any_group (DVBManager* self, DVBDevice* device);
DVBDeviceGroup* dvb_device_group_new (guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
DVBDeviceGroup* dvb_device_group_construct (GType object_type, guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
void dvb_device_group_set_Name (DVBDeviceGroup* self, const char* value);
gboolean dvb_manager_add_device_group (DVBManager* self, DVBDeviceGroup* devgroup);
static gboolean dvb_manager_real_AddDeviceToNewGroup (DVBIDBusManager* base, guint adapter, guint frontend, const char* channels_conf, const char* recordings_dir, const char* name, GError** error);
const char* dvb_device_get_Name (DVBDevice* self);
static gboolean dvb_manager_real_GetNameOfRegisteredDevice (DVBIDBusManager* base, guint adapter, guint frontend, char** name, GError** error);
static gint dvb_manager_real_GetDeviceGroupSize (DVBIDBusManager* base, GError** error);
GQuark dvb_database_sql_error_quark (void);
GType dvb_channel_group_get_type (void);
GType dvb_channel_get_type (void);
GType dvb_database_config_store_get_type (void);
DVBdatabaseConfigStore* dvb_factory_get_config_store (void);
GeeList* dvb_database_config_store_get_channel_groups (DVBdatabaseConfigStore* self, GError** error);
gint dvb_channel_group_get_id (DVBChannelGroup* self);
const char* dvb_channel_group_get_name (DVBChannelGroup* self);
static void _vala_DVBChannelGroupInfo_array_free (DVBChannelGroupInfo* array, gint array_length);
static DVBChannelGroupInfo* dvb_manager_real_GetChannelGroups (DVBIDBusManager* base, int* result_length1, GError** error);
gboolean dvb_database_config_store_add_channel_group (DVBdatabaseConfigStore* self, const char* name, gint* channel_group_id, GError** error);
static gboolean dvb_manager_real_AddChannelGroup (DVBIDBusManager* base, const char* name, gint* channel_group_id, GError** error);
gboolean dvb_database_config_store_remove_channel_group (DVBdatabaseConfigStore* self, gint group_id, GError** error);
static gboolean dvb_manager_real_RemoveChannelGroup (DVBIDBusManager* base, gint channel_group_id, GError** error);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
gint dvb_device_group_get_size (DVBDeviceGroup* self);
DVBAdapterType dvb_device_group_get_Type (DVBDeviceGroup* self);
gboolean dvb_database_config_store_add_device_group (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
static void dvb_manager_on_device_removed_from_group (DVBManager* self, DVBDeviceGroup* devgroup, guint adapter, guint frontend);
static void _dvb_manager_on_device_removed_from_group_dvb_id_bus_device_group_device_removed (DVBDeviceGroup* _sender, guint adapter, guint frontend, gpointer self);
GType dvb_id_bus_device_group_get_type (void);
gboolean main_get_disable_epg_scanner (void);
gboolean dvb_epg_scanner_start (DVBEPGScanner* self);
void dvb_device_set_RecordingsDirectory (DVBDevice* self, GFile* value);
GType dvb_channel_list_get_type (void);
DVBChannelList* dvb_channel_list_restore_from_file (GFile* channelsfile, DVBAdapterType type, guint group_id, GError** error);
void dvb_device_set_Channels (DVBDevice* self, DVBChannelList* value);
DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id);
gboolean dvb_device_group_contains (DVBDeviceGroup* self, DVBDevice* device);
DVBDevice* dvb_scanner_get_Device (DVBScanner* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2);
gboolean dvb_database_config_store_remove_device_group (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void);
GType dvb_database_epg_store_get_type (void);
DVBdatabaseEPGStore* dvb_factory_get_epg_store (void);
gboolean dvb_database_epg_store_remove_events_of_group (DVBdatabaseEPGStore* self, guint group_id, GError** error);
GType dvb_timer_get_type (void);
GType dvb_database_timers_store_get_type (void);
DVBdatabaseTimersStore* dvb_factory_get_timers_store (void);
gboolean dvb_database_timers_store_remove_all_timers_from_device_group (DVBdatabaseTimersStore* self, guint group_id, GError** error);
GeeCollection* dvb_manager_get_device_groups (DVBManager* self);
static GObject * dvb_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void dvb_manager_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_manager_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_manager_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_manager_introspect (DVBManager* self, DBusConnection* connection, DBusMessage* message);
static void dvb_manager_finalize (GObject* obj);
static void dvb_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_manager_dbus_path_vtable = {_dvb_manager_dbus_unregister, dvb_manager_dbus_message};
static const _DBusObjectVTable _dvb_manager_dbus_vtable = {dvb_manager_dbus_register_object};


DVBManager* dvb_manager_get_instance (void) {
	DVBManager* result;
	g_static_rec_mutex_lock (&dvb_manager_instance_mutex);
	if (dvb_manager_instance == NULL) {
		DVBManager* _tmp0_;
		dvb_manager_instance = (_tmp0_ = dvb_manager_new (), _g_object_unref0 (dvb_manager_instance), _tmp0_);
	}
	g_static_rec_mutex_unlock (&dvb_manager_instance_mutex);
	result = dvb_manager_instance;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_manager_shutdown (void) {
	GError * _inner_error_;
	DVBManager* m;
	_inner_error_ = NULL;
	g_static_rec_mutex_lock (&dvb_manager_instance_mutex);
	m = _g_object_ref0 (dvb_manager_instance);
	if (dvb_manager_instance != NULL) {
		DVBManager* _tmp4_;
		g_static_rec_mutex_lock (&m->priv->__lock_scanners);
		{
			{
				GeeCollection* _tmp0_;
				GeeIterator* _tmp1_;
				GeeIterator* _scanner_it;
				_scanner_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_values ((GeeMap*) m->priv->scanners))), _g_object_unref0 (_tmp0_), _tmp1_);
				while (TRUE) {
					DVBScanner* scanner;
					if (!gee_iterator_next (_scanner_it)) {
						break;
					}
					scanner = (DVBScanner*) gee_iterator_get (_scanner_it);
					g_debug ("Manager.vala:68: Stopping scanner");
					dvb_scanner_Destroy (scanner, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (scanner);
						_g_object_unref0 (_scanner_it);
						_g_object_unref0 (m);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (scanner);
				}
				_g_object_unref0 (_scanner_it);
			}
			gee_abstract_map_clear ((GeeAbstractMap*) m->priv->scanners);
		}
		g_static_rec_mutex_unlock (&m->priv->__lock_scanners);
		g_static_rec_mutex_lock (&m->priv->__lock_devices);
		{
			{
				GeeCollection* _tmp2_;
				GeeIterator* _tmp3_;
				GeeIterator* _devgrp_it;
				_devgrp_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = gee_map_get_values ((GeeMap*) m->priv->devices))), _g_object_unref0 (_tmp2_), _tmp3_);
				while (TRUE) {
					DVBDeviceGroup* devgrp;
					if (!gee_iterator_next (_devgrp_it)) {
						break;
					}
					devgrp = (DVBDeviceGroup*) gee_iterator_get (_devgrp_it);
					dvb_device_group_destroy (devgrp);
					_g_object_unref0 (devgrp);
				}
				_g_object_unref0 (_devgrp_it);
			}
			gee_abstract_map_clear ((GeeAbstractMap*) m->priv->devices);
		}
		g_static_rec_mutex_unlock (&m->priv->__lock_devices);
		dvb_manager_instance = (_tmp4_ = NULL, _g_object_unref0 (dvb_manager_instance), _tmp4_);
	}
	g_static_rec_mutex_unlock (&dvb_manager_instance_mutex);
	_g_object_unref0 (m);
}


static void _dvb_manager_on_scanner_destroyed_dvb_scanner_destroyed (DVBScanner* _sender, gpointer self) {
	dvb_manager_on_scanner_destroyed (self, _sender);
}


static gboolean dvb_manager_real_GetScannerForDevice (DVBIDBusManager* base, guint adapter, guint frontend, char** opath, char** dbusiface, GError** error) {
	DVBManager * self;
	gboolean result;
	char* path;
	char* _tmp0_;
	DVBDevice* device;
	DVBDevice* reg_dev;
	self = (DVBManager*) base;
	if (opath != NULL) {
		*opath = NULL;
	}
	if (dbusiface != NULL) {
		*dbusiface = NULL;
	}
	path = g_strdup_printf (DVB_CONSTANTS_DBUS_SCANNER_PATH, adapter, frontend);
	*opath = (_tmp0_ = g_strdup (path), _g_free0 (*opath), _tmp0_);
	device = NULL;
	reg_dev = dvb_manager_get_registered_device (self, adapter, frontend);
	if (reg_dev == NULL) {
		DVBDevice* _tmp1_;
		device = (_tmp1_ = dvb_device_new (adapter, frontend, TRUE), _g_object_unref0 (device), _tmp1_);
	} else {
		DVBDeviceGroup* _tmp2_;
		DVBEPGScanner* _tmp3_;
		DVBEPGScanner* epgscanner;
		DVBDevice* _tmp4_;
		epgscanner = (_tmp3_ = _g_object_ref0 (dvb_device_group_get_epgscanner (_tmp2_ = dvb_manager_get_device_group_of_device (self, reg_dev))), _g_object_unref0 (_tmp2_), _tmp3_);
		if (epgscanner != NULL) {
			dvb_epg_scanner_stop (epgscanner);
		}
		device = (_tmp4_ = _g_object_ref0 (reg_dev), _g_object_unref0 (device), _tmp4_);
		_g_object_unref0 (epgscanner);
	}
	switch (dvb_device_get_Type (device)) {
		case DVB_ADAPTER_TYPE_DVB_T:
		{
			char* _tmp5_;
			*dbusiface = (_tmp5_ = g_strdup ("org.gnome.DVB.Scanner.Terrestrial"), _g_free0 (*dbusiface), _tmp5_);
			break;
		}
		case DVB_ADAPTER_TYPE_DVB_S:
		{
			char* _tmp6_;
			*dbusiface = (_tmp6_ = g_strdup ("org.gnome.DVB.Scanner.Satellite"), _g_free0 (*dbusiface), _tmp6_);
			break;
		}
		case DVB_ADAPTER_TYPE_DVB_C:
		{
			char* _tmp7_;
			*dbusiface = (_tmp7_ = g_strdup ("org.gnome.DVB.Scanner.Cable"), _g_free0 (*dbusiface), _tmp7_);
			break;
		}
		default:
		{
			char* _tmp8_;
			*dbusiface = (_tmp8_ = NULL, _g_free0 (*dbusiface), _tmp8_);
			break;
		}
	}
	if ((*dbusiface) == NULL) {
		char* _tmp9_;
		g_critical ("Manager.vala:136: Unknown adapter type");
		*dbusiface = (_tmp9_ = g_strdup (""), _g_free0 (*dbusiface), _tmp9_);
		result = FALSE;
		_g_free0 (path);
		_g_object_unref0 (device);
		_g_object_unref0 (reg_dev);
		return result;
	}
	g_static_rec_mutex_lock (&self->priv->__lock_scanners);
	{
		if (!gee_map_contains ((GeeMap*) self->priv->scanners, path)) {
			DVBScanner* scanner;
			DBusGConnection* conn;
			scanner = NULL;
			switch (dvb_device_get_Type (device)) {
				case DVB_ADAPTER_TYPE_DVB_T:
				{
					DVBScanner* _tmp10_;
					scanner = (_tmp10_ = (DVBScanner*) dvb_terrestrial_scanner_new (device), _g_object_unref0 (scanner), _tmp10_);
					break;
				}
				case DVB_ADAPTER_TYPE_DVB_S:
				{
					DVBScanner* _tmp11_;
					scanner = (_tmp11_ = (DVBScanner*) dvb_satellite_scanner_new (device), _g_object_unref0 (scanner), _tmp11_);
					break;
				}
				case DVB_ADAPTER_TYPE_DVB_C:
				{
					DVBScanner* _tmp12_;
					scanner = (_tmp12_ = (DVBScanner*) dvb_cable_scanner_new (device), _g_object_unref0 (scanner), _tmp12_);
					break;
				}
			}
			if (scanner == NULL) {
				g_critical ("Manager.vala:159: Unknown adapter type");
				result = FALSE;
				_g_object_unref0 (scanner);
				_g_free0 (path);
				_g_object_unref0 (device);
				_g_object_unref0 (reg_dev);
				return result;
			}
			g_signal_connect_object (scanner, "destroyed", (GCallback) _dvb_manager_on_scanner_destroyed_dvb_scanner_destroyed, self, 0);
			gee_abstract_map_set ((GeeAbstractMap*) self->priv->scanners, path, scanner);
			conn = dvb_utils_get_dbus_connection ();
			if (conn == NULL) {
				result = FALSE;
				_g_object_unref0 (scanner);
				_dbus_g_connection_unref0 (conn);
				_g_free0 (path);
				_g_object_unref0 (device);
				_g_object_unref0 (reg_dev);
				return result;
			}
			_vala_dbus_register_object (dbus_g_connection_get_connection (conn), path, (GObject*) scanner);
			g_debug ("Manager.vala:174: Created new Scanner D-Bus service for adapter %u, fr" \
"ontend %u (%s)", adapter, frontend, *dbusiface);
			_g_object_unref0 (scanner);
			_dbus_g_connection_unref0 (conn);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_scanners);
	result = TRUE;
	_g_free0 (path);
	_g_object_unref0 (device);
	_g_object_unref0 (reg_dev);
	return result;
}


static gboolean dvb_manager_real_GetDeviceGroup (DVBIDBusManager* base, guint group_id, char** opath, GError** error) {
	DVBManager * self;
	gboolean result;
	gboolean ret = FALSE;
	self = (DVBManager*) base;
	if (opath != NULL) {
		*opath = NULL;
	}
	g_static_rec_mutex_lock (&self->priv->__lock_devices);
	{
		if (gee_map_contains ((GeeMap*) self->priv->devices, GUINT_TO_POINTER (group_id))) {
			char* _tmp1_;
			char* _tmp0_;
			*opath = (_tmp1_ = g_strdup (_tmp0_ = g_strdup_printf (DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH, group_id)), _g_free0 (*opath), _tmp1_);
			_g_free0 (_tmp0_);
			ret = TRUE;
		} else {
			char* _tmp2_;
			*opath = (_tmp2_ = g_strdup (""), _g_free0 (*opath), _tmp2_);
			ret = FALSE;
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_devices);
	result = ret;
	return result;
}


static char** dvb_manager_real_GetRegisteredDeviceGroups (DVBIDBusManager* base, int* result_length1, GError** error) {
	DVBManager * self;
	char** result;
	char** _tmp1_;
	gint devs_size;
	gint devs_length1;
	gint _tmp0_;
	char** devs;
	gint i;
	char** _tmp6_;
	self = (DVBManager*) base;
	devs = (_tmp1_ = g_new0 (char*, (_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->devices)) + 1), devs_length1 = _tmp0_, devs_size = devs_length1, _tmp1_);
	i = 0;
	g_static_rec_mutex_lock (&self->priv->__lock_devices);
	{
		{
			GeeSet* _tmp2_;
			GeeIterator* _tmp3_;
			GeeIterator* _key_it;
			_key_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = gee_map_get_keys ((GeeMap*) self->priv->devices))), _g_object_unref0 (_tmp2_), _tmp3_);
			while (TRUE) {
				guint key;
				char* _tmp5_;
				char* _tmp4_;
				if (!gee_iterator_next (_key_it)) {
					break;
				}
				key = GPOINTER_TO_UINT (gee_iterator_get (_key_it));
				devs[i] = (_tmp5_ = g_strdup (_tmp4_ = g_strdup_printf (DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH, key)), _g_free0 (devs[i]), _tmp5_);
				_g_free0 (_tmp4_);
				i++;
			}
			_g_object_unref0 (_key_it);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_devices);
	result = (_tmp6_ = devs, *result_length1 = devs_length1, _tmp6_);
	return result;
	devs = (_vala_array_free (devs, devs_length1, (GDestroyNotify) g_free), NULL);
}


static gboolean dvb_manager_real_AddDeviceToNewGroup (DVBIDBusManager* base, guint adapter, guint frontend, const char* channels_conf, const char* recordings_dir, const char* name, GError** error) {
	DVBManager * self;
	gboolean result;
	DVBDevice* device;
	DVBDeviceGroup* devgroup;
	self = (DVBManager*) base;
	g_return_val_if_fail (channels_conf != NULL, FALSE);
	g_return_val_if_fail (recordings_dir != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	device = dvb_manager_create_device (adapter, frontend, channels_conf, recordings_dir, self->priv->device_group_counter + 1);
	if (device == NULL) {
		result = FALSE;
		_g_object_unref0 (device);
		return result;
	}
	if (dvb_manager_device_is_in_any_group (self, device)) {
		result = FALSE;
		_g_object_unref0 (device);
		return result;
	}
	self->priv->device_group_counter++;
	devgroup = dvb_device_group_new (self->priv->device_group_counter, device, TRUE);
	dvb_device_group_set_Name (devgroup, name);
	dvb_manager_add_device_group (self, devgroup);
	g_signal_emit_by_name ((DVBIDBusManager*) self, "group-added", self->priv->device_group_counter);
	result = TRUE;
	_g_object_unref0 (device);
	_g_object_unref0 (devgroup);
	return result;
}


static gboolean dvb_manager_real_GetNameOfRegisteredDevice (DVBIDBusManager* base, guint adapter, guint frontend, char** name, GError** error) {
	DVBManager * self;
	gboolean result;
	DVBDevice* dev;
	self = (DVBManager*) base;
	if (name != NULL) {
		*name = NULL;
	}
	dev = dvb_manager_get_registered_device (self, adapter, frontend);
	if (dev == NULL) {
		char* _tmp0_;
		*name = (_tmp0_ = g_strdup (""), _g_free0 (*name), _tmp0_);
		result = FALSE;
		_g_object_unref0 (dev);
		return result;
	} else {
		char* _tmp1_;
		*name = (_tmp1_ = g_strdup (dvb_device_get_Name (dev)), _g_free0 (*name), _tmp1_);
		result = TRUE;
		_g_object_unref0 (dev);
		return result;
	}
	_g_object_unref0 (dev);
}


static gint dvb_manager_real_GetDeviceGroupSize (DVBIDBusManager* base, GError** error) {
	DVBManager * self;
	gint result;
	self = (DVBManager*) base;
	result = gee_map_get_size ((GeeMap*) self->priv->devices);
	return result;
}


static void _vala_DVBChannelGroupInfo_array_free (DVBChannelGroupInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_channel_group_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DVBChannelGroupInfo* dvb_manager_real_GetChannelGroups (DVBIDBusManager* base, int* result_length1, GError** error) {
	DVBManager * self;
	DVBChannelGroupInfo* result;
	GError * _inner_error_;
	DVBdatabaseConfigStore* config;
	GeeList* groups;
	DVBChannelGroupInfo* _tmp5_;
	gint arr_size;
	gint arr_length1;
	gint _tmp4_;
	DVBChannelGroupInfo* arr;
	DVBChannelGroupInfo* _tmp10_;
	self = (DVBManager*) base;
	_inner_error_ = NULL;
	config = _g_object_ref0 (dvb_factory_get_config_store ());
	groups = NULL;
	{
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		_tmp0_ = dvb_database_config_store_get_channel_groups (config, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch28_dvb_database_sql_error;
			}
			_g_object_unref0 (config);
			_g_object_unref0 (groups);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		groups = (_tmp1_ = _tmp0_, _g_object_unref0 (groups), _tmp1_);
	}
	goto __finally28;
	__catch28_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			DVBChannelGroupInfo* _tmp2_ = NULL;
			DVBChannelGroupInfo* _tmp3_;
			g_critical ("Manager.vala:295: %s", e->message);
			result = (_tmp3_ = (_tmp2_ = g_new0 (DVBChannelGroupInfo, 0), _tmp2_), *result_length1 = 0, _tmp3_);
			_g_error_free0 (e);
			_g_object_unref0 (config);
			_g_object_unref0 (groups);
			return result;
			_g_error_free0 (e);
		}
	}
	__finally28:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (config);
			_g_object_unref0 (groups);
			return NULL;
		} else {
			_g_object_unref0 (config);
			_g_object_unref0 (groups);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	arr = (_tmp5_ = g_new0 (DVBChannelGroupInfo, _tmp4_ = gee_collection_get_size ((GeeCollection*) groups)), arr_length1 = _tmp4_, arr_size = arr_length1, _tmp5_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				DVBChannelGroup* cg;
				DVBChannelGroupInfo _tmp8_;
				DVBChannelGroupInfo _tmp7_ = {0};
				char* _tmp9_;
				if (!_tmp6_) {
					i++;
				}
				_tmp6_ = FALSE;
				if (!(i < arr_length1)) {
					break;
				}
				cg = (DVBChannelGroup*) gee_list_get (groups, i);
				arr[i] = (_tmp8_ = (memset (&_tmp7_, 0, sizeof (DVBChannelGroupInfo)), _tmp7_), dvb_channel_group_info_destroy (&arr[i]), _tmp8_);
				arr[i].id = dvb_channel_group_get_id (cg);
				arr[i].name = (_tmp9_ = g_strdup (dvb_channel_group_get_name (cg)), _g_free0 (arr[i].name), _tmp9_);
				_g_object_unref0 (cg);
			}
		}
	}
	result = (_tmp10_ = arr, *result_length1 = arr_length1, _tmp10_);
	_g_object_unref0 (config);
	_g_object_unref0 (groups);
	return result;
	_g_object_unref0 (config);
	_g_object_unref0 (groups);
	arr = (_vala_DVBChannelGroupInfo_array_free (arr, arr_length1), NULL);
}


static gboolean dvb_manager_real_AddChannelGroup (DVBIDBusManager* base, const char* name, gint* channel_group_id, GError** error) {
	DVBManager * self;
	gboolean result;
	GError * _inner_error_;
	DVBdatabaseConfigStore* config;
	gboolean ret = FALSE;
	self = (DVBManager*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_inner_error_ = NULL;
	config = _g_object_ref0 (dvb_factory_get_config_store ());
	{
		gboolean _tmp0_;
		_tmp0_ = dvb_database_config_store_add_channel_group (config, name, channel_group_id, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch29_dvb_database_sql_error;
			}
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		ret = _tmp0_;
	}
	goto __finally29;
	__catch29_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Manager.vala:318: %s", e->message);
			ret = FALSE;
			_g_error_free0 (e);
		}
	}
	__finally29:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (config);
	return result;
}


static gboolean dvb_manager_real_RemoveChannelGroup (DVBIDBusManager* base, gint channel_group_id, GError** error) {
	DVBManager * self;
	gboolean result;
	GError * _inner_error_;
	DVBdatabaseConfigStore* config;
	gboolean ret = FALSE;
	self = (DVBManager*) base;
	_inner_error_ = NULL;
	config = _g_object_ref0 (dvb_factory_get_config_store ());
	{
		gboolean _tmp0_;
		_tmp0_ = dvb_database_config_store_remove_channel_group (config, channel_group_id, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch30_dvb_database_sql_error;
			}
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		ret = _tmp0_;
	}
	goto __finally30;
	__catch30_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Manager.vala:334: %s", e->message);
			ret = FALSE;
			_g_error_free0 (e);
		}
	}
	__finally30:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (config);
	return result;
}


static void _dvb_manager_on_device_removed_from_group_dvb_id_bus_device_group_device_removed (DVBDeviceGroup* _sender, guint adapter, guint frontend, gpointer self) {
	dvb_manager_on_device_removed_from_group (self, _sender, adapter, frontend);
}


gboolean dvb_manager_add_device_group (DVBManager* self, DVBDeviceGroup* devgroup) {
	gboolean result;
	GError * _inner_error_;
	guint group_id;
	DBusGConnection* conn;
	char* path;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (devgroup != NULL, FALSE);
	_inner_error_ = NULL;
	group_id = dvb_device_group_get_Id (devgroup);
	g_debug ("Manager.vala:347: Adding device group %u with %d devices", group_id, dvb_device_group_get_size (devgroup));
	if (dvb_device_group_get_Type (devgroup) == DVB_ADAPTER_TYPE_UNKNOWN) {
		g_warning ("Manager.vala:351: Not adding device group %u of unknown type", dvb_device_group_get_Id (devgroup));
		result = FALSE;
		return result;
	}
	g_static_rec_mutex_lock (&self->priv->__lock_devices);
	{
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->devices, GUINT_TO_POINTER (group_id), devgroup);
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_devices);
	{
		dvb_database_config_store_add_device_group (dvb_factory_get_config_store (), devgroup, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch31_dvb_database_sql_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally31;
	__catch31_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Manager.vala:362: %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally31:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	g_signal_connect_object ((DVBIDBusDeviceGroup*) devgroup, "device-removed", (GCallback) _dvb_manager_on_device_removed_from_group_dvb_id_bus_device_group_device_removed, self, 0);
	conn = dvb_utils_get_dbus_connection ();
	if (conn == NULL) {
		result = FALSE;
		_dbus_g_connection_unref0 (conn);
		return result;
	}
	path = g_strdup_printf (DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH, group_id);
	_vala_dbus_register_object (dbus_g_connection_get_connection (conn), path, (GObject*) devgroup);
	if (group_id > self->priv->device_group_counter) {
		self->priv->device_group_counter = group_id;
	}
	if (!main_get_disable_epg_scanner ()) {
		dvb_epg_scanner_start (dvb_device_group_get_epgscanner (devgroup));
	}
	result = TRUE;
	_dbus_g_connection_unref0 (conn);
	_g_free0 (path);
	return result;
}


static DVBDevice* dvb_manager_create_device (guint adapter, guint frontend, const char* channels_conf, const char* recordings_dir, guint group_id) {
	DVBDevice* result;
	GError * _inner_error_;
	GFile* channelsfile;
	GFile* recdir;
	DVBDevice* device;
	DVBChannelList* channels;
	g_return_val_if_fail (channels_conf != NULL, NULL);
	g_return_val_if_fail (recordings_dir != NULL, NULL);
	_inner_error_ = NULL;
	channelsfile = g_file_new_for_path (channels_conf);
	recdir = g_file_new_for_path (recordings_dir);
	device = dvb_device_new (adapter, frontend, TRUE);
	if (dvb_device_get_Type (device) == DVB_ADAPTER_TYPE_UNKNOWN) {
		result = NULL;
		_g_object_unref0 (channelsfile);
		_g_object_unref0 (recdir);
		_g_object_unref0 (device);
		return result;
	}
	dvb_device_set_RecordingsDirectory (device, recdir);
	channels = NULL;
	{
		DVBChannelList* _tmp0_;
		DVBChannelList* _tmp1_;
		_tmp0_ = dvb_channel_list_restore_from_file (channelsfile, dvb_device_get_Type (device), group_id, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch32_g_error;
		}
		channels = (_tmp1_ = _tmp0_, _g_object_unref0 (channels), _tmp1_);
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Manager.vala:408: Could not create channels list from %s: %s", channels_conf, e->message);
			result = NULL;
			_g_error_free0 (e);
			_g_object_unref0 (channelsfile);
			_g_object_unref0 (recdir);
			_g_object_unref0 (device);
			_g_object_unref0 (channels);
			return result;
		}
	}
	__finally32:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (channelsfile);
		_g_object_unref0 (recdir);
		_g_object_unref0 (device);
		_g_object_unref0 (channels);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	dvb_device_set_Channels (device, channels);
	result = device;
	_g_object_unref0 (channelsfile);
	_g_object_unref0 (recdir);
	_g_object_unref0 (channels);
	return result;
}


DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id) {
	DVBDeviceGroup* result;
	DVBDeviceGroup* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	g_static_rec_mutex_lock (&self->priv->__lock_devices);
	{
		if (gee_map_contains ((GeeMap*) self->priv->devices, GUINT_TO_POINTER (group_id))) {
			DVBDeviceGroup* _tmp0_;
			_result_ = (_tmp0_ = (DVBDeviceGroup*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->devices, GUINT_TO_POINTER (group_id)), _g_object_unref0 (_result_), _tmp0_);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_devices);
	result = _result_;
	return result;
}


gboolean dvb_manager_device_is_in_any_group (DVBManager* self, DVBDevice* device) {
	gboolean result;
	gboolean _result_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	_result_ = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_devices);
	{
		{
			GeeSet* _tmp0_;
			GeeIterator* _tmp1_;
			GeeIterator* _group_id_it;
			_group_id_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys ((GeeMap*) self->priv->devices))), _g_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				guint group_id;
				DVBDeviceGroup* devgroup;
				if (!gee_iterator_next (_group_id_it)) {
					break;
				}
				group_id = GPOINTER_TO_UINT (gee_iterator_get (_group_id_it));
				devgroup = (DVBDeviceGroup*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->devices, GUINT_TO_POINTER (group_id));
				if (dvb_device_group_contains (devgroup, device)) {
					_result_ = TRUE;
					_g_object_unref0 (devgroup);
					break;
				}
				_g_object_unref0 (devgroup);
			}
			_g_object_unref0 (_group_id_it);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_devices);
	result = _result_;
	return result;
}


static void dvb_manager_on_scanner_destroyed (DVBManager* self, DVBScanner* scanner) {
	guint adapter;
	guint frontend;
	char* path;
	DVBDeviceGroup* devgroup;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	adapter = dvb_device_get_Adapter (dvb_scanner_get_Device (scanner));
	frontend = dvb_device_get_Frontend (dvb_scanner_get_Device (scanner));
	path = g_strdup_printf (DVB_CONSTANTS_DBUS_SCANNER_PATH, adapter, frontend);
	g_static_rec_mutex_lock (&self->priv->__lock_scanners);
	{
		gee_map_remove ((GeeMap*) self->priv->scanners, path, NULL);
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_scanners);
	g_debug ("Manager.vala:450: Destroying scanner for adapter %u, frontend %u (%s)", adapter, frontend, path);
	devgroup = dvb_manager_get_device_group_of_device (self, dvb_scanner_get_Device (scanner));
	if (devgroup != NULL) {
		DVBEPGScanner* epgscanner;
		epgscanner = _g_object_ref0 (dvb_device_group_get_epgscanner (devgroup));
		if (epgscanner != NULL) {
			dvb_epg_scanner_start (epgscanner);
		}
		_g_object_unref0 (epgscanner);
	}
	_g_free0 (path);
	_g_object_unref0 (devgroup);
}


static DVBDevice* dvb_manager_get_registered_device (DVBManager* self, guint adapter, guint frontend) {
	DVBDevice* result;
	DVBDevice* _result_;
	DVBDevice* fake_device;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	fake_device = dvb_device_new (adapter, frontend, FALSE);
	g_static_rec_mutex_lock (&self->priv->__lock_devices);
	{
		{
			GeeSet* _tmp0_;
			GeeIterator* _tmp1_;
			GeeIterator* _group_id_it;
			_group_id_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys ((GeeMap*) self->priv->devices))), _g_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				guint group_id;
				DVBDeviceGroup* devgroup;
				if (!gee_iterator_next (_group_id_it)) {
					break;
				}
				group_id = GPOINTER_TO_UINT (gee_iterator_get (_group_id_it));
				devgroup = (DVBDeviceGroup*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->devices, GUINT_TO_POINTER (group_id));
				if (dvb_device_group_contains (devgroup, fake_device)) {
					{
						GeeIterator* _device_it;
						_device_it = gee_iterable_iterator ((GeeIterable*) devgroup);
						while (TRUE) {
							DVBDevice* device;
							if (!gee_iterator_next (_device_it)) {
								break;
							}
							device = (DVBDevice*) gee_iterator_get (_device_it);
							if (dvb_device_equal (fake_device, device)) {
								DVBDevice* _tmp2_;
								_result_ = (_tmp2_ = _g_object_ref0 (device), _g_object_unref0 (_result_), _tmp2_);
								_g_object_unref0 (device);
								break;
							}
							_g_object_unref0 (device);
						}
						_g_object_unref0 (_device_it);
					}
				}
				_g_object_unref0 (devgroup);
			}
			_g_object_unref0 (_group_id_it);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_devices);
	result = _result_;
	_g_object_unref0 (fake_device);
	return result;
}


static DVBDeviceGroup* dvb_manager_get_device_group_of_device (DVBManager* self, DVBDevice* device) {
	DVBDeviceGroup* result;
	DVBDeviceGroup* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device != NULL, NULL);
	_result_ = NULL;
	g_static_rec_mutex_lock (&self->priv->__lock_devices);
	{
		{
			GeeSet* _tmp0_;
			GeeIterator* _tmp1_;
			GeeIterator* _group_id_it;
			_group_id_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys ((GeeMap*) self->priv->devices))), _g_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				guint group_id;
				DVBDeviceGroup* devgroup;
				if (!gee_iterator_next (_group_id_it)) {
					break;
				}
				group_id = GPOINTER_TO_UINT (gee_iterator_get (_group_id_it));
				devgroup = (DVBDeviceGroup*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->devices, GUINT_TO_POINTER (group_id));
				if (dvb_device_group_contains (devgroup, device)) {
					{
						GeeIterator* _grp_device_it;
						_grp_device_it = gee_iterable_iterator ((GeeIterable*) devgroup);
						while (TRUE) {
							DVBDevice* grp_device;
							if (!gee_iterator_next (_grp_device_it)) {
								break;
							}
							grp_device = (DVBDevice*) gee_iterator_get (_grp_device_it);
							if (dvb_device_equal (grp_device, device)) {
								DVBDeviceGroup* _tmp2_;
								_result_ = (_tmp2_ = _g_object_ref0 (devgroup), _g_object_unref0 (_result_), _tmp2_);
								_g_object_unref0 (grp_device);
								break;
							}
							_g_object_unref0 (grp_device);
						}
						_g_object_unref0 (_grp_device_it);
					}
				}
				_g_object_unref0 (devgroup);
			}
			_g_object_unref0 (_group_id_it);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_devices);
	result = _result_;
	return result;
}


static void dvb_manager_on_device_removed_from_group (DVBManager* self, DVBDeviceGroup* devgroup, guint adapter, guint frontend) {
	GError * _inner_error_;
	guint group_id;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devgroup != NULL);
	_inner_error_ = NULL;
	group_id = dvb_device_group_get_Id (devgroup);
	if (dvb_device_group_get_size (devgroup) == 0) {
		gboolean success = FALSE;
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			success = gee_map_remove ((GeeMap*) self->priv->devices, GUINT_TO_POINTER (group_id), NULL);
		}
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (success) {
			dvb_device_group_destroy (devgroup);
			{
				dvb_database_config_store_remove_device_group (dvb_factory_get_config_store (), devgroup, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						goto __catch33_dvb_database_sql_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				dvb_database_epg_store_remove_events_of_group (dvb_factory_get_epg_store (), dvb_device_group_get_Id (devgroup), &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						goto __catch33_dvb_database_sql_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				dvb_database_timers_store_remove_all_timers_from_device_group (dvb_factory_get_timers_store (), dvb_device_group_get_Id (devgroup), &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						goto __catch33_dvb_database_sql_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				g_signal_emit_by_name ((DVBIDBusManager*) self, "group-removed", group_id);
			}
			goto __finally33;
			__catch33_dvb_database_sql_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					g_critical ("Manager.vala:522: %s", e->message);
					_g_error_free0 (e);
				}
			}
			__finally33:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


DVBManager* dvb_manager_construct (GType object_type) {
	DVBManager * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBManager* dvb_manager_new (void) {
	return dvb_manager_construct (DVB_TYPE_MANAGER);
}


GeeCollection* dvb_manager_get_device_groups (DVBManager* self) {
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = gee_map_get_values ((GeeMap*) self->priv->devices);
	return result;
}


static GObject * dvb_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBManager * self;
	parent_class = G_OBJECT_CLASS (dvb_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_MANAGER (obj);
	{
		GeeHashMap* _tmp1_;
		GeeHashMap* _tmp2_;
		self->priv->scanners = (_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, DVB_TYPE_SCANNER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_str_hash, g_str_equal, g_direct_equal), _g_object_unref0 (self->priv->scanners), _tmp1_);
		self->priv->devices = (_tmp2_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_DEVICE_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->devices), _tmp2_);
		self->priv->device_group_counter = (guint) 0;
	}
	return obj;
}


void _dvb_manager_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_manager_introspect (DVBManager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Manager\">\n  <method name=\"GetScannerForDevice\">\n    <arg name=\"adapter\" type=\"u\" direction=\"in\"/>\n    <arg name=\"frontend\" type=\"u\" direction=\"in\"/>\n    <arg name=\"opath\" type=\"o\" direction=\"out\"/>\n    <arg name=\"dbusiface\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetRegisteredDeviceGroups\">\n    <arg name=\"result\" type=\"ao\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDeviceGroup\">\n    <arg name=\"group_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"opath\" type=\"o\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddDeviceToNewGroup\">\n    <arg name=\"adapter\" type=\"u\" direction=\"in\"/>\n    <arg name=\"frontend\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channels_conf\" type=\"s\" direction=\"in\"/>\n    <arg name=\"recordings_dir\" type=\"s\" direction=\"in\"/>\n    <arg name=\"name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetNameOfRegisteredDevice\">\n    <arg name=\"adapter\" type=\"u\" direction=\"in\"/>\n    <arg name=\"frontend\" type=\"u\" direction=\"in\"/>\n    <arg name=\"name\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDeviceGroupSize\">\n    <arg name=\"result\" type=\"i\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelGroups\">\n    <arg name=\"result\" type=\"a(is)\" direction=\"out\"/>\n  </method>\n  <method name=\"AddChannelGroup\">\n    <arg name=\"name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"channel_group_id\" type=\"i\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"RemoveChannelGroup\">\n    <arg name=\"channel_group_id\" type=\"i\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"GroupAdded\">\n    <arg name=\"group_id\" type=\"u\"/>\n  </signal>\n  <signal name=\"GroupRemoved\">\n    <arg name=\"group_id\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_manager_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_manager_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (dvb_id_bus_manager_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_manager_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_manager_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dvb_id_bus_manager_dbus_register_object (connection, path, object);
}


static void dvb_manager_class_init (DVBManagerClass * klass) {
	GStaticRecMutex _tmp0_ = {0};
	dvb_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_manager_get_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_MANAGER_DEVICE_GROUPS, g_param_spec_object ("device-groups", "device-groups", "device-groups", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_type_set_qdata (DVB_TYPE_MANAGER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_manager_dbus_vtable));
	dvb_manager_instance_mutex = (g_static_rec_mutex_init (&_tmp0_), _tmp0_);
}


static void dvb_manager_dvb_id_bus_manager_interface_init (DVBIDBusManagerIface * iface) {
	dvb_manager_dvb_id_bus_manager_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetScannerForDevice = dvb_manager_real_GetScannerForDevice;
	iface->GetDeviceGroup = dvb_manager_real_GetDeviceGroup;
	iface->GetRegisteredDeviceGroups = dvb_manager_real_GetRegisteredDeviceGroups;
	iface->AddDeviceToNewGroup = dvb_manager_real_AddDeviceToNewGroup;
	iface->GetNameOfRegisteredDevice = dvb_manager_real_GetNameOfRegisteredDevice;
	iface->GetDeviceGroupSize = dvb_manager_real_GetDeviceGroupSize;
	iface->GetChannelGroups = dvb_manager_real_GetChannelGroups;
	iface->AddChannelGroup = dvb_manager_real_AddChannelGroup;
	iface->RemoveChannelGroup = dvb_manager_real_RemoveChannelGroup;
}


static void dvb_manager_instance_init (DVBManager * self) {
	self->priv = DVB_MANAGER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_scanners);
	g_static_rec_mutex_init (&self->priv->__lock_devices);
}


static void dvb_manager_finalize (GObject* obj) {
	DVBManager * self;
	self = DVB_MANAGER (obj);
	g_static_rec_mutex_free (&self->priv->__lock_scanners);
	_g_object_unref0 (self->priv->scanners);
	g_static_rec_mutex_free (&self->priv->__lock_devices);
	_g_object_unref0 (self->priv->devices);
	G_OBJECT_CLASS (dvb_manager_parent_class)->finalize (obj);
}


GType dvb_manager_get_type (void) {
	static GType dvb_manager_type_id = 0;
	if (dvb_manager_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBManager), 0, (GInstanceInitFunc) dvb_manager_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_manager_info = { (GInterfaceInitFunc) dvb_manager_dvb_id_bus_manager_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBManager", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_manager_type_id, DVB_TYPE_ID_BUS_MANAGER, &dvb_id_bus_manager_info);
	}
	return dvb_manager_type_id;
}


static void dvb_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBManager * self;
	self = DVB_MANAGER (object);
	switch (property_id) {
		case DVB_MANAGER_DEVICE_GROUPS:
		g_value_set_object (value, dvb_manager_get_device_groups (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}




