/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/* gdm-info-provider-platform.c
 *
 * Copyright (C) 2007 David Zeuthen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <config.h>
#include <glib/gi18n.h>
#include "gdm-info-provider.h"

static char *
get_name (GdmDevice *device, gboolean get_short_name)
{
        char *name;

        name = g_strdup (_("Platform Device"));
        return name;
}

static gboolean 
get_provider_matches (GdmDevice *device)
{
        const char *subsys;

        subsys = gdm_device_get_property_string (device, "info.subsystem");
        if (subsys != NULL && g_ascii_strcasecmp (subsys, "platform") == 0)
                return TRUE;

        return FALSE;
}

static char *
get_icon_name (GdmDevice *device)
{
        // TODO: -platform instead
        return g_strdup ("gnome-device-manager-device-pci");
}

static char *
get_short_name (GdmDevice *device)
{
        return get_name (device, TRUE);
}

static char *
get_long_name (GdmDevice *device)
{
        return get_name (device, FALSE);
}

static char *
get_vendor (GdmDevice *device)
{
        return NULL;
}

static char *
get_product (GdmDevice *device)
{
        return g_strdup (gdm_device_get_property_string (device, "info.product"));
}

#define ADD_SUM(p, key, value)                                                       \
        do {                                                                         \
                if (value != NULL) {                                                 \
                        p = g_slist_append (p, g_strdup (key));                      \
                        p = g_slist_append (p, value);                               \
                }                                                                    \
        } while (FALSE)

static GSList *
get_summary (GdmDevice *device)
{
        const char *desc;
        GSList *p = NULL;

        desc = gdm_device_get_property_string (device, "platform.id");
        ADD_SUM (p, _("Description"), g_strdup (desc));
        ADD_SUM (p, _("Connection"), g_strdup (_("Platform specific device")));

        return p;
}

GdmInfoProviderIface gdm_info_provider_platform =
{
        .get_provider_matches = get_provider_matches,
        .get_icon_name        = get_icon_name,
        .get_short_name       = get_short_name,
        .get_long_name        = get_long_name,
        .get_vendor           = get_vendor,
        .get_product          = get_product,
        .get_summary          = get_summary,
};

