/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/* gdm-info-provider-iface.c
 *
 * Copyright (C) 2007 David Zeuthen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <config.h>
#include <glib/gi18n.h>
#include "gdm-info-provider-iface.h"

GdmInfoProviderTip *
gdm_info_provider_tip_new (int id, char *text, char *button_text)
{
        GdmInfoProviderTip *tip;
        tip = g_new0 (GdmInfoProviderTip, 1);
        tip->id = id;
        tip->text = g_strdup (text);
        tip->button_text = g_strdup (button_text);
        return tip;
}

void
gdm_info_provider_tip_unref (GdmInfoProviderTip *tip)
{
        g_free (tip->text);
        g_free (tip->button_text);
        g_free (tip);
}

