#!/bin/bash

##  Command line parameters:
##     ./run_regression_test.sh [-s] [-d] [test1] [test2] ...
##  Switches: The usual from Config.sh

. `dirname $0`/../../../scripts/CONFIG.sh

tmp_ext="${LOGNAME}_$$"
test_output='output'
ref_output='test.out'
diff_output=diff_$$
build_script='build'
test_script='test.cmd'
build_output=$testpwd/build.out.$tmp_ext
touch $build_output

## Add read_ali to the path
PATH=$testpwd/../standalone_obj:$PATH
CBROWSER_PATH=$testpwd/../sn/snsrc/snavigator/parsers/cpp
DBIMP_PATH=$testpwd/../sn/snsrc/snavigator/db
export PATH CBROWSER_PATH DBIMP_PATH

print_header "Src_Info tests"
parse_opts "$@"

if [ $clean == 1 ]; then
   rm -f build.out.*
   echo ""
   exit 0
fi

tests=${tests:-*}

check_dbimp
run_and_exit "make -C $testpwd/.. GNATMAKE='gnatmake -q'"

expected_failure="\ \
 cpp_ellipsis1                    \
 cpp_instance_variable            \
 cpp_localvar                     \
 cpp_macro                        \
 cpp_nested1                      \
 cpp_overloading1                 \
 cpp_overloading2                 \
 cpp_overloading3                 \
 cpp_ref_to_impl                  \
 cpp_separate_files               \
 cpp_separate_files1              \
 cpp_template1                    \
 cpp_template2                    \
 cpp_template3                    \
 cpp_typedef                      \
 cpp_union                        \
\ "


for current_dir in $tests
do
   cd $testpwd
   setup_traces

   current_dir=`basename $current_dir`
   if [ -d $current_dir -a $current_dir != '.' -a $current_dir != 'CVS' ]
   then
      if [ -f $current_dir/DO_NOT_RUN ]; then
         echo_with_status 0 "+++++++++  $current_dir (NOT RUN)"
      else
         copy_dir=${current_dir}_${tmp_ext}

         if [ -f $current_dir/$test_script ]; then
            cp -pr $current_dir $copy_dir
            cd $copy_dir
            find . -name .gpssnprj -exec rm -rf {} \; 2>/dev/null

            if [ -f $build_script ]; then
                echo "" >> $build_output
                echo "--  Building in $current_dir:" >> $build_output
                sh ./$build_script >> $build_output 2>&1
            fi
   
            if echo $expected_failure | fgrep " $current_dir " >/dev/null; then
               is_expected="(not ideal)"
            else
               is_expected=""
            fi

            local_diff="$diff"
            if [ $current_dir = "parse_all" ]; then
               local_diff="diff"
            fi
   
            $rlimit test_parse $test_script | tr -d '\r' > $test_output 2>&1 

            if [ -f $ref_output ]; then
               $local_diff $ref_output $test_output > $diff_output
            else
               cat $test_output > $diff_output
            fi

            if [ -s $diff_output ]; then
               echo_with_status 0 "+++++++++  $current_dir (FAILURE) $is_expected"
               if [ $showdiff = 1 ]; then
                  cat $diff_output
               fi
            else
               if [ $silent = 0 ]; then
                  echo_with_status 1 "---------  $current_dir $is_expected"
               fi
            fi

            cd .. 
            rm -rf $copy_dir
         else
            echo "$current_dir: $test_script missing, test skipped." > $build_output
         fi
      fi
   fi
done

echo_with_status 1 ""

rm $build_output
