------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License text and authors contact information could be found in oci.ads  --
------------------------------------------------------------------------------
--  $Id: test_lob.adb,v 1.5 2004/06/28 04:57:06 vagul Exp $

with
   Text_IO,
   OCI.Thick.Connections,
   OCI.Thick.Statements,
   OCI.Thick.Strings,
   OCI.Thick.Binds.Lob,
   OCI.Thick.Lobs;

with Ada.Exceptions;

procedure Test_Lob is
   use
      Text_IO,
      OCI.Thick;

   use
      Connections,
      Strings,
      Statements,
      Binds.Lob,
      Lobs;

   Connect : Connection := Logon ("scott/tiger");
   Loc : Lob := Create_Empty (Connect);
   Bind1, Bind2 : Bind_Lob;
   Buffout : String (1 .. 79) := (others => '_');
   Stmt1, Stmt2 : Statement;
   Offset : Lobs.Count := 1;
   Str : Variable;

   procedure Output_Clob;

   procedure Output_Clob is
      Last : Natural;
   begin
      loop
         Read (Loc, Offset, Buffout, Last);
         Put_Line (Buffout (1 .. Last));
         Buffout := (others => Buffout (Buffout'First));
         Offset := Offset + Lobs.Count (Last);
         exit when Last < Buffout'Last;
      end loop;
   end Output_Clob;


begin
   Stmt1 := Prepare (Connect,
      "begin " &
      "   DBMS_Lob.CreateTemporary (:Lob, True);" &
      "   for J in 1 .. 10 loop " &
      "      DBMS_LOB.WRITEAPPEND (:Lob, 4, lpad (J, 4));" &
      "   end loop; " &
      "end;");

   Stmt2 := Prepare (Connect,
      "begin "&
      "   for J in 1 .. 20 loop "&
      "      DBMS_Lob.WRITEAPPEND (:Lob, 3, LPad (J, 3));"&
      "   end loop; "&
      "end;");

   Put_Line ("Prepared");

   Bind (Stmt1, Bind1, Loc, ":Lob");
   Bind (Stmt2, Bind2, Loc, ":Lob");

   Put_Line ("Binded");

   if Is_Init (Loc) then
      Put_Line ("init");
   else
      Put_Line ("not initialized");
   end if;

   Execute (Stmt1);
   Put_Line ("Executed1");
   Output_Clob;

   if Is_Init (Loc) then
      Put_Line ("init " & Boolean'Image (Is_Temporary (Loc)));
   else
      Put_Line ("not initialized");
   end if;

   Execute (Stmt2);
   Output_Clob;

   Put_Line ("Executed2");

   Put_Line (Boolean'Image (Is_Init (Loc)));

   Free_Temporary (Loc);
   Put_Line ("end " & Boolean'Image (Is_Init (Loc)));
end Test_Lob;
