-------------------------------------------------------------------------------
--                                                                           --
--             GNat Ada Database Environment - GNADE                         --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/environment.adb,v $
--  Description     : handle the persistant environment variables
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/10/07 19:39:42 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;             use Ada.Strings.Unbounded;
with Ada.Text_IO;                       use Ada.Text_IO;
with Ada.Command_Line;                  use Ada.Command_Line;
with Ada.Exceptions;                    use Ada.Exceptions;

with GSQL_Types;                        use GSQL_Types;
with Project_File;                      use Project_File;

package body Environment is

   Version         : constant String := "$Id: environment.adb,v 1.3 2001/10/07 19:39:42 me Exp $";

   Prf_Environment : constant String := ".environment";

   ----------------
   -- Initialize --
   ----------------
   procedure Initialize is
   begin
      null;
   end Initialize;

   --------------
   -- Finalize --
   --------------
   procedure Finalize is
   begin
      null;
   end Finalize;

   ---------
   -- Get --
   ---------
   function Get(
      Name : in String ) return Natural is
      S    : Text_Buffer(1..10);
      Last : Positive;
   begin
      if not Section_Exists( Prf_Environment, Name ) then
         Add( Prf_Environment, Name, " 0" );
      end if;

      Project_File.Get(
         Prf_Environment,
         Name,
         S,
         Last );
      return Natural'Value(To_String(S(1)));
   end Get;

   ---------
   -- Set --
   ---------
   procedure Set(
      Name  : in String;
      Value : in Natural ) is
   begin
      Project_File.Update(
         Prf_Environment,
         Name,
         Natural'Image(Value) );
   end Set;

end Environment;

