/*
 *   gmorgan - a ryhthm station software
 *
     gmorgan.Chord.C  -  Chord Class header.
     Author: Robert Vogel

     This program is free software; you can redistribute it and/or modify
     it under the terms of version 2 of the GNU General Public License
     as published by the Free Software Foundation.

     This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License (version 2) for more details.

     You should have received a copy of the GNU General Public License
     (version2)
     along with this program; if not, write to the Free Software Foundation,
     Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/
#ifndef _RLV_CHORD_H
#define _RLV_CHORD_H	1
/*
 *       Chord functions by Robert Vogel 
 *
 *       */
using namespace std;
#include <vector>
#include <string>
#include <map>
void Midi2Note(int Midinote);

class CHORD

{
private:
   string CurrentChordsym;

public:

  CHORD();
 ~CHORD();
   MMAP_CHORD midi2chordtable;
// What Key now ?
   string CurrentKey;	
// C2M
   std::string root;
   std::string chordtype;
// next item is the inversion no.
   int rootno;
// integer root of the current chord.
   int iroot;
   int scale;
   std::vector<int> loadedvector;
   std::vector<int> MajorScale; 
   std::vector<int> MinorScale;
   std::vector<int> DominantScale;
   std::vector<int> DiminishedScale;
   std::vector<int> AugmentedScale;
   std::vector<int> CurrentScale;
   std::vector<int> CurrentHarmony;
   std::vector<int> MajorHarmony;
   std::vector<int> MinorHarmony;
   std::vector<int> DominantHarmony;

   std::vector<int> MidiVector;	
   int CurrentRoot;	
// To initialize the Chord Table. 
   int RinitChordtable;
   void loadChordtable(char *filename);
   int FindScale(std::string Chordtype);
   void LoadScales();
   string GetCurrentChordsym();
   void SetCurrentChordsym(string Chordsym);
   void GenerateChordTable();
   void DumpChordTable();
   void SetChordTable(string chordtyp, std::vector<int> midiintervals);
   string Midi2Chordsym(std::vector<int> Intervals);
// Given a chord symbol and an integer representing the desired type of chord, return a vector of midi notes. Voicing not included.
   std::vector<int> Chordsym2Midi(string Chordsym, int ChordMode);
   std::vector<int> Harmonize(int TopNote, int hmode);
// 
   std::vector<int> GetCurrentChordNotes();
};
#endif     /* chord.h */

