create table t_lfn (
  id integer primary key,
  name varchar(250) not null,
  ref integer default 0 not null
);
create unique index t_lfn_name on t_lfn(name);

create table t_lrc (
  id integer primary key,
  name varchar(250) not null,
  ref integer default 0 not null
);
create unique index t_lrc_name on t_lrc(name);

create table t_sender (
  id integer primary key,
  name varchar(250) not null,
  ref integer default 0 not null
);
create unique index t_sender_name on t_sender(name);

create table t_map (
  lfn_id integer not null references t_lfn(id),
  lrc_id integer not null references t_lrc(id),
  sender_id integer not null references t_sender(id),
  updatetime timestamp not null
);
create unique index pk_map on t_map(lfn_id, lrc_id, sender_id);
create index t_map_lrc_id on t_map(lrc_id);
create index t_map_sender_id on t_map(sender_id);
create index t_map_updatetime on t_map(updatetime);

create table t_rli (
  id integer primary key,
  flags integer default 0 not null,
  name varchar(250) not null
);
create unique index t_rli_name on t_rli(name);

create table t_rlipartition (
  rli_id integer not null references t_rli(id),
  pattern varchar(250) not null
);
create unique index pk_rlipartition on t_rlipartition(rli_id, pattern);
create index t_rlipartition_rli_id on t_rlipartition(rli_id);
create index t_rlipartition_pattern on t_rlipartition(pattern);
