/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * rdb_test.c
 */

static char *rcsid = "$Header: /home/globdev/CVS/globus-packages/nexus/source/nexus/rdb_test.c,v 1.6 2006/01/19 05:57:06 mlink Exp $";

#include <stdio.h>
#include "rdb.h"

/*
 * main()
 */
int main(int argc, char *argv[])
{
    nexus_bool_t done = NEXUS_FALSE;
    nexus_list_t *names, *cur_name;
    char name[1024];
    char key[1024];
    char *value;
    int count;
    
    resource_database_init(&argc, &argv);

    printf("Testing resource_database_get_names()...\n");
    printf("Enter file to get names from: ");
    fflush(stdout);
    scanf("%s", name);
    {
        names = resource_database_get_names(name);
        for (cur_name = names; cur_name; cur_name = cur_name->next)
        {
            printf("Name %d: %s\n", count++, (char *)cur_name->value);
        }
        printf("Names done.\n\n\n");
    }

    printf("Testing resource_database_lookup()...\n");
    while (!done)
    {
	printf("Enter name and key: ");
	fflush(stdout);
	if (scanf("%s %s", name, key) == 2)
	{
	    value = resource_database_lookup(name, key);
	    if (value)
	    {
		printf("Lookup of \"%s\" and \"%s\" found \"%s\"\n",
		       name, key, value);
	    }
	    else
	    {
		printf("Lookup of \"%s\" and \"%s\" failed.\n",
		       name, key);
	    }
	}
	else
	{
	    done = NEXUS_TRUE;
	}
    }
    
    resource_database_shutdown();
    
} /* main() */
