/*
 * Portions of this file Copyright 1999-2005 University of Chicago
 * Portions of this file Copyright 1999-2005 The University of Southern California.
 *
 * This file or a portion of this file is licensed under the
 * terms of the Globus Toolkit Public License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * If you redistribute this file, with or without
 * modifications, you must include this notice in the file.
 */


#ifndef GLOBUS_DUROC_CONTROL_SUBJOB_H
#define GLOBUS_DUROC_CONTROL_SUBJOB_H

#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif

 
#include "globus_common.h"
#include "nexus.h"

#include "globus_duroc_control.h"

EXTERN_C_BEGIN


typedef enum {
  GLOBUS_DUROC_START_STRICT,
  GLOBUS_DUROC_START_LOOSE,
  GLOBUS_DUROC_START_NONE 
} globus_duroc_start_method_t;

typedef enum {
  GLOBUS_DUROC_COMMS_BLOCKING,
  GLOBUS_DUROC_COMMS_NONBLOCKING,
  GLOBUS_DUROC_COMMS_NONE
} globus_duroc_comms_method_t;

typedef struct globus_duroc_subjob_s {
  /* per-subjob data */
  volatile int ref_count;
  nexus_mutex_t mutex;
  nexus_cond_t cond;

  volatile globus_duroc_start_method_t start_type;
  volatile globus_duroc_comms_method_t comms_type;

  const char * volatile contact;  /* subjob allocator-assigned job contact string */
  const char * volatile label;    /* user-assigned subjob label */
  volatile int serialno;         /* duroc-assigned serial number */

  volatile int state;            /* subjob state value */
  volatile int errorcode;        /* subjob failure errorcode (from callbacks) */

  volatile globus_bool_t checked_in;
  volatile globus_bool_t told_to_run;

  nexus_startpoint_t command_sp;
} globus_duroc_subjob_t;

EXTERN_C_END

#include "job_monitor.h"

EXTERN_C_BEGIN

extern globus_result_t
globus_duroc_control_i_subjob_init (globus_duroc_control_t     *controlp,
			     globus_duroc_job_monitor_t *job_monitorp,
			     globus_duroc_subjob_t      *subjobp,
			     char                *subjob_label,
			     globus_duroc_start_method_t starttype,
			     globus_duroc_comms_method_t commstype);

extern int 
globus_duroc_control_i_subjob_register_contact (globus_duroc_control_t      *controlp,
					 globus_duroc_job_monitor_t *job_monitorp,
					 globus_duroc_subjob_t      *subjobp,
					 const char          *contact);
extern void 
globus_duroc_control_i_subjob_state_update (globus_duroc_control_t * controlp,
				     globus_duroc_job_monitor_t *job_monitorp,
				     globus_duroc_subjob_t * subjobp,
				     int state,
				     int errorcode);

extern void 
globus_duroc_control_i_subjob_destroy (globus_duroc_control_t      *controlp,
					    globus_duroc_job_monitor_t *job_monitorp,
					    globus_duroc_subjob_t      **subjobpp);



EXTERN_C_END

#endif /* GLOBUS_DUROC_CONTROL_SUBJOB_H */

