/*
 * Portions of this file Copyright 1999-2005 University of Chicago
 * Portions of this file Copyright 1999-2005 The University of Southern California.
 *
 * This file or a portion of this file is licensed under the
 * terms of the Globus Toolkit Public License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * If you redistribute this file, with or without
 * modifications, you must include this notice in the file.
 */


#ifndef GLOBUS_DUROC_CONTROL_JOB_MONITOR_H
#define GLOBUS_DUROC_CONTROL_JOB_MONITOR_H

#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif

#include "globus_duct_control.h"
#include "globus_duroc_control.h"
#include "globus_common.h"
#include "nexus.h"


EXTERN_C_BEGIN


typedef struct globus_duroc_job_monitor_s {
  /* per-job data */
  nexus_mutex_t mutex;
  nexus_cond_t cond;

  globus_duct_control_t duct_control;

  volatile int serialno;
  volatile char * volatile label;
  volatile char * volatile job_contact;

  volatile int ref_count;

  globus_hashtable_t subjob_label_hasht;    /* label -> serialno */
  globus_hashtable_t subjob_globus_gram_hasht;     /* gram  -> serialno */
  globus_hashtable_t subjob_serialno_hasht; /* serialno -> *globus_duroc_subjob_t */

  volatile int next_free_serialno;

  globus_list_t * volatile subjobs;   /* the master subjob set */

  volatile globus_bool_t          release_barrier;
  volatile globus_bool_t          barrier_released;
  volatile globus_bool_t          job_canceled;

  volatile globus_bool_t          wait_for_checkins;
} globus_duroc_job_monitor_t;

extern int
globus_duroc_control_i_job_monitor_init (
				 globus_duroc_control_t     * controlp,
				 globus_duroc_job_monitor_t * job_monitorp);

extern int 
globus_duroc_control_i_job_monitor_make_subjob_no (
			   globus_duroc_job_monitor_t *job_monitorp);

extern globus_result_t
globus_duroc_control_i_job_monitor_link_subjob (
				globus_duroc_job_monitor_t * job_monitorp,
				globus_duroc_subjob_t      * subjobp,
				const char          * label);

extern void
globus_duroc_control_i_job_monitor_unlink_subjob (globus_duroc_job_monitor_t *job_monitorp,
					   globus_duroc_subjob_t * subjobp);

extern int
globus_duroc_control_i_job_monitor_link_gram (globus_duroc_job_monitor_t * job_monitorp,
				       const char * contact,
				       int serialno);

extern void
globus_duroc_control_i_job_monitor_unlink_gram (globus_duroc_job_monitor_t *job_monitorp,
					 const char * contact);

extern void
globus_duroc_control_i_job_monitor_destroy (globus_duroc_control_t     * controlp,
				     globus_duroc_job_monitor_t * job_monitorp);

extern int 
globus_duroc_control_i_subjob_lookup_by_label (globus_duroc_job_monitor_t *job_monitorp,
					const char          *label,
					globus_duroc_subjob_t     **subjobpp);

extern int 
globus_duroc_control_i_subjob_lookup_by_gram (globus_duroc_job_monitor_t *job_monitorp,
				       const char          *globus_gram_contact,
				       globus_duroc_subjob_t     **subjobpp);

extern int
globus_duroc_control_i_subjob_lookup_by_serialno (globus_duroc_job_monitor_t *job_monitorp,
					   int                  serialno,
					   globus_duroc_subjob_t     **subjobpp);

extern void
globus_duroc_control_i_subjob_release (globus_duroc_control_t *controlp,
				globus_duroc_job_monitor_t *job_monitorp,
				globus_duroc_subjob_t **subjobpp);

extern void 
globus_duroc_control_i_job_monitor_poll (globus_duroc_control_t * controlp,
				  globus_duroc_job_monitor_t * job_monitorp);

extern int
globus_duroc_control_i_job_monitor_barrier_release (
			     globus_duroc_control_t     * controlp,
			     globus_duroc_job_monitor_t * job_monitorp,
			     globus_bool_t         wait_for_checkins);

extern int
globus_duroc_control_i_job_cancel (globus_duroc_control_t     * controlp,
			    globus_duroc_job_monitor_t * job_monitorp);

extern int
globus_duroc_control_i_subjob_states (globus_duroc_control_t * controlp,
			       globus_duroc_job_monitor_t * job_monitorp,
			       int  * subjob_countp,
			       int ** subjob_statesp,
			       char *** subjob_labelsp);

EXTERN_C_END

#endif /* GLOBUS_DUROC_CONTROL_JOB_MONITOR_H */




