/*
 * Portions of this file Copyright 1999-2005 University of Chicago
 * Portions of this file Copyright 1999-2005 The University of Southern California.
 *
 * This file or a portion of this file is licensed under the
 * terms of the Globus Toolkit Public License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * If you redistribute this file, with or without
 * modifications, you must include this notice in the file.
 */


#ifndef NXBUFF_H
#define NXBUFF_H

/********************************************************************
 *
 * This file defines the Nexus / GRUB buffer manipulators
 *
 ********************************************************************/

#include <unistd.h>

#include "globus_common.h"
#include "nexus.h"			/* for buffer ops */

int nxbuff_put_stringval (nexus_buffer_t *buff, const char *string);
int nxbuff_get_stringval (nexus_buffer_t *buff, char **string);
void nxbuff_free_stringval (char *string);

int nxbuff_put_byte (nexus_buffer_t *buff, globus_byte_t b);
int nxbuff_get_byte (nexus_buffer_t *buff, globus_byte_t *b);

int nxbuff_put_int (nexus_buffer_t *buff, int i);
int nxbuff_get_int (nexus_buffer_t *buff, int *i);

int nxbuff_put_float (nexus_buffer_t *buff, float f);
int nxbuff_get_float (nexus_buffer_t *buff, float *f);

int nxbuff_put_startpoint_transfer (nexus_buffer_t *buff, 
				    nexus_startpoint_t *sp);
int nxbuff_get_startpoint (nexus_buffer_t *buff, 
			   nexus_startpoint_t *sp);

#endif /* NXBUFF_H */

