/*
 * Portions of this file Copyright 1999-2005 University of Chicago
 * Portions of this file Copyright 1999-2005 The University of Southern California.
 *
 * This file or a portion of this file is licensed under the
 * terms of the Globus Toolkit Public License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * If you redistribute this file, with or without
 * modifications, you must include this notice in the file.
 */


#ifndef GLOBUS_DUROC_COMMON_H_PUBLIC
#define GLOBUS_DUROC_COMMON_H_PUBLIC

#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif
 
EXTERN_C_BEGIN

#define GLOBUS_DUROC_CHECKIN_PROTOCOL_VERSION     601

#define GLOBUS_DUROC_SUCCESS                        0
#define GLOBUS_DUROC_ERROR_INVALID_REQUEST          1
#define GLOBUS_DUROC_ERROR_INVALID_PARAMETER        2
#define GLOBUS_DUROC_ERROR_DUCT_FAILED              3
#define GLOBUS_DUROC_ERROR_INIT_FAILED              4
#define GLOBUS_DUROC_ERROR_UNKNOWN_LABEL            5
#define GLOBUS_DUROC_ERROR_NEXUS_FAILED             6
#define GLOBUS_DUROC_ERROR_MALLOC_FAILED            7
#define GLOBUS_DUROC_ERROR_INTERNAL_FAILURE         8
#define GLOBUS_DUROC_ERROR_INVALID_RSL              9
#define GLOBUS_DUROC_ERROR_INVALID_MULTIREQ        10
#define GLOBUS_DUROC_ERROR_GRAM_FAILED             11
#define GLOBUS_DUROC_ERROR_INVALID_MANAGER_CONTACT 12
#define GLOBUS_DUROC_ERROR_ALREADY_RELEASED        13
#define GLOBUS_DUROC_ERROR_ALREADY_CANCELLED       14
#define GLOBUS_DUROC_ERROR_BAD_START_TYPE          15
#define GLOBUS_DUROC_ERROR_BAD_COMMS_TYPE          16
#define GLOBUS_DUROC_ERROR_NOT_INITIALIZED         17
#define GLOBUS_DUROC_ERROR_INVALID_OPERATION       18
#define GLOBUS_DUROC_ERROR_DUPLICATE_SUBJOB_LABEL  19
#define GLOBUS_DUROC_ERROR_PROTOCOL_VERSION_MISMATCH 20
#define GLOBUS_DUROC_ERROR_INVALID_CHECKIN         21

#define GLOBUS_DUROC_ERROR_GRAM_ERROR_BASE         50

extern const char * 
globus_duroc_error_string (int error_code);

extern int
globus_duroc_error_is_gram_client_error (int error_code);

extern int
globus_duroc_error_get_gram_client_error (int error_code);

EXTERN_C_END

#endif /* GLOBUS_DUROC_COMMON_H_PUBLIC */

