/* gLife - An Artificial Life implementation using GNOME
 *
 * Copyright (C) 1999 Ali Abdin <aliabdin@aucegypt.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include "config.h"

#include <gnome.h>
#include <glade/glade.h>

#include "glife.h"
#include "data.h"


void terrinfo_cb (GtkWidget *widget, gpointer data);
void animinfo_cb (GtkWidget *widget, gpointer data);
void glife_log (gchar *message);

static void
log_to_textbox (gchar *message) {
	GtkWidget *w;

	w = glade_xml_get_widget (glife.xml, "textbox");
	gtk_text_insert (GTK_TEXT(w), NULL, NULL, NULL,
			message, -1);
}

/* static void
log_to_file (gchar *message, gchar *path) {
} */

void
glife_log (gchar *message) {
	log_to_textbox (message);
}

void
terrinfo_cb (GtkWidget *widget, gpointer data) {
	GtkWidget *w;
	gint posx, posy;
	gchar *message;

	w = glade_xml_get_widget (glife.xml, "xspininfo");
	posx = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));
	
	w = glade_xml_get_widget (glife.xml, "yspininfo");
	posy = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

	
	if (terrain[posx-1][posy-1].foodamt >= 0) {
		message = g_strdup_printf (_("Terrain info on %d,%d:\n"),posx,posy);
		glife_log (message);
		g_free (message);

		if (terrain[posx-1][posy-1].occupied)
			glife_log ("   There is an animal at this spot.\n");
	
		message = g_strdup_printf (_("   Food Amount: %d\n"), terrain[posx-1][posy-1].foodamt);
		glife_log (message);
		g_free (message);
		

		message = g_strdup_printf (_("   Food reproduction rate: %d\n"),
			   	           terrain[posx-1][posy-1].foodrep);
		glife_log (message);
		g_free (message);
		
	}
	else
		glife_log (_("The simulation is not running.\n"));
}

void
animinfo_cb (GtkWidget *widget, gpointer data) {
	GtkWidget *w;
	gint posx, posy;
	gchar *message;
	AnimalType *tmpanim = NULL;

	w = glade_xml_get_widget (glife.xml, "xspininfo");
	posx = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));
	
	w = glade_xml_get_widget (glife.xml, "yspininfo");
	posy = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (w));

	tmpanim = animal_at (posx, posy);

	if (tmpanim) {
		message = g_strdup_printf (_("Animal info on %d,%d:\n"), posx, posy);
		glife_log (message);
		g_free (message);

		message = g_strdup_printf (_("   Sex: %c\n"), tmpanim->sex);
		glife_log (message);
		g_free (message);

		message = g_strdup_printf (_("   Age: %d\n"), tmpanim->age);
		glife_log (message);
		g_free (message);
		
		message = g_strdup_printf (_("   Vision: %d\n"), tmpanim->vision);
		glife_log (message);
		g_free (message);
		
		message = g_strdup_printf (_("   Speed: %d\n"), tmpanim->speed);
		glife_log (message);
		g_free (message);

		message = g_strdup_printf (_("   Food Metabolism: %d\n"), tmpanim->metafood);
		glife_log (message);
		g_free (message);

		
		message = g_strdup_printf (_("   Food Storage: %d\n"), tmpanim->storefood);
		glife_log (message);
		g_free (message);
	}
	else
		glife_log (_("No animal at that spot.\n"));	
}
	
	
