// $Id: menu.cc,v 1.35 2002/06/24 15:34:52 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"
#include "menuitem.hh"
#include <typeinfo>

class Gtk_Menu : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Menu();
	virtual void AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
	{}
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	virtual void CreatePointer_depending(const Widget &w,CxxFile &f) const;
};

static Gtk_Menu Gtk_Menu;

const std::string Gtk_Menu::TypeName(const Widget &w) const
{  return GtkPrefix()+"Menu";
}

const std::string Gtk_Menu::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"menu.h";
}

Gtk_Menu::Gtk_Menu()
{  Writer["GtkMenu"]=this;
}

void Gtk_Menu::CreatePointer_depending(const Widget &w,CxxFile &f) const
{  if (!Configuration.gnome_support) 
   {  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
         PushMenuElem(*i, f, Configuration.InstanceName(w.Name())+"->");
   }
   Parent::CreatePointer_depending(w,f);
}

// this should go into a different class - but which ?
void Gtk_Container::PushMenuElem(const Widget &w,CxxFile &f, 
				 const std::string &instance) const
{ try
  { const Gtk_MenuItem &wr=dynamic_cast<const Gtk_MenuItem &>(LookupWriter(w));
    std::string childInstance=Configuration.InstanceName(w.Name()) + "->";

    f.Declaration();		// *** Necessary to get state right.
    f.FunctionName() << instance << "items().push_back";
    f.FunctionArg();
    wr.MenuElemCreation(w,f);
    
    f.Statement() << Configuration.InstanceName(w.Name());
    f.Assignment() << "(" << wr.TypeName(w) << " *)";
    if (Configuration.gtkmm_version>=Pkg_Version(1,3,17)) f << '&';
    f << instance << "items().back()";

    // is this really needed?
//    wr.Configure(w,f,Configuration.InstanceName(w.Name())+"->");
  }
  catch (std::bad_cast &e) {
    f.Statement() << instance << "append(" << Reference(w) << ')';
  }
}
