// $Id: combobox.cc,v 1.2 2004/05/24 16:25:35 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2004  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "bin.hh"

class Gtk_ComboBox : public Gtk_Bin
{public:
	typedef Gtk_Bin Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_ComboBox(bool base_class_init=true);
	// we have to override Gtk_Bin's constructor
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	// 2do: Model
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool default_can_focus() const
	{  return true; }
};

#include "../strsep.h"

static Gtk_ComboBox Gtk_ComboBox(false);

const std::string Gtk_ComboBox::TypeName(const Widget &w) const
{  return GtkPrefix()+"ComboBox";
}

const std::string Gtk_ComboBox::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"combobox.h";
}

Gtk_ComboBox::Gtk_ComboBox(bool base_class_init)
{  if (!base_class_init) Writer["GtkComboBox"]=this;
}

void Gtk_ComboBox::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   // Model erzeugen ??? dann Zeilen anhngen ...
   // set_active(idx oder tm::iter);
   // get_model
}

class Gtk_ComboBoxEntry : public Gtk_ComboBox
{public:
	typedef Gtk_ComboBox Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_ComboBoxEntry(bool base_class_init=true);
};

static Gtk_ComboBoxEntry Gtk_ComboBoxEntry(false);

const std::string Gtk_ComboBoxEntry::TypeName(const Widget &w) const
{  return GtkPrefix()+"ComboBoxEntry";
}

const std::string Gtk_ComboBoxEntry::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"comboboxentry.h";
}

Gtk_ComboBoxEntry::Gtk_ComboBoxEntry(bool base_class_init)
{  if (!base_class_init) Writer["GtkComboBoxEntry"]=this;
}

