// $Id: accelgroup.cc,v 1.7 2002/05/14 08:25:44 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "WriterBase.hh"

class Gtk_AccelGroup : public WriterBase
{public:
	typedef WriterBase Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_AccelGroup(bool base_class_init=true);
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const
	{  f.FunctionArg(); }
        virtual void CreatePointer(const Widget &, CxxFile &) const;
};

static Gtk_AccelGroup Gtk_AccelGroup(false);

const std::string Gtk_AccelGroup::TypeName(const Widget &w) const
{  return GtkPrefix()+"AccelGroup";
}

const std::string Gtk_AccelGroup::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"accelgroup.h";
}

Gtk_AccelGroup::Gtk_AccelGroup(bool base_class_init)
{  if (!base_class_init) Writer["GtkAccelGroup"]=this;
}

void Gtk_AccelGroup::CreatePointer(const Widget &w, CxxFile &f) const
{  if (w.getProperty("cxx_visibility","private")=="private") // && CanBeManaged
      f.Declaration() << TypeName(w) << " *";
   else
      f.Statement();
   f << Configuration.InstanceName(w.Name());
   f.Assignment();
   f.FunctionName() << TypeName(w) << "::create";
   ConstructionArgs(w,f);
   f.EndLine();
}
