// $Id: Cxx_Fileset.hh,v 1.19 2002/10/21 08:44:13 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <Tag.hh>
#include <WidgetFile.hh>
#include "writers/WriterBase.hh"
#include <list>

class Cxx_Fileset
{	WidgetFile h,gh,gc,c,bc;
	const Tag &top;
	class Cxx &toplevel;
	typedef std::list<std::string> ProcedureDeclList_t;
	ProcedureDeclList_t ProcedureDeclList;
	typedef std::list<std::string> RadioGroupList_t;
	static RadioGroupList_t RadioGroupList;
	
private:
	bool ProcedureDeclared(const std::string &name) const;
	void ProcedureDeclared(const std::string &name,bool tRuE);
	
	void WriteClasses(const Widget &w);
	void DoIncludes(const Widget &w);
	
	void DeclareSignalHandler(const WriterBase &wr, const Widget &w, const Widget &top, bool container= false, bool emit_virtual=false);
	void DefineSignalHandler(const WriterBase &wr, const Widget &w, const Widget &top);
	void ConnectSignalHandler(const WriterBase &wr, const Widget &w, const Widget &top, const std::string &instance);
	void WriteHeader(WidgetFile &f,File_type tp);
	void WriteFooter(WidgetFile &f,File_type tp);
	void GenerateMapDefine(const WriterBase &wr, const Widget &w);
	void AddToMap(const Widget &w, const std::string &pointer);
	
	void ReregisterLocal(const Widget &w) const;
	
	static void ClearRadioGroups();
public:
	Cxx_Fileset(const Tag &t, Cxx &_toplevel);
	void WriteFiles(bool toplevel=false);
	static bool NeedToDeclareRadioGroup(const std::string &Name);
};

