/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "gtktreecontainer.h"

#include "glrr-glib.h"
#include "glrr-gobject.h"
#include "glrr-gtk.h"



static void builtin_module_init (void);

static gpointer create_panel_interface_prerequisites     (gpointer data,
							  gpointer func_data,
							  gpointer invoke_data);
static gpointer create_panel_interface_implemented_types (gpointer data,
							  gpointer func_data,
							  gpointer invoke_data);



void
g_inspector_builtin_register_module_panel_interface (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-panel-interface";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-panel-interface-prerequisites",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_INTERFACE,
				  create_panel_interface_prerequisites,
				  NULL);
  g_inspector_register_procedure ("create-panel-interface-implemented-types",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_INTERFACE,
				  create_panel_interface_implemented_types,
				  NULL);
}



/*
 *
 */

enum
{
  COLUMN_0,

  COLUMN_GTYPE,

  NUM_COLUMNS
};

static GInspectorElementListColumnInfo columns_prerequisites[NUM_COLUMNS] =
{
  G_INSPECTOR_ELEMENT_LIST_COLUMN_INFO_0,

  { COLUMN_GTYPE,	  "GType",		"_gtype",		"gtype" },
};

static GInspectorElementListColumnInfo columns_implemented[NUM_COLUMNS] =
{
  G_INSPECTOR_ELEMENT_LIST_COLUMN_INFO_0,

  { COLUMN_GTYPE,	  "GType",		"_gtype",		"gtype" },
};





static void
append_row_prerequisites (GtkListStore *list_store,
			GType         type)
{
  GtkTreeIter tree_iter;

  gtk_list_store_append (list_store, &tree_iter);

  g_inspector_element_list_set_row_element (list_store, &tree_iter,
					    G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
					    GTYPE_TO_POINTER (type));

  gtk_list_store_set (list_store, &tree_iter,
		      COLUMN_GTYPE, type,
		      -1);
}

static void
create_list_prerequisites (GtkListStore *list_store,
			   GType         interface_type)
{
  GType *prerequisites;
  guint n_prerequisites;
  guint i;


  g_return_if_fail (G_TYPE_IS_INTERFACE (interface_type));


  prerequisites = g_type_interface_prerequisites (interface_type,
						  &n_prerequisites);

  for (i = 0; i < n_prerequisites; ++i)
    {
      append_row_prerequisites (list_store,
				prerequisites[i]);
    }

  if (prerequisites != NULL)
    {
      g_free (prerequisites);
    }
}

static void
update_prerequisites (GInspectorElementList *element_list,
		    gpointer               user_data)
{
  GInspectorPanel *panel;
  GType type;
  GtkListStore *list_store;

  panel = G_INSPECTOR_PANEL (user_data);

  type = GPOINTER_TO_TYPE (panel->element);
  list_store = GTK_LIST_STORE (gtk_tree_view_get_model (GTK_TREE_VIEW (element_list)));

  gtk_list_store_clear (list_store);

  create_list_prerequisites (list_store, type);
}

static gpointer
create_panel_interface_prerequisites (gpointer data,
				      gpointer func_data,
				      gpointer invoke_data)
{
  GType type;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *scrolled_window;
  GtkWidget *element_list;

  type = GPOINTER_TO_TYPE (data);


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			  NULL);
    G_INSPECTOR_PANEL (panel)->element_type = G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS;
    G_INSPECTOR_PANEL (panel)->element = GTYPE_TO_POINTER (type);
    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Prerequisites");
    gtk_container_add (GTK_CONTAINER (panel), frame);
  }

  {
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_container_add (GTK_CONTAINER (frame), scrolled_window);
  }

  {
    element_list = g_inspector_element_list_new (columns_prerequisites,
						 G_N_ELEMENTS (columns_prerequisites));

    g_signal_connect (element_list,
		      "update",
		      G_CALLBACK (update_prerequisites),
		      panel);

    gtk_container_add (GTK_CONTAINER (scrolled_window),
		       element_list);

    g_inspector_panel_attach_element_list (G_INSPECTOR_PANEL (panel),
					   G_INSPECTOR_ELEMENT_LIST (element_list));
  }


  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}


static void
append_row_implemented (GtkListStore *list_store,
			GType         type)
{
  GtkTreeIter tree_iter;

  gtk_list_store_append (list_store, &tree_iter);

  g_inspector_element_list_set_row_element (list_store, &tree_iter,
					    G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
					    GTYPE_TO_POINTER (type));

  gtk_list_store_set (list_store, &tree_iter,
		      COLUMN_GTYPE, type,
		      -1);
}

static void
create_list_implemented (GtkListStore *list_store,
			 GType         interface_type)
{
  GList *type_list;
  GList *tmp;
  GType  tmp_type;
  GTypeClass *tmp_type_class;
  GTypeClass *tmp_interface;


  g_return_if_fail (G_TYPE_IS_INTERFACE (interface_type));


  type_list = g_type_get_type_list ();

  tmp = type_list;
  while (tmp != NULL)
    {
      tmp_type = (GType)tmp->data;
      tmp = g_list_next (tmp);

      if (G_TYPE_IS_INSTANTIATABLE (tmp_type))
	{
	  tmp_type_class = g_type_class_ref (tmp_type);

	  tmp_interface = g_type_interface_peek (tmp_type_class,
						 interface_type);

	  if (tmp_interface != NULL)
	    {
	      append_row_implemented (list_store, tmp_type);
	    }

	  g_type_class_unref (tmp_type_class);
	}
    }

  g_list_free (type_list);
}

static void
update_implemented (GInspectorElementList *element_list,
		    gpointer               user_data)
{
  GInspectorPanel *panel;
  GType type;
  GtkListStore *list_store;

  panel = G_INSPECTOR_PANEL (user_data);

  type = GPOINTER_TO_TYPE (panel->element);
  list_store = GTK_LIST_STORE (gtk_tree_view_get_model (GTK_TREE_VIEW (element_list)));

  gtk_list_store_clear (list_store);

  create_list_implemented (list_store, type);
}

static gpointer
create_panel_interface_implemented_types (gpointer data,
					  gpointer func_data,
					  gpointer invoke_data)
{
  GType type;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *scrolled_window;
  GtkWidget *element_list;

  type = GPOINTER_TO_TYPE (data);


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			  NULL);
    G_INSPECTOR_PANEL (panel)->element_type = G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS;
    G_INSPECTOR_PANEL (panel)->element = GTYPE_TO_POINTER (type);
    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Implemented GTypes");
    gtk_container_add (GTK_CONTAINER (panel), frame);
  }

  {
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_container_add (GTK_CONTAINER (frame), scrolled_window);
  }

  {
    element_list = g_inspector_element_list_new (columns_implemented,
						 G_N_ELEMENTS (columns_implemented));

    g_signal_connect (element_list,
		      "update",
		      G_CALLBACK (update_implemented),
		      panel);

    gtk_container_add (GTK_CONTAINER (scrolled_window),
		       element_list);

    g_inspector_panel_attach_element_list (G_INSPECTOR_PANEL (panel),
					   G_INSPECTOR_ELEMENT_LIST (element_list));
  }


  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}
