/*
 *  
 *  $Id: imprimevistasimple.h $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/controllers/ipacscontroller.h>
#include <visualizator/vistas/vista2d.h>
#include <export/contracts/iimageexportcontract.h>

class vtkImageReslice;
class vtkScalarsToColors;
class GVistaCompleja;
class vtkImageMapToRGBA;
namespace GNKVisualizator {
	class SimpleViewExportDelegate: public GNC::GCS::IImageExportDelegate
	{
	public:
		SimpleViewExportDelegate(GNC::GCS::IImageExportContract* exportContract, GVistaCompleja* pView);
		~SimpleViewExportDelegate();

		GNC::GCS::IVista* GetView();

		virtual void GetCurrentImage(ImageType::Pointer& ptrImage, TValorationMaps& mapasValoracion, bool conWidgets, const GNC::GCS::Vector& size);
		virtual void GetImage(ImageType::Pointer& ptrImage, int index, TValorationMaps& mapasValoracion, bool conWidgets, const GNC::GCS::Vector& size);
		virtual int GetNumberOfSlices();
		virtual TValorationMaps GetValorationMaps();

		
		GVistaCompleja* m_pView;
		vtkImageMapToRGBA* ImageMap;
	};

	class SimpleViewExportContractDelegate: public GNC::GCS::IImageExportContract
	{
	public:
		SimpleViewExportContractDelegate(GVistaCompleja* pView);
		~SimpleViewExportContractDelegate();

		virtual GNC::GCS::Ptr<GNC::GCS::IImageExportDelegate> GetNewExportDelegate();
		GNC::GCS::IVista* GetView();
		virtual bool CanBeExported();

	protected:
		GVistaCompleja* m_pView;
	};
}
