/*
*  
*  $Id: previewpaneloftal.cpp $
*  Ginkgo CADx Project
*
*  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/

#include <wx/dnd.h>
#include <main/gui/previewpanel/previewpanelmodel.h>
#include <main/gui/previewpanel/previewpanel.h>
#include <api/controllers/ihistorycontroller.h>
#include <visualizator/wxvtk/gvistacompleja.h>
#include <api/dicom/dcmdictionary.h>
#include <api/internationalization/internationalization.h>

#include "previewpanelvisualizator.h"

namespace GNKVisualizator {
	namespace GUI {
		//////////////////////BEGIN D&D/////////////////////////
		wxDnDPreviewPanelVisualizator::wxDnDPreviewPanelVisualizator(long seriesPk)
#if defined(_WINDOWS)
			: wxDataObjectSimple(wxDF_PRIVATE)
#else
			: wxDataObjectSimple(wxDF_UNICODETEXT)
#endif
		{
			SeriesPk = seriesPk;
		}
		long wxDnDPreviewPanelVisualizator::GetSeriesPk()
		{
			return SeriesPk;
		}
		// implement base class pure virtuals
		// ----------------------------------
		size_t wxDnDPreviewPanelVisualizator::GetDataSize() const
		{
			return sizeof(SeriesPk);
		}
		bool wxDnDPreviewPanelVisualizator::GetDataHere(void *buf) const
		{
			(*((long*)buf)) = SeriesPk;
			return true;
		}
		bool wxDnDPreviewPanelVisualizator::SetData(size_t /*len*/, const void *buf)
		{
			SeriesPk = (*(const long*)buf);
			return true;
		}
		// Must provide overloads to avoid hiding them (and warnings about it)
		size_t wxDnDPreviewPanelVisualizator::GetDataSize(const wxDataFormat&) const
		{
			return GetDataSize();
		}
		bool wxDnDPreviewPanelVisualizator::GetDataHere(const wxDataFormat&, void *buf) const
		{
			return GetDataHere(buf);
		}
		bool wxDnDPreviewPanelVisualizator::SetData(const wxDataFormat&, size_t len, const void *buf)
		{
			return SetData(len, buf);
		}
		//////////////////////END D&D/////////////////////////


		class IPreviewNodeVisualizator : public GNC::GUI::IPreviewNode
		{
		public:
			IPreviewNodeVisualizator(const std::string& label): GNC::GUI::IPreviewNode(label)
			{
			}
			void OnShowMenu(wxWindow* pParent)
			{
			}
			void OnPreviewDClick(wxWindow* pParent)
			{
			}
			virtual void OnPreviewLDown(wxWindow* pParent)
			{
			}
		};

		class IPreviewLeafVisualizator : public GNC::GUI::IPreviewLeaf
		{
		public:
			IPreviewLeafVisualizator(GVistaCompleja* view, long seriesPk, const std::string& label, const std::string& label2): GNC::GUI::IPreviewLeaf(label, label2)
			{
				this->VisualizatorView = view;
				this->seriesPk = seriesPk;
			}
			virtual void OnShowMenu(wxWindow* pParent)
			{
			}
			virtual void OnPreviewDClick(wxWindow* pParent)
			{
				VisualizatorView->LoadSeries(seriesPk);
			}
			virtual void OnPreviewLDown(wxWindow* pParent)
			{
				wxDnDPreviewPanelVisualizator myData(seriesPk);
				wxDropSource dragSource(myData,pParent);
				wxDragResult result = dragSource.DoDragDrop(wxDrag_CopyOnly);
				if (result == wxDragCopy) {
				}
			}

			GVistaCompleja* VisualizatorView;
			long seriesPk;
		};
	}
}


GNKVisualizator::GUI::PreviewPanelVisualizator::PreviewPanelVisualizator(GNC::GCS::IVista* pView, wxWindow* pParent) : GNC::GUI::PreviewPanel(pView, pParent)
{
	pRoot = NULL;
}

GNKVisualizator::GUI::PreviewPanelVisualizator::~PreviewPanelVisualizator()
{
	if (pRoot != NULL) {
		delete pRoot;	
	}
}


void GNKVisualizator::GUI::PreviewPanelVisualizator::LoadModel(GVistaCompleja* pParent, GNC::GCS::Ptr<GNKVisualizator::VisualizatorStudy>& pStudy)
{
	if (pRoot != NULL) {
		delete pRoot;	
	}
	pRoot = new GNKVisualizator::GUI::IPreviewNodeVisualizator(std::string(wxString::Format(_("%d series"), pStudy->OpenedSeries.size()).ToUTF8()));
	for (std::vector<long>::iterator it = pStudy->OpenedSeries.begin(); it != pStudy->OpenedSeries.end(); ++it)
	{
		GNC::GCS::IHistoryController::SeriesModel seriesModel = GNC::GCS::IHistoryController::Instance()->GetSeriesModel((*it));
		GNC::GCS::IHistoryController::FileModel fileModel = GNC::GCS::IHistoryController::Instance()->GetFrameOfReference((*it));
		std::ostringstream ostr;
		ostr << seriesModel.series_modality << " (" << seriesModel.num_instances << ")";
		GNC::GUI::IPreviewLeaf* pLeaf = new GNKVisualizator::GUI::IPreviewLeafVisualizator(pParent, (*it), seriesModel.series_desc, ostr.str());
		pLeaf->SetFilePk(fileModel.pk);
		pRoot->AddChild(pLeaf);
	}
	GNC::GUI::PreviewPanel::LoadModel(pRoot);
}

