/*
 *  
 *  $Id: wseleccion.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <api/globals.h>
#include "wseleccion.h"
#include <main/managers/widgetsmanager.h>
#include <vtkgl.h>
#include <cmath>

//region "Implementacion de WSeleccionBuilder"

GNC::GCS::Widgets::WSeleccionBuilder::WSeleccionBuilder(TWidgetsManager* pManager, const GNC::GCS::TriggerButton& buttonMask, long gid) : GNC::GCS::Widgets::IWidgetBuilder(pManager, buttonMask, gid)
{
	m_MouseDown = false;
	m_Estado = WBS_Ninguno;
	m_Dentro = true;
}

GNC::GCS::Widgets::WSeleccionBuilder::~WSeleccionBuilder()
{
}

void GNC::GCS::Widgets::WSeleccionBuilder::OnMouseEvents(GNC::GCS::Events::EventoRaton& evento)
{
	if (!m_pManager) {
		return;
	}
	/*
	if (evento.Entering()) {
		m_Dentro = true;
		m_pManager->Modificado();
	}
	else if (evento.Leaving()) {
		m_Dentro = false;
		m_pManager->Modificado();
	}
	*/
	if (m_MouseDown && evento.ButtonUp(m_ButtonMask)) {
		m_MouseDown = false;
		if (m_Estado != WBS_Creando) {
			m_Estado = WBS_Ninguno;
			return;
		}
		m_Estado = WBS_Ninguno;

		m_Stop = evento.iP;

		if (m_Start.DistanciaEuclidea(m_Stop) < GNC::GCS::Vector::EpsilonDeReales() ) {
			evento.Skip(true);
		} else {
			m_BB[0].Asignar(m_Start.x, m_Start.y);
			m_BB[1].Asignar(m_Stop.x, m_Start.y);
			m_BB[2].Asignar(m_Stop.x, m_Stop.y);
			m_BB[3].Asignar(m_Start.x, m_Stop.y);

			m_pManager->PropagarHitTestSeleccion(m_BB, 4);

			evento.Skip(false);
		}
		m_pManager->Modificado();		
		m_Estado = WBS_Ninguno;
	}
	else if (evento.ButtonDown(m_ButtonMask)) {
		if (m_Estado != WBS_Ninguno) {
			return;
		}
		m_MouseDown = true;

		m_Start = evento.iP;
		m_Stop = m_Start;

		m_BB[0].Asignar(m_Start.x, m_Start.y);
		m_BB[1].Asignar(m_Stop.x, m_Start.y);
		m_BB[2].Asignar(m_Stop.x, m_Stop.y);
		m_BB[3].Asignar(m_Start.x, m_Stop.y);

		m_pManager->Modificado();
		m_Estado = WBS_Creando;
		evento.Skip(false);
	}
	else if (evento.Dragging() && m_MouseDown) {
		if (m_Estado != WBS_Creando) {
			return;
		}

		m_Stop = evento.iP;

		m_BB[0].Asignar(m_Start.x, m_Start.y);
		m_BB[1].Asignar(m_Stop.x, m_Start.y);
		m_BB[2].Asignar(m_Stop.x, m_Stop.y);
		m_BB[3].Asignar(m_Start.x, m_Stop.y);

		m_pManager->Modificado();
		evento.Skip(false);
	}
	else if( evento.Moving() ){
		GTRACE("Moviendose");
		m_NodoMoviendose = evento.iP;
		m_Estado = WBS_Ninguno;
	}


}

void GNC::GCS::Widgets::WSeleccionBuilder::OnKeyEvents(TEventoTeclado&)
{

}

void GNC::GCS::Widgets::WSeleccionBuilder::Render(GNC::GCS::Contexto3D* /*c*/)
{

	if (m_Estado == WBS_Creando) {
		glLineWidth(1.0f);
		glColor4f(0.0f, 0.36f, 0.807f, 0.15f);
		glBegin(GL_QUADS);
		glVertex2d(m_BB[0].x, m_BB[0].y);
		glVertex2d(m_BB[1].x, m_BB[1].y);
		glVertex2d(m_BB[2].x, m_BB[2].y);
		glVertex2d(m_BB[3].x, m_BB[3].y);
		glEnd();

		//glEnable(GL_LINE_STIPPLE);
		//glLineStipple(3, 0xAAAA);
		glColor4f(0.0f, 0.36f, 0.807f, 1.0f);
		glBegin(GL_LINE_LOOP);
		glVertex2d(m_BB[0].x, m_BB[0].y);
		glVertex2d(m_BB[1].x, m_BB[1].y);
		glVertex2d(m_BB[2].x, m_BB[2].y);
		glVertex2d(m_BB[3].x, m_BB[3].y);
		glEnd();

		//glDisable(GL_LINE_STIPPLE);
	}
	else {

	}
}

GNC::GCS::Widgets::TipoCursor GNC::GCS::Widgets::WSeleccionBuilder::GetCursor()
{
	return GNC::GCS::Widgets::CUR_FLECHA;
}

//endregion
