/*
 *  
 *  $Id: paneltags.h $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include "paneltagsbase.h"
#include <api/controllers/ipacscontroller.h>
#include <wx/propgrid/propgrid.h>
#include <wx/propgrid/advprops.h>

class PanelCustomPASI;

namespace GNC {
	namespace GUI {

		class PanelTags : public PanelTagsBase {
		public:
			PanelTags(wxWindow* pPadre, bool hideOnClose = true);
			virtual ~PanelTags();

			virtual bool IsVisiblePanelTags();
			virtual void MostrarOcultarPanelTags();
			virtual void SetEstudio(GNC::GCS::Ptr<GNC::GCS::IStudyContext> pEstudio);
			virtual bool SetSeriesPk(long pk);

		private:
			virtual void OnClose(wxCloseEvent &event);
			virtual void OnKeyDown(wxKeyEvent &event);

			void CreateCategories();
			wxPGProperty* CreatePropertyGroup(const wxString& label);
			void InsertTagInGroup(wxPGProperty* prop, const std::string& key, wxPGPropArg idPadre);
			void SetInfoTags(GIL::DICOM::TipoMetaInfo& info, GIL::DICOM::IDICOMManager*	pDICOMManager);
			void SetTags(GIL::DICOM::DicomDataset& base, wxPGPropArg idPadre, GIL::DICOM::IDICOMManager*	pDICOMManager);

			wxPGProperty* metadataGroup;
			wxPGProperty* identificationGroup;
			wxPGProperty* patientGroup;
			wxPGProperty* acquisitionGroup;
			wxPGProperty* relationshipGroup;
			wxPGProperty* imagePresentationGroup;
			wxPGProperty* textGroup;
			wxPGProperty* otherGroup;
			bool m_hideOnClose;
		};
	}
}
