/*
 *  
 *  $Id: anonymizedialog.h $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include "anonymizepanelbase.h"

#include <api/autoptr.h>
#include <api/dicom/idicom.h>
#include <api/internationalization/internationalization.h>

#include <main/gui/export/datospersistentesexportacion.h>

namespace GNC {
	namespace GUI {
		class AnonymizeDialog: public AnonymizeDialogBase
		{
		public:
			AnonymizeDialog(wxWindow* pParent, const std::list<long>& seriesPk);
			~AnonymizeDialog();

		protected:
			void SetTags(GIL::DICOM::DicomDataset & base,wxPGPropArg idPadre,GIL::DICOM::IDICOMManager*	pDICOMManager);
			virtual void OnCheckNombreApellidos( wxCommandEvent& event );
			virtual void OnCheckIdPaciente( wxCommandEvent& event );
			virtual void OnCheckInstituciones( wxCommandEvent& event );
			virtual void OnCheckPhysician( wxCommandEvent& event );
			virtual void OnCheckComentarios( wxCommandEvent& event );

			void Anonymize(std::string& clave, bool anonimizar);
			void GetTagsAnonymized(GIL::DICOM::DicomDataset & base);

			void OnPropertyChanged(wxPropertyGridEvent& event);
			void OnPropertyDobleClick(wxPropertyGridEvent& event);

			virtual void OnOverwriteClick( wxCommandEvent& event );
			virtual void OnCreateNewClick( wxCommandEvent& event );

			void LaunchCommand(bool overwrite);

			GIL::DICOM::DicomDataset m_base;
			GNC::GCS::Ptr<TipoWizardExportacion> m_pDatosPersistentes;
		};
	}
}
