/*
 *  
 *  $Id: herramientaanotacionesesquina.cpp 4067 2011-08-08 08:35:48Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/menu.h>

#include <api/globals.h>
#include <api/iwidgetsmanager.h>
#include "herramientaanotacionesesquina.h"
#include <main/controllers/controladoreventos.h>
#include <eventos/eventosginkgo.h>


#ifdef __DEPRECATED
#undef __DEPRECATED
#endif

#include <vtkObject.h>
#include <vtkSmartPointer.h>
#include <vtkPointData.h>
#include <vtkImageData.h>
#include <vtkLookupTable.h>
#include <vtkImageActor.h>
#include <vtkRenderer.h>
#include <vtkRenderWindow.h>
#include <vtkRenderWindowInteractor.h>
#include <vtk/vtkginkgoimageviewer.h>
#include <resources/ginkgoresourcemanager.h>

#define ACTIVAR_ANOTACIONES  1500

namespace GNC {
	namespace GUI {
		class EventHandlerAnotacionesEsquina: public wxEvtHandler {
		public:
			EventHandlerAnotacionesEsquina(wxWindow* pParent, GNC::HerramientaAnotacionesEsquina* pHerramienta):wxEvtHandler()
			{
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;
				m_pParent->Connect(ACTIVAR_ANOTACIONES, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerAnotacionesEsquina::OnActivarAnotacionesClick),NULL,this);
				m_pParent->Connect(ACTIVAR_ANOTACIONES, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerAnotacionesEsquina::OnUpdataAnotacionesUI),NULL,this);

			}
			~EventHandlerAnotacionesEsquina()
			{
				m_pParent->Disconnect(wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerAnotacionesEsquina::OnActivarAnotacionesClick),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerAnotacionesEsquina::OnUpdataAnotacionesUI),NULL,this);
				m_pParent = NULL;
				m_pHerramienta = NULL;
			}

			void OnActivarAnotacionesClick( wxCommandEvent& event )
			{
				m_pHerramienta->SolicitarActivacion();
				event.Skip(false);
			}

			void OnUpdataAnotacionesUI(wxUpdateUIEvent& event) {
				if(m_pHerramienta->IsVisible()) {
					event.SetText(_("Hide corner annotations"));
				} else {
					event.SetText(_("Show corner annotations"));
				}
				event.Enable(m_pHerramienta->Habilitada());
			}

			GNC::HerramientaAnotacionesEsquina* m_pHerramienta;
			wxWindow* m_pParent;
		};
		class MenuHerramientaAnotacionesEsquina : public wxMenuItem {
		public:
			MenuHerramientaAnotacionesEsquina(wxWindow* pParent, wxMenu* pMenuPadre, GNC::HerramientaAnotacionesEsquina* pHerramienta):wxMenuItem(pMenuPadre,ACTIVAR_ANOTACIONES,wxT("Mostrar las anotaciones de la ventana"),wxT("Mostrar las anotaciones de la ventana"),wxITEM_NORMAL) {
				pEventHandler = new EventHandlerAnotacionesEsquina(pParent,pHerramienta);
				#ifdef __WXMSW__
				SetBitmaps(GinkgoResourcesManager::IconosHerramientas::GetIcoCornerAnnotations());
				#else
					SetBitmap(GinkgoResourcesManager::IconosHerramientas::GetIcoCornerAnnotations());
				#endif
			}

			~MenuHerramientaAnotacionesEsquina() {
				if(pEventHandler != NULL) {
					delete pEventHandler;
					pEventHandler = NULL;
				}
			}

			EventHandlerAnotacionesEsquina* pEventHandler;
		};
	}
}

//----------------------------------------------------------------------

GNC::HerramientaAnotacionesEsquina::HerramientaAnotacionesEsquina()
{
	m_Descripcion = _Std("Window annotations");
	m_IsMenu = true;
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoCornerAnnotations();
}

GNC::HerramientaAnotacionesEsquina::~HerramientaAnotacionesEsquina()
{
}

bool GNC::HerramientaAnotacionesEsquina::AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent)
{
	pMenuParent->Append(new GNC::GUI::MenuHerramientaAnotacionesEsquina(pParent,pMenuParent,this));
	return true;
}

//region "Realizacion de la interfaz IHerramienta"

void GNC::HerramientaAnotacionesEsquina::CrearPaneles( wxPanel* /*panel*/ )
{
	m_pAbstractPanelHerramientaOpciones =  NULL;
}

bool GNC::HerramientaAnotacionesEsquina::IsVisible()
{
	bool visible = false;
	if(TContratableWidgets::m_pVistaActiva != NULL && TContratableWidgets::m_pListaActiva != NULL) {
		for (TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
			TContratoWidgets* pCW = (*it1);
			visible = pCW->GetManager()->IsVisibleAnotador();
		}
	}
	return visible;
}

void GNC::HerramientaAnotacionesEsquina::SolicitarActivacion()
{
	GTRACE("GNC::HerramientaAnotacionesEsquina::Resetear()");
	for (TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
		TContratoWidgets* pCW = (*it1);
		// Copio la lista
		if (pCW->Inicializado()) {
			pCW->GetManager()->MostrarOcultarAnotador();
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventoRender(TContratableWidgets::m_pVistaActiva));
		}
	}
}

void GNC::HerramientaAnotacionesEsquina::ConectarContratoFalso(bool ) {
	if (TContratableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

}

void GNC::HerramientaAnotacionesEsquina::SetVistaActiva(GNC::GCS::IVista* pVista) {
	TContratableWidgets::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaReset::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void GNC::HerramientaAnotacionesEsquina::ConectarContratos(bool )
{
	if (TContratableWidgets::m_pListaActiva == NULL) {
		std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

}

//endregion



