/*
 *  
 *  $Id: panelconfiguracionpacs.h 3659 2011-04-07 09:18:16Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iconfiguracion.h>
#include "panelesconfiguracionginkgobase.h"
#include <string>
#include <vector>

namespace GNC {
	namespace GUI {

		class PanelConfiguracionPACS: public PanelConfiguracionPACSBase, public IPasoConfiguracion
		{
			public:
				PanelConfiguracionPACS(wxWindow* pParent, IDialogoConfiguracion* pDialogo);
				~PanelConfiguracionPACS();

				void Recargar();

				//region "Metodos de IPasoConfiguracion"
				wxWindow* GetPanel();

				std::string GetTitle();

				std::string GetCabecera();

				bool Validar();

				bool Guardar();

				void Exportar(wxXmlNode* pNodo);

				void Importar(wxXmlNode* pNodo);
				//endregion
				
				typedef struct TipoPACS {
					std::string id;
					std::string aet;
					std::string host;
					int puerto;
					int pdu;

					bool retrieveSeries;
					bool retrieveWithMove;
					bool useTLS;
					std::string pacsUser;
					std::string pacsPass;
					bool verifyCredentials;
					std::string certificate;
					std::string privateKey;
					bool isDefault;

					TipoPACS() {
						useTLS = verifyCredentials = false;
						retrieveWithMove = true;
						isDefault = false;
						retrieveSeries = true;
					}
				} TipoPACS;

				typedef struct TipoConfigLocal{
					bool useTLS;
					bool verifyCredentials;
					std::string privateKey;
					std::string certificate;

					TipoConfigLocal() {
						useTLS = verifyCredentials = false;
					}
				} TipoConfigLocal;
			protected:
				virtual void OnAdvancedLocal(wxCommandEvent &event);
				virtual void OnListaPACSChoice(wxTreeEvent &event);
				virtual void OnListaPACSDClick(wxTreeEvent&event);

				virtual void OnNuevoClick(wxCommandEvent &event);

				virtual void OnEditarClick(wxCommandEvent &event);

				virtual void OnEliminarClick(wxCommandEvent &event);

				virtual void OnSetDefaultClick(wxCommandEvent &event);

				virtual void OnTextoCambiado(wxCommandEvent &event );

				void OnSize(wxSizeEvent &);

				typedef std::vector <TipoPACS> TipoListaPACS;
				TipoListaPACS m_servidores;				
				TipoConfigLocal m_configLocal;

		};
	}
}
