/*
*  
*  $Id: iherramientawindowlevel.h 3696 2011-04-14 08:40:28Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/iherramienta.h>
#include "icontratoscore.h"
#include "iherramientascore.h"

namespace GNC {
	namespace GCS {

		class EXTAPI IHerramientaWindowLevel: public IHerramienta, public GNC::GCS::IContratable<GNC::GCS::IContratoWindowLevel>, public GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> {
		public:
			typedef GNC::GCS::IContratoWidgets               TContratoWidgets;
			typedef GNC::GCS::IContratable<TContratoWidgets> TContratableWidgets;
			typedef GNC::GCS::IContratoWindowLevel               TContratoWindowLevel;
			typedef GNC::GCS::IContratable<TContratoWindowLevel> TContratableWindowLevel;

			static const IHerramienta::UID ID = HCore_WindowLevel;
			IHerramientaWindowLevel() : IHerramienta(HCore_WindowLevel,TFamiliaVisualizacion,"CoreWindowLevel") {};
			virtual ~IHerramientaWindowLevel() {};

			virtual void SetVistaActiva(GNC::GCS::IVista* pVista) = 0;

			virtual void ConectarContratos(bool) = 0;

			virtual bool ValidaContratos(GNC::GCS::IVista* pVista) {
				return TContratableWindowLevel::ValidaContrato(pVista) && TContratableWidgets::ValidaContrato(pVista);
			}
		};
	}
}
