/*
 *  
 *  $Id: selectimagesimportation.h 3924 2011-07-06 15:11:05Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/api.h>
#include <api/iwizard.h>
#include "pasosimportacionbase.h"
#include <api/controllers/ipacscontroller.h>
#include <api/ientorno.h>
#include <api/icontroladormodulo.h>
#include <yasper/yasper.h>
#include <string>
#include <vector>


namespace GIL
{
	class IModeloIntegracion;
}

namespace GNC {
	namespace GUI {
		class ButtonsBar;

		class EXTAPI SelectImagesImportation: public SelectImagesImportationBase, public IPasoWizard
		{
			public:
				SelectImagesImportation(wxWindow* pParent, std::string& dirTemp, IWizard* pWizard, bool reescalar, GnkPtr<GIL::IModeloIntegracion>& pModeloIntegracion, const std::list<std::string>& fileSpec = std::list<std::string>(), const wxString& defaultFilter = wxEmptyString);
				void SetDefaultImage(const wxImage& defaultImage);
				~SelectImagesImportation();
				
				virtual void AddImages(const wxArrayString& files);
			
			protected:
				bool																			m_firstAttach;
				std::string                                                 m_dirTemp;
				bool                                                        m_reescalar;
				GnkPtr<GIL::IModeloIntegracion>                             m_pModeloIntegracion;
				ButtonsBar*																	m_pButtonsBar;
				wxString																		m_pDefaultFilter;
				wxImage																		m_pDefaultImage;

				virtual wxArrayString GetSelectedPaths();
				virtual void OnSelectFiles(wxCommandEvent &event);

				virtual void AddImage();
				virtual void AddImage(const wxString& path);
				
				virtual void OnRemoveAll(wxCommandEvent &event);
				virtual void OnThumbLeftDClickSelected(wxCommandEvent& event);
				virtual void OnImagenesKeyDown(wxKeyEvent &event);

				virtual void OnUbicacionClick(wxCommandEvent& event);

			//region "Metodos heredados de IPasoWizard"
				virtual void Attach(wxSizer *sizer);

				virtual void Detach(wxSizer *sizer);

				virtual std::string GetTitle();

				virtual std::string GetSubTitle();

				virtual bool Siguiente();

				virtual bool Anterior();

				virtual bool Cancelar();

				virtual bool Validar();
			//endregion

		};
	};
};
