/*
*  
*  $Id: herramientas.h 3698 2011-04-14 12:38:49Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once

#include <wx/cursor.h>
namespace GNC {
	namespace GCS {
		namespace Eventos {

			class EXTAPI EventoHerramientas : public GNC::GCS::Eventos::IEvento
			{
			public:
				typedef enum {
					CambiarCursor
				} TipoEventoHerramientas;

				EventoHerramientas(GNC::GCS::IVista* pVista, TipoEventoHerramientas tipo = CambiarCursor): GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_Herramientas,0,100,pVista){
					m_Nombre = "Herramientas";	
					m_tipo = tipo;
				}


				EventoHerramientas(GNC::GCS::IVista* pVista, wxCursor cursor, TipoEventoHerramientas tipo = CambiarCursor) : GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_Herramientas,0,100,pVista)
				{
					m_Nombre = "Herramientas";
					m_Cursor = cursor;
					m_tipo = tipo;
				}

				~EventoHerramientas()
				{
				}

				wxCursor GetImagenCursor(){
					return m_Cursor;
				}

				TipoEventoHerramientas GetTipo(){
					return m_tipo;
				}

				virtual void pushInfo(std::ostream& out) const {
					out << "ImagenCursor is ok = " << m_Cursor.IsOk();
				}

			protected:
				wxCursor               m_Cursor;
				TipoEventoHerramientas m_tipo;
			};

		}
	}
}
