IF(${CMAKE_BUILD_TYPE} MATCHES "^Deb")
    SET(DEBUG TRUE)
	SET(DTYPE "debug")
ELSE()
	SET(DTYPE "release")
ENDIF()

IF(${CMAKE_SYSTEM_NAME} MATCHES "Windows")
	SET(OS "Windows")
	SET(ARCH "x86")	
	SET(WINDOWS TRUE)
	INCLUDE(WinPackage)

ELSEIF(${CMAKE_SYSTEM_NAME} MATCHES "Linux")
	SET(OS "Linux")
	SET(LINUX TRUE)
	IF (${CMAKE_SYSTEM_PROCESSOR} STREQUAL "x86_64")
		SET(ARCH "x86_64")
	ELSEIF(${CMAKE_SYSTEM_PROCESSOR} MATCHES "i?86")
		SET(ARCH "x86")
	ELSE()
		MESSAGE("UNSUPPORTED ARCH")
	ENDIF()
	INCLUDE(LinuxProperties)

ELSEIF(${CMAKE_SYSTEM_NAME} MATCHES "Darwin")
	SET(OS "OSX")
	SET(MACOS TRUE)
	SET(ARCH "x86")
	INCLUDE(MacProperties)
ELSE()
	MESSAGE("UNSUPPORTED OS")
ENDIF()

#############################################################################################

IF(WINDOWS)
	SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /arch:SSE2")

ELSEIF(LINUX OR APPLE)
	IF(FORCE_SSE2)
		SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC -msse2")
	ELSE()
		SET(CMAKE_CXX_FLAGS "${MAKE_CXX_FLAGS} -fPIC")
	ENDIF()
ENDIF()

#############################################################################################

MACRO(ADD_GLOBAL_GINKGO_DEFINITIONS)
	
	IF (DEBUG)
		ADD_DEFINITIONS(-D_GINKGO_DEBUG -DVTK_DEBUG_LEAKS -DDEBUG -D__WXDEBUG__)
	ENDIF()

	ADD_DEFINITIONS(-DUSING_EXTENSIONS -DGINKGO_ARCH_${ARCH})
	
	IF (USE_PATCHED_LIBS)
		ADD_DEFINITIONS(-DUSE_PATCHED_LIBS)
	ENDIF()


	IF(INTERNET_DIST)
		MESSAGE("Internet public distribution")
		ADD_DEFINITIONS(-DINTERNET_DIST)
	ENDIF()
	
ENDMACRO(ADD_GLOBAL_GINKGO_DEFINITIONS)

#############################################################################################

MACRO(ADD_GLOBAL_EXTENSION_DEFINITIONS)
	
	ADD_GINKGO_DEFINITIONS()
	
ENDMACRO(ADD_GLOBAL_EXTENSION_DEFINITIONS)

#############################################################################################

MACRO(ADD_GLOBAL_CORE_DEFINITIONS)
	
	ADD_GINKGO_DEFINITIONS()
	
	ADD_DEFINITIONS(-DAPIEXPORT)
	
	IF(USE_SYSTEM_SQLITE)
		ADD_DEFINITIONS(-DUSE_SYSTEM_SQLITE)
	ENDIF()

	
ENDMACRO(ADD_GLOBAL_CORE_DEFINITIONS)

