/*
 *  
 *  $Id: wpan.h 4851 2012-04-18 11:59:41Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <vector>

#include <export/itoolslider.h>
#include <api/iwidgets.h>
#include <export/icontratoscore.h>
#include <api/math/geometria3d.h>

namespace GNC {
	namespace GCS {
		namespace Widgets {
			//---------------------------------------------------------------------

			class WPanBuilder : public GNC::GCS::Widgets::IWidgetBuilder {
			public:

				typedef GNC::GCS::Vector                    TVector;
				typedef GNC::GCS::Vector3D                  TVector3D;
				typedef GNC::GCS::Eventos::EventoRaton      TEventoRaton;
				typedef GNC::GCS::Eventos::EventoTeclado    TEventoTeclado;
				typedef GNC::GCS::IWidgetsManager           TWidgetsManager;
				typedef GNC::GCS::Widgets::IWidget          TWidget;

				WPanBuilder(TWidgetsManager* pManager, const GNC::GCS::TriggerButton& buttonMask, long gid);

				~WPanBuilder();

				virtual void OnMouseEvents(TEventoRaton& event);
				virtual void OnKeyEvents(TEventoTeclado& event);

				virtual void Render(GNC::GCS::Contexto3D* c);

				virtual GNC::GCS::Widgets::TipoCursor GetCursor();

				//region "Helpers"

				bool         m_Dentro;
				//endregion


			protected:
				TVector   m_NodoMoviendose;  // Cursor				
				
				bool      m_MouseDown;
				Estado    m_Estado;
			};
		}
	}
}
