/*
 *  $Id: startupform.cpp 4198 2011-09-23 10:25:33Z carlos $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */

#include "startupform.h"
#include <main/controllers/configurationcontroller.h>
#include <main/entorno.h>
#include <wx/xml/xml.h>
#include <wx/ginkgostyle/ginkgostyle.h>
#include <wx/dcbuffer.h>

namespace GNC {
	namespace GUI {
		//////////////////////////////////////////////////////////////////
		struct RSSEntry {
			std::string content;
			std::string updated;
			std::string link;
		};
		typedef std::list<RSSEntry> TListOfEntries;
		//////////////////////////////////////////////////////////////////
		class StartUpTitle: public wxPanel
		{
		public:
			StartUpTitle(wxWindow* pParent) : wxPanel(pParent)
			{
				m_bigFont = wxFont( 18, 70, 90, 90, false, wxEmptyString );

				wxWindow::SetBackgroundStyle(wxBG_STYLE_CUSTOM);

				wxClientDC dc(this);
				dc.SetFont(m_bigFont);
				int height,width;
				dc.GetTextExtent(wxT("Ginkgo CADx"), &width, &height, NULL, NULL, NULL);

				SetSize(width + 20 + 20, height + 20);
				SetMinSize(wxSize(width + 20 + 20, height + 20));

				m_Version = _("Ginkgo CADx v");
				m_Version += wxString::FromUTF8(GNC::Entorno::Instance()->GetGinkgoVersion().c_str());

				this->Connect( wxEVT_PAINT, wxPaintEventHandler( StartUpTitle::OnPaint ), NULL, this );
				this->Connect( wxEVT_SIZE, wxSizeEventHandler( StartUpTitle::OnSize ), NULL, this );
			}
			~StartUpTitle()
			{
				this->Disconnect( wxEVT_PAINT, wxPaintEventHandler( StartUpTitle::OnPaint ), NULL, this );
				this->Disconnect( wxEVT_SIZE, wxSizeEventHandler( StartUpTitle::OnSize ), NULL, this );
			}
		protected:
			virtual void OnPaint(wxPaintEvent &event)
			{
				wxPaintDC dc(this);
				PrepareDC(dc);
				
				int width = dc.GetSize().x;
				int height = dc.GetSize().y;
				wxRect cr(0,0, width, height);

				dc.GradientFillLinear(cr, wxColour(255,255,255), wxColour(200,200,200), wxNORTH);

				dc.SetFont(m_bigFont);
				wxCoord tx = 0, ty = 0;
				wxString str = wxT("Ginkgo CADx");
				dc.GetTextExtent(str, &tx, &ty, NULL, NULL, NULL);
				dc.DrawText(str, 20,20);

				//draw version text...
				dc.SetFont(GetFont());
				dc.GetTextExtent(m_Version, &tx, &ty, NULL, NULL, NULL);
				dc.DrawText(m_Version, width - tx - 20, height - ty);
				
				event.Skip(false);
			}

			void OnSize(wxSizeEvent & event)
			{
				this->Refresh(false);
				event.Skip(false);
			}

			wxFont m_bigFont;
			wxString m_Version;
		};
		//////////////////////////////////////////////////////////////////		
		StartUpForm::StartUpForm(GNC::GCS::IVista* pView): StartUpFormBase(pView->GetEstudio()->VentanaPadre)
		{
			StartUpTitle* pFooter = new StartUpTitle( this);
			GetSizer()->Insert(0, pFooter, 0, wxEXPAND);

			IView = pView;
			wxString message;
			message += wxT("<html><body>");
			message += _("Loading...");
			message += wxT("</body></html>");
			m_pTextTwitter->SetPage(message);

			m_pTextWelcome->SetPage(message);

			bool showOnStart;
			GNC::GCS::ConfigurationController::Instance()->readBoolUser("/GinkgoCore/News", "ShowOnStartUp", showOnStart, true);
			m_pShowOnStartup->SetValue(showOnStart);
			Layout();
		}
		StartUpForm::~StartUpForm()
		{
			//show on startup
			GNC::GCS::ConfigurationController::Instance()->writeBoolUser("/GinkgoCore/News", "ShowOnStartUp", m_pShowOnStartup->GetValue());

			//this is the common way to destroy view without leaks
			IView->Lock(GLOC());
			delete IView;
		}

		void StartUpForm::ShowError(bool twitter)
		{
			wxString message;
			message += wxT("<html><body>");
			message += _("An error ocurred loading Ginkgo News check your internet connection");
			message += wxT("</body></html>");
			if (twitter) {			
				m_pTextTwitter->SetPage(message);
			} else {
				m_pTextWelcome->SetPage(message);
			}
		}

		void StartUpForm::LoadTwitterFile(const wxString& fileName)
		{
			wxXmlDocument doc(fileName);
			if (!doc.IsOk()) {
				ShowError();
				return;
			}
			if (doc.GetRoot()->GetName().CmpNoCase(wxT("rss")) != 0) {
				ShowError();
				return;
			}

			wxXmlNode* channelNode = doc.GetRoot()->GetChildren();
			if (channelNode == NULL || channelNode->GetName().CmpNoCase(wxT("channel")) != 0) {
				ShowError();
				return;
			}

			TListOfEntries entries;
			for (wxXmlNode* child = channelNode->GetChildren(); child != NULL; child = child->GetNext()) 
			{
				if (child->GetName().CmpNoCase(wxT("item")) != 0)
					continue;

				RSSEntry entry;
				for (wxXmlNode* childEntry = child->GetChildren(); childEntry != NULL; childEntry = childEntry->GetNext()) 
				{
					if (childEntry->GetName().CmpNoCase(wxT("description")) == 0) {
						entry.content = childEntry->GetNodeContent().ToUTF8();
					} else if (childEntry->GetName().CmpNoCase(wxT("pubDate")) == 0) {
						entry.updated = childEntry->GetNodeContent().ToUTF8();
					} else if (childEntry->GetName().CmpNoCase(wxT("link")) == 0) {
						entry.link = childEntry->GetNodeContent().ToUTF8();
					}
				}//entries
				entries.push_back(entry);
			}//childs of root

			if (entries.size() == 0) {
				ShowError();
			} else {
				wxString textPage;
				textPage += wxT("<html><body>");
				for (TListOfEntries::iterator it = entries.begin(); it != entries.end(); ++it)
				{
					RSSEntry& entry = (*it);
					wxString content = wxString::FromUTF8(entry.content.c_str());
					if (content.Find(wxT(":")) > 0) {
						content = content.substr(content.Find(wxT(":"))+2);
					}
					if (entry.updated.find("+") != std::string::npos) {
						entry.updated = entry.updated.substr(0, entry.updated.find("+") -1);
					}

					textPage += wxT("<font size=-1 color=#888888>GinkgoCADx on ") + wxString::FromUTF8(entry.updated.c_str()) + wxT("</font>");
					textPage += wxT("<br>");
					textPage += content;
					textPage += wxT("<br>");
					textPage += wxT("<font size=-1 color=#888888><a href=\"") + wxString::FromUTF8(entry.link.c_str()) + wxT("\">Go to original tweet &raquo;</a></font>");
					textPage += wxT("<br>");
					textPage += wxT("<br>");					
				}
				textPage += wxT("</body></html>");
				m_pTextTwitter->SetPage(textPage);
			}			

			this->Layout();
		}

		void StartUpForm::LoadWelcomeFile(const wxString& fileName)
		{
			if (!m_pTextWelcome->LoadFile(fileName)) {
				ShowError(true);
			}
		}

		void StartUpForm::OnURLClicked(wxHtmlLinkEvent &event)
		{
			wxLaunchDefaultBrowser(event.GetLinkInfo().GetHref());
		}
	}
}
