/*
 *
 *  $Id: panelpaciente.cpp 4742 2012-02-23 10:57:03Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/app.h>
#include "panelpaciente.h"
#include <wx/menu.h>
#include "dialogoconfirmacioneliminar.h"

#include <wx/image.h>
#include <wx/msgdlg.h>
#include <wx/dcclient.h>
#include <main/controllers/controladoreventos.h>
#include <main/gui/pacsupload/wxwizarduploadpacs.h>
#include <main/controllers/controladorpermisos.h>
#include <main/entorno.h>
#include <resources/ginkgoresourcemanager.h>

#include <main/entorno.h>
#include <main/gui/mainwindow/ventanaprincipal.h>
#include <main/gui/import/wxwizardimportacionginkgo.h>
#include <main/gui/open/abrir.h>
#include <main/gui/acquisition/dialogoadquisicion.h>
#include <api/icontextoestudio.h>

namespace GNC {
	namespace GUI {
		int PanelPaciente::m_color = 216;

		PanelPaciente::PanelPaciente(INodoHistorial* pPadre,wxWindow* pParentWindow, const GNC::GCS::ControladorHistorial::ModeloSerie& modelo, bool desplegarNodo):
			PanelPacienteBase(pParentWindow),INodoHistorial(pPadre,modelo.m_idPaciente) {

			m_pListaModelos = new GNC::GCS::ControladorHistorial::ListaModelosSeries();
			m_pListaModelos->push_back(modelo);

			m_desplegado = false;
			m_pIcoPlegar->SetBitmap(GinkgoResourcesManager::PanelHistorial::GetIcoDesplegar());
			wxFont fuente = m_pNombre->GetFont();
			fuente.SetPointSize(fuente.GetPointSize()+2);
			m_pNombre->SetFont(fuente);
			m_idPaciente = modelo.m_idPaciente;

			std::ostringstream ostrToolTip;
			ostrToolTip << _Std("Id: ") << modelo.m_idPaciente << std::endl;
			ostrToolTip << _Std("Name: ") << modelo.m_nombrePaciente << std::endl;

			if(modelo.m_nombrePaciente != ""){
				m_pNombre->SetToolTip(wxString::FromUTF8(modelo.m_nombrePaciente.c_str()));

				wxString tmp = wxString::FromUTF8(modelo.m_nombrePaciente.c_str());

				wxClientDC dc(this);
				dc.SetFont(m_pNombre->GetFont());
				int x,y;
				dc.GetTextExtent(tmp, &x, &y, NULL, NULL, NULL);

				while(x > 160)
				{
					dc.GetTextExtent(tmp, &x, &y, NULL, NULL, NULL);
					tmp = tmp.substr(0,tmp.size()-2);
				}
				if(modelo.m_nombrePaciente.size() != tmp.size()) {
					std::stringstream ostr;
					ostr << tmp.ToUTF8() << "...";
					m_pNombre->SetLabel(wxString::FromUTF8(ostr.str().c_str()));
				} else {
					m_pNombre->SetLabel(wxString::FromUTF8(modelo.m_nombrePaciente.c_str()));
				}
			} else {
				m_pNombre->SetLabel(_("Unknown"));
			}
			m_pFechaNacimiento->SetLabel(wxString::FromUTF8(modelo.m_fechaNacimiento.c_str()));

			if(modelo.m_idPaciente!=""){
				m_pIdPaciente->SetToolTip(wxString::FromUTF8(modelo.m_idPaciente.c_str()));

				wxString tmp = wxString::FromUTF8(modelo.m_idPaciente.c_str());

				wxClientDC dc(this);
				dc.SetFont(m_pIdPaciente->GetFont());
				int x,y;
				dc.GetTextExtent(tmp, &x, &y, NULL, NULL, NULL);

				while(x > 130)
				{
					dc.GetTextExtent(tmp, &x, &y, NULL, NULL, NULL);
					tmp = tmp.substr(0,tmp.size()-2);
				}
				if(modelo.m_idPaciente.size() != tmp.size()) {
					std::stringstream ostr;
					ostr << tmp.ToUTF8() << "...";
					m_pIdPaciente->SetLabel(wxString::FromUTF8(ostr.str().c_str()));
				} else {
					m_pIdPaciente->SetLabel(wxString::FromUTF8(modelo.m_idPaciente.c_str()));
				}
			} else {
				m_pIdPaciente->SetLabel(_("<Unknow ID>"));
			}

			if(modelo.m_sexo == 'M'){
				ostrToolTip << _Std("Sex: male") << std::endl;
			}else if(modelo.m_sexo =='F'){
				ostrToolTip << _Std("Sex: female") << std::endl;
			}else{
				ostrToolTip << _Std("Sex: other") << std::endl;
			}

			ostrToolTip << _Std("Birth date: ") << modelo.m_fechaNacimiento;
			wxString toolTip = wxString::FromUTF8(ostrToolTip.str().c_str());
			SetToolTip(toolTip);
			m_pNombre->SetToolTip(toolTip);
			m_pIdPaciente->SetToolTip(toolTip);
			m_pFechaNacimiento->SetToolTip(toolTip);
			m_pPanelCabecera->SetToolTip(toolTip);
			//background
			{
				// fondo del panel
				wxImage::HSVValue valorHSV = wxImage::HSVValue((double)m_color/360.0f, 0.4f, 0.9f);

				//std::cout << valorHSV.hue << ", " << valorHSV.saturation << ", " << valorHSV.value << ", " << std::endl;

				m_color = (m_color + 60) % 360;
				wxImage::RGBValue value = wxImage::HSVtoRGB(valorHSV);
				wxColour colorWx(value.red,value.green,value.blue);
				SetBackgroundColour(colorWx);

				//fondo del border
				valorHSV.saturation = 0.75f;
				valorHSV.value = 0.65f;
				value = wxImage::HSVtoRGB(valorHSV);
				wxColour colorWxBorder(value.red,value.green,value.blue);
				SetBorderColour(colorWxBorder);
			}
			if (desplegarNodo) {
				Desplegar();
			} else {
				m_pSizerEstudios->Show(desplegarNodo);
			}
			SetAutoLayout(true);

			m_pPanelCabecera->Layout();
			Layout();
		}

		PanelPaciente::~PanelPaciente(){
			if (m_pListaModelos != NULL) {
				std::list< std::string > listaUIDs;
				for (TListaModelosSeries::iterator it  = m_pListaModelos->begin(); it != m_pListaModelos->end(); ++it) {
					listaUIDs.push_back((*it).m_uidSerie);
				}
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoAbribleEliminado(listaUIDs));
				delete m_pListaModelos;
				m_pListaModelos = NULL;
			}
		}


		const std::string& PanelPaciente::GetIdPaciente()
		{
			return m_idPaciente;
		}

		PanelEstudio* PanelPaciente::GetEstudio(const GNC::GCS::ControladorHistorial::ModeloSerie& modeloSerie)
		{
			TMapaHijos::iterator it=m_mapaHijos.find(modeloSerie.m_uidEstudio);
			if(it!=m_mapaHijos.end()){
				return (PanelEstudio*)(*it).second;
			}else{
				PanelEstudio* pEstudio = new PanelEstudio(this,this,modeloSerie.m_descripcionEstudio,modeloSerie.m_uidEstudio);
				m_pSizerEstudios->Add(pEstudio,0,wxBOTTOM|wxALIGN_CENTER,6);
				pEstudio->Show(m_desplegado);
				Layout();
				m_mapaHijos[modeloSerie.m_uidEstudio]=pEstudio;
				return pEstudio;
			}
		}

		PanelEstudio* PanelPaciente::GetEstudio(const std::string& studyUID)
		{
			TMapaHijos::iterator it=m_mapaHijos.find(studyUID);
			if(it!=m_mapaHijos.end()){
				return (PanelEstudio*)(*it).second;
			}else{
				return NULL;
			}
		}

		void PanelPaciente::OnCabeceraClick(wxMouseEvent &)
		{
			//si el virtual size pasa de 16 bits (32000 pasan cosas malas)
			if (!m_desplegado && this->GetParent()->GetVirtualSize().y > 30000)
			{
				Desplegar(false);
				wxBell();
				return;
			}
			Desplegar(true);
		}

		void PanelPaciente::OnPanelPacienteClick(wxMouseEvent &event)
		{
			event.ResumePropagation(2);
			event.Skip(true);
		}

		void PanelPaciente::OnMenuMouse(wxMouseEvent &event)
		{
			wxMenu menu;

			wxMenuItem* pMenuAdquirir = new wxMenuItem(&menu, 3, wxString( _("&DICOM &Acquisition") ), _("Acquiring a new DICOM study"), wxITEM_NORMAL );
			menu.Connect(3,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelPaciente::OnAdquirir),NULL,this);

			wxMenuItem* pMenuOpenFile = new wxMenuItem(&menu, 4, wxString( _("&Open File") ), _("Open a DICOM file"), wxITEM_NORMAL );
			menu.Connect(4,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelPaciente::OnOpenFile),NULL,this);

			wxMenuItem* pMenuOpenFolder = new wxMenuItem(&menu, 5, wxString( _("&Open Folder") ), _("Acquire from a local folder"), wxITEM_NORMAL );
			menu.Connect(5,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelPaciente::OnOpenFolder),NULL,this);

			wxMenuItem* pMenuImportar = new wxMenuItem( &menu, 6, wxString( _("&Import ...") ), _("Import images"), wxITEM_NORMAL );
			menu.Connect(6,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelPaciente::OnImportar),NULL,this);

			wxMenuItem* pMenuSend = new wxMenuItem(&menu, 7, wxString( _("Send to PACS server") ), _("Send to PACS server"), wxITEM_NORMAL );
			menu.Connect(7,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelPaciente::OnUploadPACS),NULL,this);

			#ifdef __WXMSW__
			pMenuAdquirir->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoAbrir());
			pMenuImportar->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoImportar());
			pMenuOpenFile->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoOpenFile());
			pMenuOpenFolder->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoOpenDir());
			pMenuSend->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoSendToPACS());
			#else
			pMenuAdquirir->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoAbrir());
			pMenuImportar->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoImportar());
			pMenuOpenFile->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoOpenFile());
			pMenuOpenFolder->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoOpenDir());
			pMenuSend->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoSendToPACS());
			#endif

			if(GNC::GCS::ControladorPermisos::Instance()->Get("core.restrictions","acquire")) {
				menu.Append(pMenuOpenFile);
				menu.Append(pMenuOpenFolder);
				if(GNC::GCS::ControladorPermisos::Instance()->Get("core.pacs.limits","pacs_acquisition")) {
					menu.AppendSeparator();
					menu.Append( pMenuAdquirir );
				} else {
					delete pMenuAdquirir;
				}
			} else {
				delete pMenuOpenFile;
				delete pMenuAdquirir;
				delete pMenuOpenFolder;
			}
			if(GNC::GCS::ControladorPermisos::Instance()->Get("core.pacs.limits","pacs_upload")) {
				if (menu.GetMenuItemCount() > 0) {
					menu.AppendSeparator();
				}
				menu.Append(pMenuSend);
			} else {
				delete pMenuSend;
			}
			if(GNC::GCS::ControladorPermisos::Instance()->Get("core.restrictions","import")) {
				if (menu.GetMenuItemCount() > 0) {
					menu.AppendSeparator();
				}
				menu.Append(pMenuImportar);
			} else {
				delete pMenuImportar;
			}

			if (!GNC::GCS::ControladorHistorial::Instance()->IsReadOnly()) {
				if (menu.GetMenuItemCount() > 0) {
					menu.AppendSeparator();
				}
				wxMenuItem* pMenuEliminar = new wxMenuItem(&menu, 1, wxString( _("&Delete Patient from History") ), _("Delete"), wxITEM_NORMAL );
				menu.Connect(1,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelPaciente::OnEliminar),NULL,this);
				#ifdef __WXMSW__
				pMenuEliminar->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoEliminar());
				#else
				pMenuEliminar->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoEliminar());
				#endif
				menu.Append(pMenuEliminar);
				menu.AppendSeparator();

				wxMenuItem* pMenuLimpiar = new wxMenuItem(&menu, 2, wxString( _("&Clear History") ), _("Delete"), wxITEM_NORMAL );
				menu.Connect(2,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelPaciente::OnLimpiarHistorial),NULL,this);
				#ifdef __WXMSW__
				pMenuLimpiar->SetBitmaps(GinkgoResourcesManager::PanelHistorial::GetIcoCleanAll());
				pMenuLimpiar->SetBitmap(GinkgoResourcesManager::PanelHistorial::GetIcoCleanAll());
				#endif
				menu.Append(pMenuLimpiar);
			}
			GNC::Entorno::Instance()->GetVentanaRaiz()->PopupMenu(&menu);
			event.Skip(false);
		}

		void PanelPaciente::OnEliminar(wxCommandEvent& event)
		{
			for(TMapaHijos::iterator it=m_mapaHijos.begin(); it!= m_mapaHijos.end(); it++) {
				if ((*it).second->HayNodosAbiertos())
				{
					wxMessageBox(_("Failed to remove patient, you have to close opened studies"), _("Info"),
						wxOK | wxICON_WARNING);
					event.Skip(false);
					return;
				}
			}

			bool eliminar = false;
			{
				DialogoConfirmacionEliminar dlg(GNC::Entorno::Instance()->GetVentanaRaiz(), _("this Patient"));
				dlg.ShowModal();
				switch (dlg.GetResultado()) {
					case DialogoConfirmacionEliminar::TR_Eliminar :
						GNC::GCS::ControladorHistorial::Instance()->EliminarPaciente(m_clave,true);
						eliminar = true;
						break;
					case DialogoConfirmacionEliminar::TR_Cancelar :
						break;
				}
			}
			if(eliminar){
				Eliminar();
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLayoutHistorial());
			}
			event.Skip(false);
		}

		void PanelPaciente::OnLimpiarHistorial(wxCommandEvent &event)
		{
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLimpiarHistorial());
			event.Skip(false);
		}

		void PanelPaciente::OnUploadPACS(wxCommandEvent &)
		{
			wxWizardUploadPACSGinkgo::TListUIDs uidsList;

			GNC::GCS::ControladorHistorial::ListaModelosSeries seriesList;
			GNC::GCS::ControladorHistorial::Instance()->GetAllModelosSeriePatient(m_clave, seriesList);

			for (GNC::GCS::ControladorHistorial::ListaModelosSeries::iterator it = seriesList.begin(); it != seriesList.end(); ++it)
			{
				uidsList.push_back((*it).m_uidSerie);
			}

			wxWizardUploadPACSGinkgo wiz(GNC::Entorno::Instance()->GetVentanaRaiz(), uidsList);
			wiz.ShowModal();
		}

		void PanelPaciente::OnImportar(wxCommandEvent& )
		{
			try{
				GNC::GUI::wxWizardImportacionGinkgo ib(this,NULL);
				ib.ShowModal();
			}
			catch(GIL::DICOM::I2DException i){
			}
		}

		void PanelPaciente::OnAdquirir(wxCommandEvent& )
		{
			GNC::GUI::DialogoAdquisicion::Instance()->Show();
		}

		void PanelPaciente::OnOpenFile(wxCommandEvent& )
		{
			GNC::GUI::Abrir::AbrirFichero(this);
		}

		void PanelPaciente::OnOpenFolder(wxCommandEvent& )
		{
			GNC::GUI::Abrir::AbrirDirectorio(this);
		}

		void PanelPaciente::Detach(wxWindow* pHijo)
		{
			m_pSizerEstudios->Detach(pHijo);
			pHijo->Hide();
			Layout();
		}

		void PanelPaciente::Eliminar()
		{
			m_pPadre->Detach(this);
			m_pPadre->Eliminar(this);
			this->Destroy();
		}

		void PanelPaciente::OnPaint(wxPaintEvent& event)
		{
			PanelPacienteBase::OnPaint(event);
			{
				wxPaintDC dc(this);
				wxColour color = m_pPanelCabecera->GetBackgroundColour();
				dc.SetBrush(wxBrush(color,wxTRANSPARENT));
				dc.SetPen(wxPen(color, 1, wxSOLID));
				dc.DrawRectangle(wxRect(wxPoint(0,0), wxPoint(dc.GetSize().x-1, dc.GetSize().y-1)));
			}
		}

		void PanelPaciente::OnSize(wxSizeEvent & event)
		{
			Layout();
			event.Skip();
		}

		void PanelPaciente::OnMouseWheel(wxMouseEvent& event)
		{
			event.ResumePropagation(2);
			event.Skip(true);
		}

		bool PanelPaciente::EstaDesplegado()
		{
			return m_desplegado;
		}

		bool PanelPaciente::SetBackgroundColour(const wxColour& colour)
		{
			wxWindow::SetBackgroundColour(colour);
			return true;
		}

		void PanelPaciente::SetBorderColour(const wxColour& colour)
		{
			m_pPanelCabecera->SetBackgroundColour(colour);
		}

		void PanelPaciente::AddModeloSerie(const GNC::GCS::ControladorHistorial::ModeloSerie& modelo)
		{
			if (m_desplegado || m_pListaModelos == NULL) {
				CrearPanelSerie(modelo);
			} else {
				if (m_pListaModelos != NULL) {
					for (TListaModelosSeries::iterator it = m_pListaModelos->begin(); it != m_pListaModelos->end(); ++it) {
						if ((*it).m_uidSerie == modelo.m_uidSerie) {
							return;
						}
					}
					m_pListaModelos->push_back(modelo);
				}
			}
		}

		PanelSerie* PanelPaciente::GetSeries(const std::string& uidSerie, bool forceExpand)
		{
			if (m_mapaSeries.find(uidSerie) != m_mapaSeries.end()) {
				return m_mapaSeries[uidSerie];
			} else if (forceExpand && !m_desplegado) {
				//TODO crear nodos pero no desplegar...
				Desplegar(false);
				if (m_mapaSeries.find(uidSerie) != m_mapaSeries.end()) {
					return m_mapaSeries[uidSerie];
				} else {
					return NULL;
				}
			} else {
				return NULL;
			}
		}

		void PanelPaciente::Desplegar(bool show)
		{
			GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperFreeze();
			this->GetParent()->Freeze();
			Freeze();
			if (m_pListaModelos != NULL) {
				for (TListaModelosSeries::iterator it = m_pListaModelos->begin(); it != m_pListaModelos->end(); ++it) {
					CrearPanelSerie((*it));
				}

				delete m_pListaModelos;
				m_pListaModelos = NULL;
			}
			if (show) {
				m_desplegado = !m_desplegado;
				if (m_desplegado) {
					m_pIcoPlegar->SetBitmap(GinkgoResourcesManager::PanelHistorial::GetIcoPlegar());
				} else {
					m_pIcoPlegar->SetBitmap(GinkgoResourcesManager::PanelHistorial::GetIcoDesplegar());
				}
				m_pIcoPlegar->Refresh(true);
				for (TMapaHijos::iterator it = m_mapaHijos.begin(); it != m_mapaHijos.end(); ++it) {
					((PanelEstudio*)((*it).second))->Show(m_desplegado);
				}
				m_pSizerEstudios->Show(m_desplegado);
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLayoutHistorial());
			}
			Thaw();
			this->GetParent()->Thaw();
			GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperThaw();
		}

		void PanelPaciente::CrearPanelSerie(const GNC::GCS::ControladorHistorial::ModeloSerie& modelo)
		{
			PanelEstudio* estudio = GetEstudio(modelo);
			PanelSerie* pPanelSerie = estudio->GetSerie(modelo);
			m_mapaSeries[modelo.m_uidSerie] = pPanelSerie;
		}
	};
};
