/*
*
*  $Id: xmlrpccontroller.cpp 4682 2012-02-09 14:25:47Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/

#include <wx/file.h>
#include <wx/filename.h>
#include <wx/dir.h>
#include <main/controllers/configurationcontroller.h>
#include <api/integration/dict.h>
#include <main/controllers/integrationcontroller.h>
#include <wx/wxsqlite3/wxsqlite3.h>

#include "xmlrpccontroller.h"
#include <api/globals.h>
#include <api/threads/thread.h>

#define LOGGER "XMLRPCController"
#include "controladorlog.h"
#include "../entorno.h"
#include <api/icomando.h>
#include <main/gui/mainwindow/ventanaprincipal.h>
#include <main/gui/history/panelhistorial2.h>
#include <main/gui/history/ipanelhistorial.h>
#include <main/gui/import/wxwizardimportacionginkgo.h>
#include "controladorcomandos.h"
#include "controladoreventos.h"
#include <main/controllers/controladorhistorial.h>
#include <eventos/eventosginkgo.h>
#include "integrationcontroller.h"
#include <xmlrpc/XmlRpc.h>
#include <commands/comandopacs.h>
#include <api/icontextoestudio.h>
#include <set>

#define IDC_RPC 115

//log handler...
namespace XmlRpc {
	//------------------------------------------------------------------------------------------------------+
	//TODO: It's not working, when you activate log redirection to ControladorLog client ends unexpectly
	class GinkgoLogHandler: public XmlRpc::XmlRpcLogHandler
	{
	public:
		GinkgoLogHandler() {}
		~GinkgoLogHandler() {}

		virtual void log(int level, const char* msg)
		{
			GNC::GCS::ControladorLog::Instance()->Log(msg, (GNC::GCS::IControladorLog::LogLevel)level);
		}
	};
	//------------------------------------------XML_RPC METHODS--------------------------------------------------
	//"CloseAllWindows", closes all opened windows.
	//ClosesAllWindowsCommand, it's necessary to launch a command because closing method has to be called by interface thread
	class ClosesAllWindowsCommand : public GNC::GCS::IComando {
	public:
		ClosesAllWindowsCommand() : IComando(NULL)
		{
			SetId(IDC_RPC);
		}

		virtual void Execute() {}

		virtual void Update()
		{
			if (GNC::Entorno::Instance()->GetVentanaPrincipal()->CerrarTodosLosTabsYPanelGrids())
			{
				GNC::Entorno::Instance()->GetVentanaPrincipal()->ClosesAllUndocked();
			}
		}
	};

	//CloseAllWindows this is the rpc command, it launches Ginkgo Command
	class CloseAllWindows : public XmlRpcServerMethod
	{
	public:
		CloseAllWindows(XmlRpcServer* s) : XmlRpcServerMethod("CloseAllWindows", s) {}

		void execute(XmlRpcValue& /*params*/, XmlRpcValue& result)
		{
			GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Closing windows..."), new ClosesAllWindowsCommand(), NULL);
			result["error"] = 0;
		}

		std::string help() { return std::string("Closes all opened windows"); }

	};
	//---------------------------------------------------------------------------------------------------
	// Close2DViewerWithSeriesUID and Close2DViewerWithStudyUID, closes view with tab uid as specified
	// ClosesViewCommand, it's necessary to launch a command because closing method has to be called by interface thread
	class ClosesViewCommand : public GNC::GCS::IComando {
	public:
		ClosesViewCommand(const std::string& uid, bool series = true) : IComando(NULL)
		{
			m_series = series;
			m_uid = uid;
			SetId(IDC_RPC);
		}

		virtual void Execute() {}

		virtual void Update()
		{
			GNC::GUI::PanelHistorial2* pPanel = GNC::Entorno::Instance()->GetVentanaPrincipal()->GetPanelHistorial();
			GNC::GCS::IVista* pVista;
			if (m_series) {
				pVista = pPanel->GetVistaFromSeriesUID(m_uid);
			} else {
				pVista = pPanel->GetVistaFromStudyUID(m_uid);
			}
			if (pVista != NULL) {
				GNC::Entorno::Instance()->GetVentanaPrincipal()->CerrarVista(pVista);
			}
		}
		std::string m_uid;
		bool m_series;
	};

	//Close2DViewerWithSeriesUID this is the rpc command, it parses params and launches Ginkgo Command
	class Close2DViewerWithSeriesUID : public XmlRpcServerMethod
	{
	public:
		Close2DViewerWithSeriesUID(XmlRpcServer* s) : XmlRpcServerMethod("Close2DViewerWithSeriesUID", s) {}

		void execute(XmlRpcValue& params, XmlRpcValue& result)
		{
			std::string uidSeries = std::string(params[0]["uid"]);
			if (uidSeries != "") {
				GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Closing windows..."), new ClosesViewCommand(uidSeries), NULL);
			}
			result["error"] = 0;
		}

		std::string help() { return std::string("Closes series"); }

	};

	//Close2DViewerWithStudyUID this is the rpc command, it parses params and launches Ginkgo Command
	class Close2DViewerWithStudyUID : public XmlRpcServerMethod
	{
	public:
		Close2DViewerWithStudyUID(XmlRpcServer* s) : XmlRpcServerMethod("Close2DViewerWithStudyUID", s) {}

		void execute(XmlRpcValue& params, XmlRpcValue& result)
		{
			std::string uidStudy = std::string(params[0]["uid"]);
			if (uidStudy != "") {
				GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Closing windows..."), new ClosesViewCommand(uidStudy, false), NULL);
			}
			result["error"] = 0;
		}

		std::string help() { return std::string("Closes study"); }

	};
	//---------------------------------------------------------------------------------------------------
	//OpenDB changes Ginkgo's dicomdir path
	//ChangeDicomDirCommand command it's necessary because interface will be refreshed
	class ChangeDicomDirCommand : public GNC::GCS::IComando {
	public:
		ChangeDicomDirCommand() : IComando(NULL)
		{
			SetId(IDC_RPC);
		}

		virtual void Execute() {}

		virtual void Update()
		{
			GNC::GCS::ControladorHistorial::Instance()->RecargarHistorial();
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoRecargarHistorial());
		}
	};

	//OpenDB parses params and if it's necessary lauches Change dicomdir command
	class OpenDB : public XmlRpcServerMethod
	{
	public:
		OpenDB(XmlRpcServer* s) : XmlRpcServerMethod("OpenDB", s) {}


		void execute(XmlRpcValue& params, XmlRpcValue& result)
		{
			//to change dicomdir all views has to be closed
			if (GNC::GCS::ControladorVistas::Instance()->GetVistas().size() != 0) {
				result["error"] = -1;
				return;
			}

			std::string stdPath = std::string(params[0]["path"]);
			wxString newPath = FROMPATH(stdPath);

			if(!wxDir::Exists(newPath)) {
				//if the directory doesn't exists we create a new
	#ifdef _WIN32
				wxMkdir(newPath,511);
	#else
				wxMkDir(newPath.ToUTF8(), 0770);
	#endif
				if(!wxDirExists(newPath))
				{
					result["error"] = -1;
					return;
				}
			} else {
				//check if directory is readonly, to check it we write and erase a file
				wxString pathFicheroPrueba = newPath + wxFileName::GetPathSeparator() + wxString::Format(wxT("%d"),rand());
				while(wxFileExists(pathFicheroPrueba)) {
					pathFicheroPrueba = newPath + wxFileName::GetPathSeparator() + wxString::Format(wxT("%d"),rand());
				}
				{
					wxFile ficheroTmp;
					if(!ficheroTmp.Create(pathFicheroPrueba,false)){
						if(!wxFileExists(pathFicheroPrueba) ) {
							result["error"] = -1;
							return;
						}
					}
					ficheroTmp.Write(wxT("prueba"));
					ficheroTmp.Close();
				}
				wxRemoveFile(pathFicheroPrueba);
			}

			std::string oldPath;
			GNC::GCS::ConfigurationController::Instance()->readStringUser("/GinkgoCore/Estacion","DicomDir", oldPath);

			wxFileName dirAnterior(wxString::FromUTF8(oldPath.c_str()));
			wxFileName dirNuevo(newPath);
			if(dirAnterior != dirNuevo)
			{
				GNC::GCS::ConfigurationController::Instance()->writeStringUser("/GinkgoCore/Estacion","DicomDir", std::string(newPath.ToUTF8()));
				//command is thrown to make update
				GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Closing windows..."), new ChangeDicomDirCommand(), NULL);
			}
			result["error"] = 0;
		}

		std::string help() { return std::string("Changes Ginkgo database"); }

	};
	//---------------------------------------------------------------------------------------------------
	// "GetDisplayed2DViewerSeries" resturns series instance uid of opened series
	class GetDisplayed2DViewerSeries : public XmlRpcServerMethod
	{
	public:
		GetDisplayed2DViewerSeries(XmlRpcServer* s) : XmlRpcServerMethod("GetDisplayed2DViewerSeries", s) {}

		void execute(XmlRpcValue& /*params*/, XmlRpcValue& result)
		{
			//historial knows opened series
			GNC::GUI::PanelHistorial2* pPanel = GNC::Entorno::Instance()->GetVentanaPrincipal()->GetPanelHistorial();
			std::list<std::string> openedUIDs = pPanel->GetOpenedSeriesUIDs();
			int i = 0;
			for (std::list<std::string>::iterator it = openedUIDs.begin(); it != openedUIDs.end(); ++it)
			{
				result["elements"][i++]["seriesInstanceUID"] = (*it);
			}
			result["error"] = 0;
		}

		std::string help() { return std::string("Returns displayed 2D viewer series"); }

	};
	//---------------------------------------------------------------------------------------------------
	// "GetDisplayed2DViewerSeries" resturns study instance uid of opened series
	class GetDisplayed2DViewerStudies : public XmlRpcServerMethod
	{
	public:
		GetDisplayed2DViewerStudies(XmlRpcServer* s) : XmlRpcServerMethod("GetDisplayed2DViewerStudies", s) {}

		void execute(XmlRpcValue& /*params*/, XmlRpcValue& result)
		{
			//historial knows opened series
			GNC::GUI::PanelHistorial2* pPanel = GNC::Entorno::Instance()->GetVentanaPrincipal()->GetPanelHistorial();
			std::list<std::string> openedUIDs = pPanel->GetOpenedStudiesUIDs();
			int i = 0;
			for (std::list<std::string>::iterator it = openedUIDs.begin(); it != openedUIDs.end(); ++it)
			{
				result["elements"][i++]["studyInstanceUID"] = (*it);
			}
			result["error"] = 0;
		}

		std::string help() { return std::string("Returns displayed 2D viewer studies"); }

	};
	//---------------------------------------------------------------------------------------------------
	// CMove launches a ComandoPACS command to retrieve series or studies
	class CMove : public XmlRpcServerMethod
	{
	public:
		CMove(XmlRpcServer* s) : XmlRpcServerMethod("CMove", s) {}

		void execute(XmlRpcValue& params, XmlRpcValue& result)
		{
			std::string serverId = std::string(params[0]["server"]);
			std::string accesssionNumber = std::string(params[0]["accessionNumber"]);
			std::string studyInstanceUID = std::string(params[0]["studyInstanceUID"]);
			std::string seriesInstanceUID = std::string(params[0]["seriesInstanceUID"]);

			GIL::DICOM::TipoJerarquia base;
			if (!accesssionNumber.empty()) {
				base.tags["0008|0050"] = accesssionNumber;
			}
			if (!studyInstanceUID.empty()) {			
				base.tags["0020|000d"] = studyInstanceUID; //study instance uid
			}

			if (!seriesInstanceUID.empty()) {
				base.tags["0020|000e"] = seriesInstanceUID; //series instance uid
				base.tags["0008|0052"] = "SERIES";
				GADAPI::ComandoPACSParams * pParams = new GADAPI::ComandoPACSParams(serverId, base);
				GADAPI::ComandoPACS* pComandoPACS = new GADAPI::ComandoPACS(pParams);
				GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Downloading from PACS..."), pComandoPACS, NULL);
			} else if (accesssionNumber != "" || studyInstanceUID != "")
			{
				base.tags["0008|0052"] = "STUDY";

				GADAPI::ComandoPACSParams * pParams = new GADAPI::ComandoPACSParams(serverId, base);
				GADAPI::ComandoPACS* pComandoPACS = new GADAPI::ComandoPACS(pParams);
				GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync("Descargando PACS...",pComandoPACS, NULL);
			}
			result["error"] = 0;
		}

		std::string help() { return std::string("Retrieve files from PACS"); }
	};
	//---------------------------------------------------------------------------------------------------
	// Dicomize starts a dicomization workflow
	//LaunchDicomizationCommand opens importation wizard
	class LaunchDicomizationCommand : public GNC::GCS::IComando {
	public:
		LaunchDicomizationCommand(const std::string& uidModule, GnkPtr<GIL::IModeloIntegracion>  pModelo) : IComando(NULL)
		{
			SetId(IDC_RPC);
			m_uidModulo = uidModule;
			m_pModelo = pModelo;
		}

		virtual void Execute() {}

		virtual void Update()
		{
			try{
				GNC::GUI::wxWizardImportacionGinkgo ib(NULL, m_pModelo, m_uidModulo);
				ib.ShowModal();
			}
			catch(GIL::DICOM::I2DException& i){
				LOG_ERROR("GIL/WF/Importar", (const std::string)i);
			}
			catch(std::exception& ex1){
				LOG_ERROR("GIL/WF/Importar", std::string("Error al importar: ") + ex1.what());
			}
			catch (...)
			{
				LOG_ERROR("GIL/WF/Importar", std::string("Error al importar: Error interno"));
			}
		}
		GnkPtr<GIL::IModeloIntegracion> m_pModelo;
		std::string m_uidModulo;
	};
	// Dicomize parses params and launches command if necessary, parsing is similar to done in controladorhl7.cpp
	class Dicomize : public XmlRpcServerMethod
	{
	public:
		Dicomize(XmlRpcServer* s) : XmlRpcServerMethod("Dicomize", s) {}

		void execute(XmlRpcValue& params, XmlRpcValue& result)
		{
			GnkPtr<GIL::IModeloIntegracion> integrationModel(new GIL::IModeloIntegracion());
			//general info
			integrationModel->accion = GIL::IModeloIntegracion::TA_Dicomizar;
			integrationModel->GlobalVariables.InsertVariable(GKDI_GLOBAL_PACS_STORE_SID,  std::string(params[0]["pacsStoreSid"]));
			integrationModel->idPlantilla = std::string(params[0]["Pid"]);
			//patient info
			integrationModel->GlobalVariables.InsertVariable(GKDI_PATIENT_ID, std::string(params[0]["Patient"]["IdValue"]));
			integrationModel->GlobalVariables.InsertVariable(GKDI_PATIENT_NAME, std::string(params[0]["Patient"]["Name"]));
			integrationModel->GlobalVariables.InsertVariable(GKDI_PATIENT_FAMILY_NAME, std::string(params[0]["Patient"]["FirstSurname"]));
			integrationModel->GlobalVariables.InsertVariable(GKDI_PATIENT_SECOND_FAMILY_NAME, std::string(params[0]["Patient"]["SecondSurname"]));
			integrationModel->GlobalVariables.InsertVariable(GKDI_HCE_EPISODE_NUMBER, std::string(params[0]["Patient"]["EpisodeNumber"]));
			//physician info
			integrationModel->GlobalVariables.InsertVariable(GKDI_REFERRING_PHISICIAN_ID, std::string(params[0]["Physician"]["IdValue"]));
			integrationModel->GlobalVariables.InsertVariable(GKDI_REFERRING_PHISICIAN_NAME, std::string(params[0]["Physician"]["Name"]));
			integrationModel->GlobalVariables.InsertVariable(GKDI_REFERRING_PHISICIAN_FAMILY_NAME, std::string(params[0]["Physician"]["FirstSurname"]));			
			integrationModel->GlobalVariables.InsertVariable(GKDI_REFERRING_PHISICIAN_SECOND_FAMILY_NAME, std::string(params[0]["Physician"]["SecondSurname"]));
			integrationModel->GlobalVariables.InsertVariable(GKDI_REFERRING_PHISICIAN_INSTITUTION_ID, std::string(params[0]["Physician"]["IdCenter"]));
			integrationModel->GlobalVariables.InsertVariable(GKDI_REFERRING_PHISICIAN_INSTITUTION_NAME, std::string(params[0]["Physician"]["CenterName"]));
			//hce
			integrationModel->GlobalVariables.InsertVariable(GKDI_HCE_ID, std::string(params[0]["HCE"]["AID"]));

			//insert dicom...
			//insert tags dicom...
			if (integrationModel->GlobalVariables.Contains(GKDI_PATIENT_ID)) {
				integrationModel->TagsDICOMOverwrite.tags["0010|0020"] = integrationModel->GlobalVariables.GetValue(GKDI_PATIENT_ID);
			}
			if (integrationModel->GlobalVariables.Contains(GKDI_PATIENT_NAME)) {
				std::ostringstream ostr;
				ostr << integrationModel->GlobalVariables.GetValue(GKDI_PATIENT_FAMILY_NAME);
				if (integrationModel->GlobalVariables.Contains(GKDI_PATIENT_SECOND_FAMILY_NAME)) {
					ostr << " " << integrationModel->GlobalVariables.GetValue(GKDI_PATIENT_SECOND_FAMILY_NAME);
				}
				ostr << "^" << integrationModel->GlobalVariables.GetValue(GKDI_PATIENT_NAME);
				integrationModel->TagsDICOMOverwrite.tags["0010|0010"] = ostr.str();
			}
			if (integrationModel->GlobalVariables.Contains(GKDI_REFERRING_PHISICIAN_NAME)) {
				std::ostringstream ostr;
				ostr << integrationModel->GlobalVariables.GetValue(GKDI_REFERRING_PHISICIAN_FAMILY_NAME);
				if (integrationModel->GlobalVariables.Contains(GKDI_REFERRING_PHISICIAN_SECOND_FAMILY_NAME)) {
					ostr << " " << integrationModel->GlobalVariables.GetValue(GKDI_REFERRING_PHISICIAN_SECOND_FAMILY_NAME);
				}
				ostr << "^" << integrationModel->GlobalVariables.GetValue(GKDI_REFERRING_PHISICIAN_NAME);
				integrationModel->TagsDICOMOverwrite.tags["0008|0090"] = ostr.str();
			}
			if (integrationModel->GlobalVariables.Contains(GKDI_REFERRING_PHISICIAN_INSTITUTION_NAME)) {
				integrationModel->TagsDICOMOverwrite.tags["0008|0080"] = integrationModel->GlobalVariables.GetValue(GKDI_REFERRING_PHISICIAN_INSTITUTION_NAME);
			}

			GIL::IntegrationModelList list;
			list.push_back(integrationModel);
			GIL::IntegrationController::Instance()->Process(list);

			result["error"] = 0;
		}

		std::string help() { return std::string("Retrieve files from PACS"); }
	};
	//---------------------------------------------------------------------------------------------------
	// "DBWindowFind" executes actions over series, images or studies
	// LaunchOpenDeleteSeriesCommand it's necessary to open and delete series or studies from the history
	class LaunchOpenDeleteSeriesCommand : public GNC::GCS::IComando {
	public:
		LaunchOpenDeleteSeriesCommand(const std::list<std::string>& uidsSerie, bool open) : IComando(NULL)
		{
			SetId(IDC_RPC);
			m_uidsSerie = uidsSerie;
			m_open = open;
		}

		virtual void Execute() {}

		virtual void Update()
		{
			if (m_open) {
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EvtHandleDicom(m_uidsSerie, GNC::GCS::Eventos::EvtHandleDicom::OpenSeries));
			} else {
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EvtHandleDicom(m_uidsSerie, GNC::GCS::Eventos::EvtHandleDicom::DeleteSeries));
			}
		}
		std::list<std::string> m_uidsSerie;
		bool m_open;
	};

	//DBWindowFind xml rpc method, parses params and throws command if necessary
	//it processes four actions Open->open series (from study or from image), Delete->deletes series, nothing->makes an sql request, select->not implemented
	//
	class DBWindowFind : public XmlRpcServerMethod
	{
	public:
		DBWindowFind(XmlRpcServer* s) : XmlRpcServerMethod("DBWindowFind", s) {}

		void execute(XmlRpcValue& params, XmlRpcValue& result)
		{
			//Open opens series
			std::string action = std::string(params[0]["execute"]);
			std::string table = std::string(params[0]["table"]);
			std::string request = std::string(params[0]["request"]);
			try {
				if (action == "Open" || action == "Delete") {
					std::list<std::string> seriesUidList;
					if (table == "Series" || table == "Study") {
						GNC::GCS::IControladorHistorial::ListaModelosSeries modelList;
						GNC::GCS::ControladorHistorial::Instance()->GetSeriesModelSql(request, modelList);
						for (GNC::GCS::IControladorHistorial::ListaModelosSeries::iterator it = modelList.begin(); it != modelList.end(); ++it)
						{
							seriesUidList.push_back((*it).m_uidSerie);
						}
					} else if (table == "Image") {
						if (action == "Open") {
							GNC::GCS::IControladorHistorial::ListaModelosDCM modelList;
							std::set<std::string> uidSet;
							GNC::GCS::ControladorHistorial::Instance()->GetDCMModelSql(request, modelList);
							for (GNC::GCS::IControladorHistorial::ListaModelosDCM::iterator it = modelList.begin(); it != modelList.end(); ++it)
							{
								if (uidSet.find((*it).m_uidSerie) == uidSet.end()) {
									seriesUidList.push_back((*it).m_uidSerie);
									uidSet.insert((*it).m_uidSerie);
								}
							}
						} else {
							result["error"] = -1; //not implemented
							return;
						}
					}
					if (action == "Open") {
						GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Opening series..."), new LaunchOpenDeleteSeriesCommand(seriesUidList,true), NULL);
					} else {
						GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Deleting series..."), new LaunchOpenDeleteSeriesCommand(seriesUidList,false), NULL);
					}
					result["error"] = 0;
				} else if (action == "Nothing") {
					if (table == "Study") {
						GNC::GCS::IControladorHistorial::ListaModelosEstudios modelList;
						GNC::GCS::ControladorHistorial::Instance()->GetStudyModelSql(request, modelList);
						int i = 0;
						for (GNC::GCS::IControladorHistorial::ListaModelosEstudios::iterator it = modelList.begin(); it != modelList.end(); ++it) {
							result["elements"][i]["studyInstanceUID"] = (*it).m_uidEstudio;
							result["elements"][i]["StudyDescription"] = (*it).m_descripcionEstudio;
							result["elements"][i]["StudyDate"] = (*it).m_fechaEstudio;
							result["elements"][i++]["StudyTime"] = (*it).m_horaEstudio;
						}

					} else if (table == "Series") {
						GNC::GCS::IControladorHistorial::ListaModelosSeries modelList;
						GNC::GCS::ControladorHistorial::Instance()->GetSeriesModelSql(request, modelList);
						int i = 0;
						for (GNC::GCS::IControladorHistorial::ListaModelosSeries::iterator it = modelList.begin(); it != modelList.end(); ++it) {
							//patient info
							result["elements"][i]["PatientID"] = (*it).m_idPaciente;
							result["elements"][i]["PatientName"] = (*it).m_nombrePaciente;
							result["elements"][i]["PatientSex"] = (*it).m_sexo;
							//study info
							result["elements"][i]["studyInstanceUID"] = (*it).m_uidEstudio;
							result["elements"][i]["StudyDescription"] = (*it).m_descripcionEstudio;
							result["elements"][i]["StudyDate"] = (*it).m_fechaEstudio;
							result["elements"][i]["StudyTime"] = (*it).m_horaEstudio;
							//series info
							result["elements"][i]["seriesInstanceUID"] = (*it).m_uidSerie;
							result["elements"][i]["SeriesDescription"] = (*it).m_descripcionSerie;
							result["elements"][i]["SeriesDate"] = (*it).m_fechaSerie;
							result["elements"][i]["SeriesTime"] = (*it).m_horaSerie;
							result["elements"][i++]["SeriesModality"] = (*it).m_modalidad;
						}
					} else if (table == "Image") {
						GNC::GCS::IControladorHistorial::ListaModelosDCM modelList;
						std::set<std::string> uidSet;
						GNC::GCS::ControladorHistorial::Instance()->GetDCMModelSql(request, modelList);
						int i = 0;
						for (GNC::GCS::IControladorHistorial::ListaModelosDCM::iterator it = modelList.begin(); it != modelList.end(); ++it) {
							//patient info
							result["elements"][i]["PatientID"] = (*it).m_idPaciente;
							result["elements"][i]["PatientName"] = (*it).m_nombrePaciente;
							result["elements"][i]["PatientSex"] = (*it).m_sexo;
							//study info
							result["elements"][i]["studyInstanceUID"] = (*it).m_uidEstudio;
							result["elements"][i]["StudyDescription"] = (*it).m_descripcionEstudio;
							result["elements"][i]["StudyDate"] = (*it).m_fechaEstudio;
							result["elements"][i]["StudyTime"] = (*it).m_horaEstudio;
							//series info
							result["elements"][i]["seriesInstanceUID"] = (*it).m_uidSerie;
							result["elements"][i]["SeriesDescription"] = (*it).m_descripcionSerie;
							result["elements"][i]["SeriesDate"] = (*it).m_fechaSerie;
							result["elements"][i]["SeriesTime"] = (*it).m_horaSerie;
							result["elements"][i++]["SeriesModality"] = (*it).m_modalidad;
						}
					}
				} else if (action == "Select") {
					//TODO, select in the medical history
				}
				result["error"] = 0;
			}
			catch (wxSQLite3Exception& ex1) {
				LOG_ERROR(LOGGER, "SQL error executing DBWindowFind " <<ex1.GetMessage().ToUTF8());
				result["error"] = "Wrong sql syntax";
			}
			catch (std::exception ex) {
				LOG_ERROR(LOGGER, "SQL error executing DBWindowFind " << ex.what());
				result["error"] = "Wrong sql syntax";
			}
		}

		std::string help() { return std::string("open, delete and look up series, studies, patient..."); }

	};
	//---------------------------------------------------------------------------------------------------
	//---------------------------------------------------------------------------------------------------
}
//


void GIL::XMLRPC::XMLRPCController::FreeInstance()
{
	wxCriticalSectionLocker locker(m_criticalSection);
	if(m_pInstance != NULL){
		LOG_DEBUG(LOGGER, "Stopping XML-RPC Server");
		m_pInstance->Abort();
		m_pInstance = NULL;
	}
}

void GIL::XMLRPC::XMLRPCController::StartServer()
{
	bool boolValue;
	GNC::GCS::ConfigurationController::Instance()->readBoolGeneral("/GinkgoCore/HCE", "XMLRPCServerEnabled", boolValue, false);

	if (boolValue) {
		wxCriticalSectionLocker locker(m_criticalSection);		
		if (m_pInstance == NULL) {
			m_pInstance = new GIL::XMLRPC::XMLRPCController();
			m_pInstance->Create();
			GNC::GCS::Threading::SetThreadName( m_pInstance->GetId(), "XML-RPCServer");
			wxThreadError error = m_pInstance->Run();
			if(error != wxTHREAD_NO_ERROR) {
				LOG_ERROR(LOGGER, "Error running XML-RPC Server")
			} else {
				LOG_INFO(LOGGER, "Running XML-RPC Server")
			}
		} else {
			m_pInstance->Abort();
			m_pInstance = new GIL::XMLRPC::XMLRPCController();
			m_pInstance->Create();
			GNC::GCS::Threading::SetThreadName( m_pInstance->GetId(), "XML-RPCServer");
			wxThreadError error = m_pInstance->Run();
			if(error != wxTHREAD_NO_ERROR) {
				LOG_ERROR(LOGGER, "Error running XML-RPC Server")
			} else {
				LOG_INFO(LOGGER, "Running XML-RPC Server")
			}
		}
	}
}


GIL::XMLRPC::XMLRPCController* GIL::XMLRPC::XMLRPCController::m_pInstance = NULL;
wxCriticalSection GIL::XMLRPC::XMLRPCController::m_criticalSection;

//proceso que envia mensajes
GIL::XMLRPC::XMLRPCController::XMLRPCController() : wxThread(wxTHREAD_DETACHED)
{
	m_pServer = new XmlRpc::XmlRpcServer();
	m_pLogHandler = new XmlRpc::GinkgoLogHandler();

}

GIL::XMLRPC::XMLRPCController::~XMLRPCController()
{
	m_pServer->shutdown(true);
	delete m_pServer;
	m_pServer = NULL;
	delete m_pLogHandler;
	m_pLogHandler = NULL;
}

void GIL::XMLRPC::XMLRPCController::Abort()
{
	m_pServer->exit();
	m_pServer->shutdown(true);
}

void* GIL::XMLRPC::XMLRPCController::Entry()
{
	
//TODO it doesn't work with ControladorLog, throws an exception in the client
//	XmlRpc::XmlRpcLogHandler::setLogHandler(m_pLogHandler);
	XmlRpc::XmlRpcLogHandler::setVerbosity(5);

	int port;
	if (GNC::GCS::ConfigurationController::Instance()->readIntGeneral("/GinkgoCore/HCE","XMLRPCServerPort", port))
	{
		//register methods
		XmlRpc::CloseAllWindows closeAll(m_pServer);
		XmlRpc::OpenDB openDB(m_pServer);
		XmlRpc::GetDisplayed2DViewerSeries displayedSeries(m_pServer);
		XmlRpc::GetDisplayed2DViewerStudies displayedStudies(m_pServer);
		XmlRpc::Close2DViewerWithSeriesUID closeSeries(m_pServer);
		XmlRpc::Close2DViewerWithStudyUID closeStudy(m_pServer);
		XmlRpc::CMove cMove(m_pServer);
		XmlRpc::Dicomize dicomize(m_pServer);
		XmlRpc::DBWindowFind find(m_pServer);

		m_pServer->bindAndListen(port);

		// Enable introspection
		m_pServer->enableIntrospection(true);

		m_pServer->work(-1);
		
	} else {
		LOG_ERROR(LOGGER, "XML-RPC port is not a valid integer")
	}
	wxCriticalSectionLocker locker(m_criticalSection);
	m_pInstance = NULL;

	return NULL;
}





