/*
 *  
 *  $Id: controladorherramientas.h 4506 2012-01-11 11:21:21Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/api.h>
#include <api/globals.h>
#include <api/ibutton.h>
#include <string>
#include <map>
#include <api/icontroladorherramientas.h>
#include <api/imodulo.h>
#include <api/iherramienta.h>
#include <api/observers/iviewsobserver.h>
#include <api/observers/iextensionsobserver.h>


class wxAuiToolBar;
class wxXmlNode;

namespace GNC {
	namespace GUI {
		class BarraHerramientasDerecha;
		class EventHandlerKeyToolsController;
	}

	class EXTAPI ControladorHerramientas :
		public GNC::GCS::IControladorHerramientas,
		public GNC::GCS::ISolicitadorCambioHerramienta,
		public GNC::GCS::IObservadorVistas,
		public GNC::GCS::IObservadorExtensiones {

//------------------------------------------------------------------------------
//region "Patron singleton"
	public:
		static ControladorHerramientas* Instance();
		static void FreeInstance();

	protected:
		ControladorHerramientas();
		~ControladorHerramientas();

		static ControladorHerramientas* m_pInstance;

//endregion

//------------------------------------------------------------------------------
//region "Realizacion de la interfaz IControladorHerramientas"
	public:
		/* Registra una herramienta */
		virtual void RegistrarHerramienta(GNC::GCS::IHerramienta* herramienta);

		/* Des-Registra una herramienta */
		virtual void DesRegistrarHerramienta(GNC::GCS::IHerramienta* herramienta);

		/*Uses id wx*/
		virtual GNC::GCS::IHerramienta* ObtenerHerramientaWx(long id);
		/* Obtiene la referencia concreta a una herramienta. */
		virtual GNC::GCS::IHerramienta* ObtenerHerramienta(GNC::GCS::IHerramienta::UID id);

		/* Refresca las propiedades (visibilidad, etc) de las herramientas frente a cambios de estado */
		virtual void RefrescarHerramientas();

		/*Devuelve las herramientas registradas*/
		ListaHerramientas GetHerramientas();

		/*Devuelve las herramientas registradas ordenadas por categorias y subcategorias*/
		TMapaHerramientasOrdenadas GetHerramientasOrdenadas();

		/*Desserializa el xml y lo asocia a los contratos de la vista que se le pasa como parametro en la posicion indicada*/
		virtual void Deserializar(GNC::GCS::IVista* pVista, int posicion, wxXmlNode* root, const std::string& sopInstanceUID);

		/*Serializa las herramientas asociadas a la vista y posicion que se le pasa como parametro y lo agrega al nodo*/
		virtual void Serializar(GNC::GCS::IVista* pVista, int posicion, wxXmlNode* root, const std::string& nombreMedicoSerializa, const std::string& sopInstanceUID);

		/*Devuelve las herramientas registradas que que son opciones de menu*/


//endregion

//------------------------------------------------------------------------------
//region "Realizacion de interfaz de observacion de extensiones"

	public:
		virtual void OnModuloCargado(GNC::GCS::IControladorModulo* pControladorModulo);

		virtual void OnModuloDescargado(GNC::GCS::IControladorModulo* pControladorModulo);

//endregion

//------------------------------------------------------------------------------
//region "Realización de interfaz de observación de vistas"

	public:
		virtual void OnVistaActivada(GNC::GCS::IVista* pVista);


//endregion

//------------------------------------------------------------------------------
//region "Interactuacion con herramientas"
	public:
		/* Activa la herramienta por defecto del módulo */
		virtual void ActivarHerramientaPorDefecto(GNC::GCS::IControladorModulo* pModulo);

		/* Activa la herramienta especificada al módulo especificado. pHerramienta puede ser NULL */
		virtual void ActivarHerramienta(GNC::GCS::IControladorModulo* pModulo, GNC::GCS::IHerramienta::UID id, int buttonmask);


//endregion

//------------------------------------------------------------------------------
//region "Interfaz de ISolicitadorCambioHerramienta"
	public:
		virtual void SolicitarActivacion(GNC::GCS::IHerramienta* herramienta, const GNC::GCS::TriggerButton& buttonmask);

//endregion

//region "BARRA DE HERRAMIENTAS"
		virtual void OnActivarHerramienta(long toolId, const GNC::GCS::TriggerButton& buttonmask);
		virtual void OnKeyAccelerator(wxKeyEvent& event);
//endregion

//------------------------------------------------------------------------------
//region "Helpers"
	private:
		wxAuiToolBar* GetBarraHerramientasFamilia(GNC::GCS::IHerramienta::TFamiliasHerramientas familia); 
		void FreezeBarrasHerramientas();
		void ThawBarrasHerramientas();
		void ReconstruirBarrasHerramientas(bool rebuild);

//endregion

//------------------------------------------------------------------------------
//region "Atributos"
	public:
		typedef std::map<GNC::GCS::IControladorModulo*, GNC::GCS::IHerramienta*> HerramientaActivas;
		typedef std::map<GNC::GCS::IHerramienta::UID, GNC::GCS::IHerramienta*> MapaHerramientas;

		unsigned long GetIdWx(unsigned long idHerramienta);
		unsigned long GetId(unsigned long idWxHerramienta);

	protected:

		bool MostrarHerramientaBarra(GNC::GCS::IHerramienta* pHerramienta,bool mostrar);
		void HabilitarHerramientaBarra(GNC::GCS::IHerramienta* pHerramienta, bool habilitar);
		void ActivarHerramientaBarra(GNC::GCS::IHerramienta* pHerramienta, bool activar);
		

		HerramientaActivas            m_HerramientaActivaBotonIzquierdo;
		HerramientaActivas            m_HerramientaActivaBotonDerecho;
		MapaHerramientas              m_Herramientas;
		GNC::GUI::BarraHerramientasDerecha*	m_pBarraHerramientasDerecha;

		// Cache con vista y modulo activo. Se actualizan mediante el observador de vistas, en base al cambio de vista.
		// La vista asigna como modulo activo el controlador de modulo de su controlador de estudio asociado.
		GNC::GCS::IVista*             m_pVistaActiva;
		GNC::GCS::IControladorModulo* m_pModuloActivo;

		GNC::GUI::EventHandlerKeyToolsController* m_pKeyEventHandler;
		// Mapa entre id_de_wxwidgets => id de herramientas para resolver ids de herramientas desde el manejador de evento.
		int                           m_contadorHerramientas;
		typedef std::map<unsigned long, unsigned long> MapaIdsHerramientas;
		MapaIdsHerramientas m_MapaIdsHerramientas;
		typedef std::map<GNC::GCS::IHerramienta::TFamiliasHerramientas, AUI_NAMESPACE wxAuiToolBar*> MapaBarrasHerramientas;
		MapaBarrasHerramientas m_MapaBarrasHerramientas;

//endregion
	};
}

