/*
*  
*  $Id: itoolslider.h 4468 2011-12-09 10:02:00Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/iherramienta.h>
#include "icontratoscore.h"
#include "iherramientascore.h"


namespace GNC {
	namespace GCS {

		class EXTAPI IToolSlider: public IHerramienta, public IContratable<IContratoWidgets>, public IContratable<IContractSlider> {
		public:
			typedef IContratoWidgets               TContratoWidgets;
			typedef IContractSlider                TContractTool;
			typedef IContratable<TContratoWidgets> TContractableWidgets;
			typedef IContratable<TContractTool>    TContractableTool;

			static const IHerramienta::UID ID = HCore_Slider;
			IToolSlider() : IHerramienta(HCore_Slider,TFamiliaVisualizacion, "CoreSlider") {};
			virtual ~IToolSlider() {};

			virtual void SetVistaActiva(GNC::GCS::IVista* pVista) = 0;

			virtual void ConectarContratos(bool) = 0;

			virtual bool ValidaContratos(GNC::GCS::IVista* pVista) {
				return TContractableWidgets::ValidaContrato(pVista) && TContractableTool::ValidaContrato(pVista);
			}
			
		};
	}
}
